<p>When executing an OS command and unless you specify the full path to the executable, then the locations in your application’s <code>PATH</code>
environment variable will be searched for the executable. That search could leave an opening for an attacker if one of the elements in
<code>PATH</code> is a directory under his control.</p>
<h2>Ask Yourself Whether</h2>
<ul>
  <li> The directories in the PATH environment variable may be defined by not trusted entities. </li>
</ul>
<p>There is a risk if you answered yes to this question.</p>
<h2>Recommended Secure Coding Practices</h2>
<p>Fully qualified/absolute path should be used to specify the OS command to execute.</p>
<h2>Sensitive Code Example</h2>
<pre>
Process p = new Process();
p.StartInfo.FileName = "binary"; // Sensitive
</pre>
<h2>Compliant Solution</h2>
<pre>
Process p = new Process();
p.StartInfo.FileName = @"C:\Apps\binary.exe"; // Compliant
</pre>
<h2>See</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A08_2021-Software_and_Data_Integrity_Failures/">Top 10 2021 Category A8 - Software and Data Integrity
  Failures</a> </li>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A1_2017-Injection">Top 10 2017 Category A1 - Injection</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/426">CWE-426 - Untrusted Search Path</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/427">CWE-427 - Uncontrolled Search Path Element</a> </li>
</ul>

