﻿# SA1026

<table>
<tr>
  <td>TypeName</td>
  <td>SA1026CodeMustNotContainSpaceAfterNewKeywordInImplicitlyTypedArrayAllocation</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1026</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

An implicitly typed array allocation within a C# code file is not spaced correctly.

## Rule description

A violation of this rule occurs whenever the code contains an implicitly-typed array allocation which is not spaced correctly. Within an implicitly typed array allocation, there should not be any space or a blank line between the `new` or `stackalloc` keyword and the opening array bracket. For example:

```csharp
var a = new[] { 1, 10, 100, 1000 };
Span<int> a = stackalloc[] { 1, 10, 100, 1000 };
```

## How to fix violations

To fix a violation of this rule, remove any whitespace between the `new` or `stackalloc` keyword and the opening array bracket.

## How to suppress violations

```csharp
#pragma warning disable SA1026 // Code should not contain space after new or stackalloc keyword in implicitly typed array allocation
var ints = new [] { 1, 2, 3 };
#pragma warning restore SA1026 // Code should not contain space after new or stackalloc keyword in implicitly typed array allocation
```
