﻿## SA1109

<table>
<tr>
  <td>TypeName</td>
  <td>SA1109BlockStatementsMustNotContainEmbeddedRegions</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1109</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

:warning: This rule has been intentionally omitted from StyleCop Analyzers. See [KnownChanges.md](KnownChanges.md) for
additional information.

## Cause

A C# statement contains a region tag between the declaration of the statement and the opening brace of the statement.

## Rule description

A violation of this rule occurs when the code contains a region tag in between the declaration and the opening brace. For example:

```csharp
if (x != y)
#region
{
}
#endregion
```

This will result in the body of the statement being hidden when the region is collapsed.

## How to fix violations

To fix a violation of this rule, remove the region or move it outside of the statement.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1109:BlockStatementsMustNotContainEmbeddedRegions", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1109 // BlockStatementsMustNotContainEmbeddedRegions
#pragma warning restore SA1109 // BlockStatementsMustNotContainEmbeddedRegions
```
