﻿## SA1506

<table>
<tr>
  <td>TypeName</td>
  <td>SA1506ElementDocumentationHeadersMustNotBeFollowedByBlankLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1506</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

An element documentation header above a C# element is followed by a blank line.

## Rule description

To improve the readability of the code, StyleCop requires blank lines in certain situations, and prohibits blank lines in other situations. This results in a consistent visual pattern across the code, which can improve recognition and readability of unfamiliar code.

A violation of this rule occurs when the element documentation header above an element is followed by a blank line. For example:

```csharp
/// <summary>
/// Gets a value indicating whether the control is enabled.
/// </summary>

public bool Enabled
{
    get { return this.enabled; }
}
```

The code above would generate an instance of this violation, since the documentation header is followed by a blank line.

## How to fix violations

To fix a violation of this rule, remove the blank line following the documentation header.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1506:ElementDocumentationHeadersMustNotBeFollowedByBlankLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1506 // ElementDocumentationHeadersMustNotBeFollowedByBlankLine
#pragma warning restore SA1506 // ElementDocumentationHeadersMustNotBeFollowedByBlankLine
```
