<h2>Why is this an issue?</h2>
<p>A common code smell that can hinder the clarity of source code is making assignments within sub-expressions. This practice involves assigning a
value to a variable inside a larger expression, such as within a loop or a conditional statement.</p>
<p>This practice essentially gives a side-effect to a larger expression, thus making it less readable. This often leads to confusion and potential
errors.</p>
<h3>Exceptions</h3>
<p>This rule ignores assignments in conditions of <code>while</code> statements and assignments enclosed in relational expressions.</p>

```java
void processInput(BufferedReader br) {
  String line;
  while ((line = br.readLine()) != null) {
    processLine(line);
  }
}

Object foo;
if ((foo = bar()) != null) {
  // do something with "foo"
}
```
<p>This rule also ignores chained assignments, including compound assignments.</p>

```java
int j, i = j = 0;
int k = (j += 1);
byte[] result, bresult;
result = (bresult = new byte[len]);
```
<h2>How to fix it</h2>
<p>Making assignments within sub-expressions can hinder the clarity of source code.</p>
<p>This practice essentially gives a side-effect to a larger expression, thus making it less readable. This often leads to confusion and potential
errors.</p>
<p>Extracting assignments into separate statements is encouraged to keep the code clear and straightforward.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
String str;
if (!(str = cont.substring(pos1, pos2)).isEmpty()) {  // Noncompliant
  // do something with "str"
}
```
<h4>Compliant solution</h4>

```java
String str = cont.substring(pos1, pos2);
if (!str.isEmpty()) {
  // do something with "str"
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/481">CWE-481 - Assigning instead of Comparing</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/ITZGBQ">CERT, EXP51-J.</a> - Do not perform assignments in conditional expressions </li>
</ul>