<h2>Why is this an issue?</h2>
<p><code>getClass</code> should not be used for synchronization in non-<code>final</code> classes because child classes will synchronize on a
different object than the parent or each other, allowing multiple threads into the code block at once, despite the <code>synchronized</code>
keyword.</p>
<p>Instead, hard code the name of the class on which to synchronize or make the class <code>final</code>.</p>
<h3>Noncompliant code example</h3>

```java
public class MyClass {
  public void doSomethingSynchronized(){
    synchronized (this.getClass()) {  // Noncompliant
      // ...
    }
  }
```
<h3>Compliant solution</h3>

```java
public class MyClass {
  public void doSomethingSynchronized(){
    synchronized (MyClass.class) {
      // ...
    }
  }
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/qTdGBQ">CERT, LCK02-J.</a> - Do not synchronize on the class object returned by getClass() </li>
</ul>