<h2>Why is this an issue?</h2>
<p>The <code>java.util.function</code> package provides a large array of functional interface definitions for use in lambda expressions and method
references. In general it is recommended to use the more specialised form to avoid auto-boxing. For instance <code>IntFunction&lt;Foo&gt;</code>
should be preferred over <code>Function&lt;Integer, Foo&gt;</code>.</p>
<p>This rule raises an issue when any of the following substitution is possible:</p>
<table>
  <colgroup>
    <col style="width: 50%;">
    <col style="width: 50%;">
  </colgroup>
  <thead>
    <tr>
      <th>Current Interface</th>
      <th>Preferred Interface</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><p><code>Function&lt;Integer, R&gt;</code></p></td>
      <td><p><code>IntFunction&lt;R&gt;</code></p></td>
    </tr>
    <tr>
      <td><p><code>Function&lt;Long, R&gt;</code></p></td>
      <td><p><code>LongFunction&lt;R&gt;</code></p></td>
    </tr>
    <tr>
      <td><p><code>Function&lt;Double, R&gt;</code></p></td>
      <td><p><code>DoubleFunction&lt;R&gt;</code></p></td>
    </tr>
    <tr>
      <td><p><code>Function&lt;Double,Integer&gt;</code></p></td>
      <td><p><code>DoubleToIntFunction</code></p></td>
    </tr>
    <tr>
      <td><p><code>Function&lt;Double,Long&gt;</code></p></td>
      <td><p><code>DoubleToLongFunction</code></p></td>
    </tr>
    <tr>
      <td><p><code>Function&lt;Long,Double&gt;</code></p></td>
      <td><p><code>LongToDoubleFunction</code></p></td>
    </tr>
    <tr>
      <td><p><code>Function&lt;Long,Integer&gt;</code></p></td>
      <td><p><code>LongToIntFunction</code></p></td>
    </tr>
    <tr>
      <td><p><code>Function&lt;R,Integer&gt;</code></p></td>
      <td><p><code>ToIntFunction&lt;R&gt;</code></p></td>
    </tr>
    <tr>
      <td><p><code>Function&lt;R,Long&gt;</code></p></td>
      <td><p><code>ToLongFunction&lt;R&gt;</code></p></td>
    </tr>
    <tr>
      <td><p><code>Function&lt;R,Double&gt;</code></p></td>
      <td><p><code>ToDoubleFunction&lt;R&gt;</code></p></td>
    </tr>
    <tr>
      <td><p><code>Function&lt;T,T&gt;</code></p></td>
      <td><p><code>UnaryOperator&lt;T&gt;</code></p></td>
    </tr>
    <tr>
      <td><p><code>BiFunction&lt;T,T,T&gt;</code></p></td>
      <td><p><code>BinaryOperator&lt;T&gt;</code></p></td>
    </tr>
    <tr>
      <td><p><code>Consumer&lt;Integer&gt;</code></p></td>
      <td><p><code>IntConsumer</code></p></td>
    </tr>
    <tr>
      <td><p><code>Consumer&lt;Double&gt;</code></p></td>
      <td><p><code>DoubleConsumer</code></p></td>
    </tr>
    <tr>
      <td><p><code>Consumer&lt;Long&gt;</code></p></td>
      <td><p><code>LongConsumer</code></p></td>
    </tr>
    <tr>
      <td><p><code>BiConsumer&lt;T,Integer&gt;</code></p></td>
      <td><p><code>ObjIntConsumer&lt;T&gt;</code></p></td>
    </tr>
    <tr>
      <td><p><code>BiConsumer&lt;T,Long&gt;</code></p></td>
      <td><p><code>ObjLongConsumer&lt;T&gt;</code></p></td>
    </tr>
    <tr>
      <td><p><code>BiConsumer&lt;T,Double&gt;</code></p></td>
      <td><p><code>ObjDoubleConsumer&lt;T&gt;</code></p></td>
    </tr>
    <tr>
      <td><p><code>Predicate&lt;Integer&gt;</code></p></td>
      <td><p><code>IntPredicate</code></p></td>
    </tr>
    <tr>
      <td><p><code>Predicate&lt;Double&gt;</code></p></td>
      <td><p><code>DoublePredicate</code></p></td>
    </tr>
    <tr>
      <td><p><code>Predicate&lt;Long&gt;</code></p></td>
      <td><p><code>LongPredicate</code></p></td>
    </tr>
    <tr>
      <td><p><code>Supplier&lt;Integer&gt;</code></p></td>
      <td><p><code>IntSupplier</code></p></td>
    </tr>
    <tr>
      <td><p><code>Supplier&lt;Double&gt;</code></p></td>
      <td><p><code>DoubleSupplier</code></p></td>
    </tr>
    <tr>
      <td><p><code>Supplier&lt;Long&gt;</code></p></td>
      <td><p><code>LongSupplier</code></p></td>
    </tr>
    <tr>
      <td><p><code>Supplier&lt;Boolean&gt;</code></p></td>
      <td><p><code>BooleanSupplier</code></p></td>
    </tr>
    <tr>
      <td><p><code>UnaryOperator&lt;Integer&gt;</code></p></td>
      <td><p><code>IntUnaryOperator</code></p></td>
    </tr>
    <tr>
      <td><p><code>UnaryOperator&lt;Double&gt;</code></p></td>
      <td><p><code>DoubleUnaryOperator</code></p></td>
    </tr>
    <tr>
      <td><p><code>UnaryOperator&lt;Long&gt;</code></p></td>
      <td><p><code>LongUnaryOperator</code></p></td>
    </tr>
    <tr>
      <td><p><code>BinaryOperator&lt;Integer&gt;</code></p></td>
      <td><p><code>IntBinaryOperator</code></p></td>
    </tr>
    <tr>
      <td><p><code>BinaryOperator&lt;Long&gt;</code></p></td>
      <td><p><code>LongBinaryOperator</code></p></td>
    </tr>
    <tr>
      <td><p><code>BinaryOperator&lt;Double&gt;</code></p></td>
      <td><p><code>DoubleBinaryOperator</code></p></td>
    </tr>
    <tr>
      <td><p><code>Function&lt;T, Boolean&gt;</code></p></td>
      <td><p><code>Predicate&lt;T&gt;</code></p></td>
    </tr>
    <tr>
      <td><p><code>BiFunction&lt;T,U,Boolean&gt;</code></p></td>
      <td><p><code>BiPredicate&lt;T,U&gt;</code></p></td>
    </tr>
  </tbody>
</table>
<h3>Noncompliant code example</h3>

```java
public class Foo implements Supplier<Integer> {  // Noncompliant
    @Override
    public Integer get() {
      // ...
    }
}
```
<h3>Compliant solution</h3>

```java
public class Foo implements IntSupplier {

  @Override
  public int getAsInt() {
    // ...
  }
}
```