<h2>Why is this an issue?</h2>
<p>In JavaScript, a setter is a special type of function that is used to set the value of a property on an object. Setters are defined using the
<code>set</code> keyword followed by the name of the property that the setter is associated with.</p>
<p>To set the property, we simply assign a value to it as if it were a regular property. The setter function is automatically called with the value
that we assign to the property.</p>
<p>Functions declared with the <code>set</code> keyword will automatically return the values they were passed. Thus any value explicitly returned from
a setter will be ignored, and explicitly returning a value is a mistake.</p>

```js
let person = {
  // ...
  set firstname(first) {
    this.first = first;
    return 42;  // Noncompliant: The return value 42 will be ignored
  }
};
console.log(person.firstname = 'bob'); // Prints 'bob'
```
<p>Since return values in setters are ignored, you should remove return statements altogether.</p>

```js
let person = {
  // ...
  set firstname(first) {
    this.first = first;
  }
};
console.log(person.firstname = 'bob'); // Prints 'bob'
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/set">set</a> </li>
</ul>