<h2>Why is this an issue?</h2>
<p>The magic of JavaScript is that you can pass arguments to functions that don’t declare parameters, and on the other side, you can use those
passed-in arguments inside the no-args <code>function</code>.</p>
<p>But just because you can, that does’t mean you should. The expectation and use of arguments inside functions that don’t explicitly declare them is
confusing to callers. No one should ever have to read and fully understand a function to be able to use it competently.</p>
<p>If you don’t want to name arguments explicitly, use the <code>...</code> syntax to specify that an a variable number of arguments is expected. Then
inside the function, you’ll be dealing with a first-class array, rather than an array-like structure.</p>
<h3>Noncompliant code example</h3>

```js
function concatenate() {
  let args = Array.prototype.slice.call(arguments);  // Noncompliant
  return args.join(', ');
}

function doSomething(isTrue) {
  var args = Array.prototype.slice.call(arguments, 1); // Noncompliant
  if (!isTrue) {
    for (var arg of args) {
      ...
    }
  }
}
```
<h3>Compliant solution</h3>

```js
function concatenate(...args) {
  return args.join(', ');
}

function doSomething(isTrue, ...values) {
  if (!isTrue) {
    for (var value of values) {
      ...
    }
  }
}
```