<h2>Why is this an issue?</h2>
<p>Assertions are statements that check whether certain conditions are true. They are used to validate that the actual results of a code snippet match
the expected outcomes. By using assertions, developers can ensure that their code behaves as intended and identify potential bugs or issues early in
the development process.</p>
<p>In Chai.js, there is no inherent problem with giving the same argument twice in an assertion. It won’t cause any errors or issues in the test
execution itself. The test will still run and pass as long as the assertion is correct.</p>
<p>However, having the same argument twice in an assertion might indicate a design issue or a potential mistake in your test. In most cases, you don’t
need to compare a variable to itself in a test, as it doesn’t provide any meaningful validation and is likely to be a bug due to the developer’s
carelessness.</p>
<p>This rule raises an issue when a Chai assertion is given twice the same argument.</p>

```js
const assert = require('chai').assert;

describe("test the same object", function() {
    it("uses chai 'assert'", function() {
        const expected = '1';
        const actual = (1).toString();
        assert.equal(actual, actual); // Noncompliant: Asserting the same argument
    });
});
```
<p>Make sure that the arguments of your assertions are not the same.</p>

```js
const assert = require('chai').assert;

describe("test the same object", function() {
    it("uses chai 'assert'", function() {
        const expected = '1';
        const actual = (1).toString();
        assert.equal(actual, expected);
    });
});
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Chai.js Documentation - <a href="https://www.chaijs.com/api/">API Reference</a> </li>
</ul>