<h2>Why is this an issue?</h2>
<p>Having all branches of a <code>when</code> or <code>if</code> chain with the same implementation indicates a problem.</p>
<p>In the following code:</p>

```kotlin
if (b == 0) {  // Noncompliant
     doOneMoreThing()
} else {
     doOneMoreThing()
}

when (i) {  // Noncompliant
    1 -> doSomething()
    2 -> doSomething()
    3 -> doSomething()
    else -> doSomething()
}
```
<p>Either there is a copy-paste error that needs fixing or an unnecessary <code>when</code> or <code>if</code> chain that needs removing.</p>
<h3>Exceptions</h3>
<p>This rule does not apply to <code>if</code> chains without <code>else</code>, nor to <code>when</code> without an <code>else</code> clause.</p>

```kotlin
if (b == 0) {
    doOneMoreThing()
} else if (b == 1) {
    doOneMoreThing()
}
```