<h2>Why is this an issue?</h2>
<p>Developers often use <code>TODO</code> tags to mark areas in the code where additional work or improvements are needed but are not implemented
immediately. However, these <code>TODO</code> tags sometimes get overlooked or forgotten, leading to incomplete or unfinished code. This rule aims to
identify and address unattended <code>TODO</code> tags to ensure a clean and maintainable codebase. This description explores why this is a problem
and how it can be fixed to improve the overall code quality.</p>
<h3>What is the potential impact?</h3>
<p>Unattended <code>TODO</code> tags in code can have significant implications for the development process and the overall codebase.</p>
<p>Incomplete Functionality: When developers leave <code>TODO</code> tags without implementing the corresponding code, it results in incomplete
functionality within the software. This can lead to unexpected behavior or missing features, adversely affecting the end-user experience.</p>
<p>Missed Bug Fixes: If developers do not promptly address <code>TODO</code> tags, they might overlook critical bug fixes and security updates.
Delayed bug fixes can result in more severe issues and increase the effort required to resolve them later.</p>
<p>Impact on Collaboration: In team-based development environments, unattended <code>TODO</code> tags can hinder collaboration. Other team members
might not be aware of the intended changes, leading to conflicts or redundant efforts in the codebase.</p>
<p>Codebase Bloat: The accumulation of unattended <code>TODO</code> tags over time can clutter the codebase and make it difficult to distinguish
between work in progress and completed code. This bloat can make it challenging to maintain an organized and efficient codebase.</p>
<p>Addressing this code smell is essential to ensure a maintainable, readable, reliable codebase and promote effective collaboration among
developers.</p>
<h3>Noncompliant code example</h3>

```ts
function doSomething() {
  // TODO
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/546">CWE-546 - Suspicious Comment</a> </li>
</ul>