<h2>Why is this an issue?</h2>
<p>Ternary expressions, while concise, can often lead to code that is difficult to read and understand, especially when they are nested or complex.
Prioritizing readability fosters maintainability and reduces the likelihood of bugs. Therefore, they should be removed in favor of more explicit
control structures, such as <code>if</code>/<code>else</code> statements, to improve the clarity and readability of the code.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
function foo(a) {
  var b = (a === 'A') ? 'is A' : 'is not A'; // Noncompliant
  // ...
}
```
<h4>Compliant solution</h4>

```ts
function foo(a) {
  var b;
  if (a === 'A') {
    b = 'is A';
  }
  else {
    b = 'is not A';
  }
  // ...
}
```