<h2>Why is this an issue?</h2>
<p>Overriding an object changes its behavior and could potentially impact all code using that object. Overriding standard, built-in objects could
therefore have broad, potentially catastrophic effects on previously-working code.</p>
<p>This rule detects overrides of the following native objects:</p>
<ul>
  <li> Fundamental objects - Object, Function, Boolean, Symbol, Error, EvalError, InternalError, RangeError, ReferenceError, SyntaxError, TypeError,
  URIError </li>
  <li> Numbers and dates - Number, Math, Date </li>
  <li> Text processing - String, RegExp </li>
  <li> Indexed collections - Array, Int8Array, Uint8Array, Uint8ClampedArray, Int16Array, Unit16Array, Int32Array, Uint32Array, Float32Array,
  Float64Array </li>
  <li> Keyed collections - Map, Set, WeakMap, WeakSet </li>
  <li> Structured data - ArrayBuffer, DataView, JSON </li>
  <li> Control abstraction objects - Promise </li>
  <li> Reflection - Reflect, Proxy </li>
  <li> Internationalization - Intl </li>
  <li> Non-standard objects - Generator, Iterator, ParallelArray, StopIteration </li>
</ul>