<h2>Why is this an issue?</h2>
<p>JavaScript and TypeScript classes may define a <code>constructor</code> method that is executed when a new instance is created. TypeScript allows
interfaces that describe a static class object to define a <code>new()</code> method. Using these terms to name methods in other contexts can lead to
confusion and make the code unclear and harder to understand.</p>
<p>This rule reports when:</p>
<ul>
  <li> A class defines a method named <code>new</code>. The <code>new</code> keyword is used to create new instances of the class. If a method with
  the same name is defined, it can be unclear whether the method is intended to create new instances or perform some other action. </li>
  <li> An interface defines a method named <code>constructor</code>. The constructor method is used to define the constructor function for a class
  that implements the interface. If a method with the same name is defined in the interface, it can be unclear whether the method is intended to
  define the constructor function or perform some other action. </li>
</ul>

```ts
interface I {
  constructor(): void; // Noncompliant
  new(): I;
}

declare class C {
  constructor();
  new(): C; // Noncompliant
}
```
<p>Do not define methods named <code>constructor</code> on TypeScript interfaces. Similarly, avoid defining class methods called <code>new</code>.</p>

```ts
interface I {
  new(): I;
}

declare class C {
  constructor();
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://www.typescriptlang.org/docs/handbook/2/everyday-types.html#interfaces">TypeScript - Interfaces</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes">Classes</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes/constructor"><code>constructor</code></a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/new"><code>new</code> operator</a> </li>
</ul>