<h2>Why is this an issue?</h2>
<p>JavaScript regular expressions provide Unicode character classses and Unicode property escapes for matching characters based on their Unicode
values and Unicode properties respectively. When using Unicode property escapes like <code>\p{Alpha}</code> without the <code>u</code> flag, the
regular expression will not match alphabetic characters but rather the <code>'\p{Alpha}'</code> string literal, which is likely a mistake.</p>
<p>This rules raises an issue when Unicode character classses and Unicode property escapes are used without the <code>u</code> flag.</p>
<h3>Noncompliant code example</h3>

```ts
/\u{1234}/
/\p{Alpha}/
```
<h3>Compliant solution</h3>

```ts
/\u{1234}/u
/\p{Alpha}/u
```