# Updating external tools to newer versions

## Docker compatibility check
Before upgrading an external tool to a newer version we have to check whether the newer version can be installed in the currently used Ubuntu version that is used in `Dockerfile.base`. If it is not available in the default packages (`apt`) one has to check whether a newer Ubuntu version might provide it. Here we need to keep the following points in mind:
1. Check whether the new Ubuntu version is LTS, if not then do not upgrade the Ubuntu version.
2. Check whether the versions of other external tools can still be installed as is after an upgrade of the Ubuntu version
    1. Here we have to decide if upgrading to a newer Ubuntu version causes more manual effort for installing external tools without `apt` than not upgrading the Ubuntu version

## Upgrading the version
For some tools like `clang-tidy` there are semi-automated tools like `ClangTidyUpdater` which can be used to ease up the process of updating. Keep in mind that those tools might need to be adapted to work with newer versions of an external tool.

## Comparing old vs new version
To catch major differences in the produced analysis results we want to compare the new version of the external tool against the old one. Therefore, the following is needed:
1. Start a Teamscale instance (docker) with the old version of the external tool
2. Start a Teamscale instance (docker) with the new version of the external tool
3. Analyse a large(r) project on both instances with a fixed start and end date set in the project settings (use backups)
4. Compare both instances using the `Instance Comparison` View in Teamscale
   1. The projects on both instances need the same project-id/name
   2. Compare the findings count for each check
   3. If there are larger differences, check whether you can find plausible explanations (i.e., change logs)
   4. If there are no change logs etc., we need to manually investigate the issue
      1. Randomly select findings of a check which has a large difference between the new and old version
      2. Check if there are false positives 
      3. Check if you can find an explanation why the new version did (not) produce a certain finding (i.e., new version supports macro expansion)
      4. If this is done on a server, it should normally be sufficient to access only one instance via the registered open port/url since the instance comparison only needs to be started from one instance. However, if we need to access both instances at the same time, we need to talk to IT who can provide an additional port/url for the server