import{_ as o,c as n,ak as i,O as a,L as t,o as s}from"./chunks/framework.D4LivsWb.js";const d="/assets/screenshot_check_id.DOUm7Rhs.png",T=JSON.parse('{"title":"Creating a Guideline","description":"","frontmatter":{"title":"Creating a Guideline"},"headers":[],"relativePath":"howto/creating-a-guideline/index.md","filePath":"howto/creating-a-guideline/index.md"}'),r={name:"howto/creating-a-guideline/index.md"};function c(u,e,p,h,g,m){const l=t("FileDownload");return s(),n("div",null,[e[0]||(e[0]=i(`<h1 id="creating-a-guideline" tabindex="-1">Creating a Guideline <a class="header-anchor" href="#creating-a-guideline" aria-label="Permalink to &quot;Creating a Guideline&quot;">​</a></h1><p>You can annotate Teamscale findings with rules from your internal company guidelines. This is achieved by creating custom guidelines within Teamscale.</p><nav class="table-of-contents"><ul><li><a href="#overview">Overview</a></li><li><a href="#prepare-the-guideline-files">Prepare the Guideline Files</a><ul><li><a href="#information-about-guideline-guideline-txt">Information about Guideline: guideline.txt</a></li><li><a href="#information-about-guideline-rules-guideline-rules-tsv">Information about Guideline Rules: guideline-rules.tsv</a></li><li><a href="#mappings-guideline-rules-to-teamscale-checks-guideline-rules-to-checks-tsv">Mappings Guideline Rules To Teamscale Checks: guideline-rules-to-checks.tsv</a></li></ul></li></ul></nav><h2 id="overview" tabindex="-1">Overview <a class="header-anchor" href="#overview" aria-label="Permalink to &quot;Overview&quot;">​</a></h2><p>The process of creating a guideline in Teamscale involves the following steps:</p><ol><li><strong>Identify Relevant Rules:</strong> Determine the specific rules and standards that are most important for your project&#39;s quality goals.</li><li><strong>Locate Corresponding Teamscale Checks</strong>: Utilize Teamscale&#39;s user interface to find the pre-existing checks that correspond to the rules you identified in the previous step. These checks will automatically analyze your codebase for adherence to your defined rules.</li><li><strong>Prepare the Guideline Files:</strong> Follow the instructions detailed below to create the necessary files for your guideline.</li><li><strong>Import and Use the Guideline Files:</strong><ul><li>On-Premise Installation:<br> Create a folder named <code>guidelines</code> within the <a href="./../../reference/administration-ts-installation/#configuring-teamscale">config directory</a> of Teamscale. For each individual guideline you are creating, establish a separate subdirectory within the <code>guidelines</code> folder. Copy the guideline files you prepared in step 3 into the respective subdirectory. This ensures that the guideline is recognized by Teamscale and analysis of your projects will annotate findings that correspond to guideline violations.</li><li>Cloud Installation:<br> For cloud-based Teamscale installations, please reach out to the Teamscale support team at <a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">support@teamscale.com</a> for assistance with uploading and configuring your custom guideline.</li></ul></li><li>Restart Teamscale after creating or modifying a guideline.</li></ol><p>In case of an error creating the guideline in Teamscale, you can find the error log entry in the log-file named <code>logs/teamscale.log</code>.</p><h2 id="prepare-the-guideline-files" tabindex="-1">Prepare the Guideline Files <a class="header-anchor" href="#prepare-the-guideline-files" aria-label="Permalink to &quot;Prepare the Guideline Files&quot;">​</a></h2><p>For each guideline you have to prepare the following three files:</p><ul><li><code>guideline.txt</code></li><li><code>guideline-rules.tsv</code></li><li><code>guideline-rules-to-checks.tsv</code></li></ul><p>All files must be UFT-8 encoded.</p><h3 id="information-about-guideline-guideline-txt" tabindex="-1">Information about Guideline: <code>guideline.txt</code> <a class="header-anchor" href="#information-about-guideline-guideline-txt" aria-label="Permalink to &quot;Information about Guideline: \`guideline.txt\`&quot;">​</a></h3><p>The <code>guideline.txt</code> file contains general information about your guideline. It has a simple <code>key: value</code> format. Example:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>ID: my-company-guideline</span></span>
<span class="line"><span>Readable Name: My Company Guideline</span></span>
<span class="line"><span>Language: JAVA, CS, CPP</span></span>
<span class="line"><span>Upstream URL:</span></span>
<span class="line"><span>Archive URL:</span></span>
<span class="line"><span>Author/Organization: CQSE GmbH</span></span>
<span class="line"><span>Release Date: 2025</span></span>
<span class="line"><span>Description: This is a sample programming guideline for Java, C# and C++.</span></span>
<span class="line"><span>Further Info URL: https://example.com/my-company-guideline</span></span></code></pre></div><p>If the guideline applies to multiple programming languages, specify them as a comma-separated list using the following abbreviations:</p><ul><li><code>ABAP</code></li><li><code>ADA</code></li><li><code>C</code></li><li><code>COBOL</code></li><li><code>CPP</code> (C++)</li><li><code>CPP_MS_CLI</code> (MS C++/CLI)</li><li><code>CS</code> (C#)</li><li><code>DART</code></li><li><code>DELPHI</code></li><li><code>ESQL</code> (Extended SQL)</li><li><code>FORTRAN</code></li><li><code>GO</code></li><li><code>GOSU</code></li><li><code>GROOVY</code></li><li><code>IEC61131</code> (IEC 61131-3 ST)</li><li><code>JAVA</code></li><li><code>JAVASCRIPT</code> (includes TypeScript)</li><li><code>KOTLIN</code></li><li><code>KUBERNETES</code></li><li><code>MATLAB</code></li><li><code>OBJECTIVE_C</code></li><li><code>OPEN_CL</code></li><li><code>OSCRIPT</code></li><li><code>PHP</code></li><li><code>PLSQL</code></li><li><code>POWERSHELL</code></li><li><code>PYTHON</code></li><li><code>SIMULINK</code></li><li><code>SQLScript</code></li><li><code>SWIFT</code></li><li><code>TSQL</code> (Transact-SQL)</li><li><code>VB</code> (Visual Basic)</li><li><code>XML</code></li><li><code>XTEND</code></li></ul><h3 id="information-about-guideline-rules-guideline-rules-tsv" tabindex="-1">Information about Guideline Rules: <code>guideline-rules.tsv</code> <a class="header-anchor" href="#information-about-guideline-rules-guideline-rules-tsv" aria-label="Permalink to &quot;Information about Guideline Rules: \`guideline-rules.tsv\`&quot;">​</a></h3><p>The <code>guidline-rules.tsv</code> file defines all individual rules of your guideline in TSV (Tab-Separated Values) format. TSV is a text-based format used to store data in a tabular structure. Each line represents a row of data, and columns within each row are separated by tab characters. Each rule includes the following fields:</p><ul><li><strong>ID in Guidelines</strong>: A unique ID of the rule (mandatory)</li><li><strong>Readable Name</strong>: A human-readable name shown in Teamscale (mandatory)</li><li><strong>Category</strong>: Grouping for large guidelines with many rules (optional)</li><li><strong>Machine-checkable</strong>: Indicates whether the rule can be automatically checked (optional)</li><li><strong>Comments</strong>: Comments will not be shown in Teamscale (optional)</li><li><strong>Upstream URL</strong>: URL with further information (optional)</li></ul><p>You can download here an example file and adapt it to your needs:</p>`,20)),a(l,{icon:"table",title:"guideline-rules.tsv",link:"/assets/guidelines/guideline-rules.tsv"}),e[1]||(e[1]=i('<h3 id="mappings-guideline-rules-to-teamscale-checks-guideline-rules-to-checks-tsv" tabindex="-1">Mappings Guideline Rules To Teamscale Checks: <code>guideline-rules-to-checks.tsv</code> <a class="header-anchor" href="#mappings-guideline-rules-to-teamscale-checks-guideline-rules-to-checks-tsv" aria-label="Permalink to &quot;Mappings Guideline Rules To Teamscale Checks: `guideline-rules-to-checks.tsv`&quot;">​</a></h3><p>The <code>guideline-rules-to-checks.tsv</code> file links the rules of your guideline to Teamscale checks. With this mapping, Teamscale can annotate findings with references to your guideline rules. As with <code>guideline-rules.tsv</code>, this files uses the TSV format. Each mapping includes the following fields:</p><ul><li><strong>Check ID</strong>: ID of the Teamscale check (mandatory; see below)</li><li><strong>Guideline Rule ID</strong>: The ID of the rule as specified in <code>guideline-rules.tsv</code> (mandatory)</li><li><strong>Comment</strong>: Comments will not be shown in Teamscale. (optional)</li></ul><p>A rule can be mapped to multiple Teamscale checks by having multiple rows with the same Guideline Rule ID. You can download here an example file and adapt it to your needs:</p>',4)),a(l,{icon:"table",title:"guideline-rules-to-checks.tsv",link:"/assets/guidelines/guideline-rules-to-checks.tsv"}),e[2]||(e[2]=i('<div class="warning custom-block"><p class="custom-block-title">Supported Checks</p><p>Currently it is not possible to map rules to checks that depend on <a href="./../../reference/upload-formats-and-samples/">external uploads</a> such as Findbugs.</p></div><div class="info custom-block"><p class="custom-block-title">Where can I find the check ID?</p><p>The check ID is not the same as the check title displayed in Teamscale. You can find the check ID by hovering over the check title in the Check Explorer. For example, in the screenshot below, the check ID for &quot;Avoid leaving deprecated entities&quot; is <code>cqse-deprecated-annotation</code>.</p></div><p><img src="'+d+'" alt="screenshot_check_id.png" width="1676" height="749" data-zoom="true"></p>',3))])}const b=o(r,[["render",c]]);export{T as __pageData,b as default};
