import{_ as i}from"./chunks/projects-create.NKbf3hEz.js";import{_ as n,c as l,b as t,x as o,O as r,ak as s,L as c,o as d}from"./chunks/framework.D4LivsWb.js";const u="/assets/projects-connector.DEEZv_Zc.png",B=JSON.parse('{"title":"Creating a Project","description":"This guide teaches you how to create a new project following best practices in Teamscale.","frontmatter":{"title":"Creating a Project","description":"This guide teaches you how to create a new project following best practices in Teamscale."},"headers":[],"relativePath":"howto/creating-a-project/index.md","filePath":"howto/creating-a-project/index.md"}'),p={name:"howto/creating-a-project/index.md"},h={class:"table-of-contents"},y={href:"#start-with-the-default-analysis-profile"},f={href:"#limit-the-amount-of-history-you-analyze"},m={href:"#exclude-generated-third-party-code"},g={id:"start-with-the-default-analysis-profile",tabindex:"-1"},w={id:"limit-the-amount-of-history-you-analyze",tabindex:"-1"},P={id:"exclude-generated-third-party-code",tabindex:"-1"};function j(b,e,T,k,x,v){const a=c("Badge");return d(),l("div",null,[e[16]||(e[16]=t("h1",{id:"how-to-create-a-project",tabindex:"-1"},[o("How to Create a Project "),t("a",{class:"header-anchor",href:"#how-to-create-a-project","aria-label":'Permalink to "How to Create a Project"'},"​")],-1)),t("nav",h,[t("ul",null,[e[4]||(e[4]=t("li",null,[t("a",{href:"#summary"},"Summary")],-1)),t("li",null,[e[3]||(e[3]=t("a",{href:"#best-practices-for-your-own-teamscale-project"},"Best Practices for Your Own Teamscale Project",-1)),t("ul",null,[t("li",null,[t("a",y,[e[0]||(e[0]=o("Start with the Default Analysis Profile ",-1)),r(a,{type:"tip",text:"Best Practice"})])]),t("li",null,[t("a",f,[e[1]||(e[1]=o("Limit the Amount of History you Analyze ",-1)),r(a,{type:"tip",text:"Best Practice"})])]),t("li",null,[t("a",m,[e[2]||(e[2]=o("Exclude Generated/Third-Party Code ",-1)),r(a,{type:"tip",text:"Best Practice"})])])])]),e[5]||(e[5]=t("li",null,[t("a",{href:"#creating-an-analysis-profile"},"Creating an Analysis Profile")],-1)),e[6]||(e[6]=t("li",null,[t("a",{href:"#creating-the-project"},"Creating the Project")],-1))])]),e[17]||(e[17]=s('<h2 id="summary" tabindex="-1">Summary <a class="header-anchor" href="#summary" aria-label="Permalink to &quot;Summary&quot;">​</a></h2><p>To run Teamscale on your code, two steps are required: First, you have to create an <strong>analysis profile</strong> which configures the analyses that should be run and all their options. Second, you need a <strong>project configuration</strong> which configures the scope of the analyzed code. Both steps can be done in the <em>Projects</em> perspective.</p><h2 id="best-practices-for-your-own-teamscale-project" tabindex="-1">Best Practices for Your Own Teamscale Project <a class="header-anchor" href="#best-practices-for-your-own-teamscale-project" aria-label="Permalink to &quot;Best Practices for Your Own Teamscale Project&quot;">​</a></h2><p>Before you jump into configuring your first Teamscale project, here are some best practices for first-time users:</p>',4)),t("h3",g,[e[7]||(e[7]=o("Start with the Default Analysis Profile ",-1)),r(a,{type:"tip",text:"Best Practice"}),e[8]||(e[8]=o()),e[9]||(e[9]=t("a",{class:"header-anchor",href:"#start-with-the-default-analysis-profile","aria-label":'Permalink to "Start with the Default Analysis Profile <Badge type="tip" text="Best Practice"/>"'},"​",-1))]),e[18]||(e[18]=t("p",null,"Configuring an analysis profile in all its details can be a daunting task. Teamscale offers hundreds of checks and options that let you customize it fully to your needs. However, when you're setting up your very first project, it makes more sense to start with some sane defaults and then later refine the settings step-by-step. To this end, Teamscale provides a default analysis profile for each supported language.",-1)),e[19]||(e[19]=t("div",{class:"tip custom-block"},[t("p",{class:"custom-block-title"},"Build on defaults"),t("p",null,"We recommend you start with the default analysis profile for your language and later, step-by-step, refine it to your needs.")],-1)),t("h3",w,[e[10]||(e[10]=o("Limit the Amount of History you Analyze ",-1)),r(a,{type:"tip",text:"Best Practice"}),e[11]||(e[11]=o()),e[12]||(e[12]=t("a",{class:"header-anchor",href:"#limit-the-amount-of-history-you-analyze","aria-label":'Permalink to "Limit the Amount of History you Analyze <Badge type="tip" text="Best Practice" />"'},"​",-1))]),e[20]||(e[20]=t("p",null,[o("Teamscale’s "),t("a",{href:"./../../introduction/why-teamscale/#why-teamscale-is-different"},"incremental analysis engine"),o(" allows it to give you instant feedback on each of your commits. Analyzing the changes in a single commit usually only takes a few seconds. If your project has a long history, analyzing that entire history will, of course, take some time. The longer the history, the longer it takes. When you’re setting up your first Teamscale project, you will usually want to make several smaller changes in short order, e.g., to the analysis profile or the included/excluded files.")],-1)),e[21]||(e[21]=t("p",null,"Thus, it makes sense to start with a very short history (e.g the last few days) while you’re still working on fine-tuning the configuration. Once you’re satisfied with the results, reanalyze the project with a longer history.",-1)),e[22]||(e[22]=t("p",null,[o("To limit the amount of history that Teamscale will analyze, change the "),t("code",null,"Start revision"),o(" parameter of your repository connector.")],-1)),t("h3",P,[e[13]||(e[13]=o("Exclude Generated/Third-Party Code ",-1)),r(a,{type:"tip",text:"Best Practice"}),e[14]||(e[14]=o()),e[15]||(e[15]=t("a",{class:"header-anchor",href:"#exclude-generated-third-party-code","aria-label":'Permalink to "Exclude Generated/Third-Party Code <Badge type="tip" text="Best Practice"/>"'},"​",-1))]),e[23]||(e[23]=s('<p>Many software projects make use of code generators, e.g., to generate UI components or data classes. Generated code is often repetitive and usually doesn&#39;t conform to your company’s coding guidelines. Furthermore, you should never make changes to the generated code directly. Thus, for most analyses, it makes no sense to check your generated code with Teamscale. We recommend that you use the include and exclude patterns of the connector configuration to exclude all generated code from the analysis.</p><div class="tip custom-block"><p class="custom-block-title">Excluding code from analysis</p><p>To exclude code, add a pattern to the <code>Excluded file names</code> parameter of your repository connector.</p></div><div class="tip custom-block"><p class="custom-block-title">Analyzing generated code on purpose</p><p>If you really want to run certain checks on your generated code (e.g., security analyses), we recommend you create a separate Teamscale project for it plus a special analysis profile with only those checks enabled.</p></div><h2 id="creating-an-analysis-profile" tabindex="-1">Creating an Analysis Profile <a class="header-anchor" href="#creating-an-analysis-profile" aria-label="Permalink to &quot;Creating an Analysis Profile&quot;">​</a></h2><p>A detail guide on how to create or edit an analysis <a href="./../creating-an-analysis-profile/">can be found here</a>.</p><h2 id="creating-the-project" tabindex="-1">Creating the Project <a class="header-anchor" href="#creating-the-project" aria-label="Permalink to &quot;Creating the Project&quot;">​</a></h2><div class="tip custom-block"><p class="custom-block-title">SAP Integration</p><p>If you are working with SAP, refer to our guide on <a href="./../../tutorial/sap-integration/">how Teamscale integrates with SAP</a>.</p></div><p>On the <em>Project Configuration</em> perspective, you can see a list of all projects configured in Teamscale.</p><p>To create a new project, select <code>New project</code> button at the top. You will be taken to the project creation screen:</p><p><img src="'+i+'" alt="Project Creation Screen" width="1642" height="1062" data-zoom="true"></p><p>Here, you can enter the name of your project and select the <a href="./../../reference/ui/project/analysis-profiles/">analysis profile</a>.</p><p>Next, you can add any number of source code repositories and issue trackers. To do so, select the correct repository or issue tracker type from the corresponding drop-down.</p><p><a href="./../../reference/supported-technologies/version-control-systems/">Check our list of supported version control systems</a> to find out how to configure the connection for your project.</p><p>A new section will appear where you can configure all options needed to connect to the repository or issue tracker, e.g., credentials, starting revision, files to exclude, etc.:</p><p><img src="'+u+'" alt="Project Connector Settings" width="1618" height="1790" data-zoom="true"></p><p>The options are explained in <a href="./../../reference/connector-options/#common-and-git-specific-connector-options">more detail here</a>.</p><p>Most connectors require you to specify an account that holds shared credentials (user name, password). While any user with sufficient rights to create new projects may also create new accounts, only the system administrator may edit or delete existing external accounts in the <em>Admin</em> perspective.</p><p>You may use <code>Validate</code> (bottom left) to make sure your settings are correct before clicking <code>Create Project</code> to start the analysis. To monitor analysis progress you can have a look at the <em>System</em> or <em><a href="./../../reference/ui/activity/commits/">Activity</a></em> perspective.</p>',18))])}const S=n(p,[["render",j]]);export{B as __pageData,S as default};
