import{_ as r,c as n,ak as a,b as t,x as i,O as o,L as l,o as c}from"./chunks/framework.D4LivsWb.js";const C=JSON.parse('{"title":"Coverage for C or C++","description":"","frontmatter":{"title":"Coverage for C or C++"},"headers":[],"relativePath":"howto/setting-up-profiler-tga/cpp/index.md","filePath":"howto/setting-up-profiler-tga/cpp/index.md"}'),d={name:"howto/setting-up-profiler-tga/cpp/index.md"},p={class:"table-of-contents"},h={href:"#msvc-and-codecoverage-exe"},u={id:"msvc-and-codecoverage-exe",tabindex:"-1"};function g(m,e,k,y,f,v){const s=l("Badge");return c(),n("div",null,[e[7]||(e[7]=a('<h1 id="setting-up-test-coverage-profiling-for-c-or-c" tabindex="-1">Setting Up Test Coverage Profiling for C or C++ <a class="header-anchor" href="#setting-up-test-coverage-profiling-for-c-or-c" aria-label="Permalink to &quot;Setting Up Test Coverage Profiling for C or C++&quot;">​</a></h1><p>There is a wealth of different profilers for C and C++, both on Linux and Windows. They each have their respective advantages and disadvantages. On this page, we will show you the most commonly used profilers and how to use them.</p><p>We suggest you always start with a profiler that is compatible with your compiler:</p><ul><li>gcc: <a href="#gcc-and-lcov">lcov</a></li><li>clang: <a href="#clang-and-llvm-cov">llvm-cov</a></li><li>Microsoft Visual C++ Enterprise Edition: <a href="#msvc-and-microsoft-codecoverage-console">Microsoft.CodeCoverage.Console</a></li><li>Microsoft Visual C++ Professional Edition: <a href="#msvc-and-opencppcoverage">OpenCppCoverage</a></li><li><a href="https://bullseye.com/platform.html" target="_blank" rel="noreferrer">Various other compilers</a>, including embedded: <a href="#bullseye">Bullseye</a></li></ul><p>In some cases, these profilers may impact the performance of your system too much, e.g. when your code runs on highly resource constrained embedded devices. For these cases there are more specialized commercial profilers available. In general, we recommend you first try <a href="#bullseye">Bullseye</a> in these cases, as its instrumenting technique allows you to compile with all compiler optimizations enabled.</p><p>For embedded software, specialized <a href="#hardware-profilers">hardware profilers</a> are also an option. These have no performance impact at all and do not require any data to be written to the file system.</p><p>If none of the mentioned options works for you, please <a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">contact us</a>. We are happy to discuss further options with you.</p>',7)),t("nav",p,[t("ul",null,[e[1]||(e[1]=a('<li><a href="#gcc-and-lcov">gcc and lcov</a></li><li><a href="#clang-and-llvm-cov">clang and llvm-cov</a></li><li><a href="#msvc-and-opencppcoverage">MSVC and OpenCppCoverage</a></li><li><a href="#msvc-and-microsoft-codecoverage-console">MSVC and Microsoft.CodeCoverage.Console</a></li><li><a href="#bullseye">Bullseye</a><ul><li><a href="#troubleshooting">Troubleshooting</a></li></ul></li>',5)),t("li",null,[t("a",h,[e[0]||(e[0]=i("MSVC and CodeCoverage.exe ",-1)),o(s,{text:"deprecated",type:"warning"})])]),e[2]||(e[2]=t("li",null,[t("a",{href:"#performance-impact"},"Performance Impact")],-1)),e[3]||(e[3]=t("li",null,[t("a",{href:"#hardware-profilers"},"Hardware Profilers")],-1))])]),e[8]||(e[8]=a(`<h2 id="gcc-and-lcov" tabindex="-1">gcc and lcov <a class="header-anchor" href="#gcc-and-lcov" aria-label="Permalink to &quot;gcc and lcov&quot;">​</a></h2><p>You can instruct gcc to instrument your binaries during compilation. <strong>You must use a debug build and you must not enable optimizations that interfere with debug information, i.e. at most <code>-Og</code>.</strong></p><p>During <em>compilation</em> use</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">--coverage</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -g</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -Og</span></span></code></pre></div><p>and during <em>linking</em> use</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">--coverage</span></span></code></pre></div><div class="tip custom-block"><p class="custom-block-title">Use clang for Better Performance</p><p>clang uses a different method to obtain coverage that does not require an unoptimized debug build. Instead you can build your instrumented binary with all compiler optimizations enabled. Should you notice performance problems after instrumenting your code with gcc, you can try <a href="#clang-and-llvm-cov">clang&#39;s test coverage capabilities instead</a>.</p></div><div class="tip custom-block"><p class="custom-block-title">Additional Flags for Dynamically Loaded Code</p><p>If your application is dynamically loading code at runtime (e.g. via <code>dlopen</code>), you must supply these additional command-line flags to <code>gcc</code> during compilation and linking:</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">-Wl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --dynamic-list-data</span></span></code></pre></div><p>Otherwise, no or only partial <code>.gcda</code> files will be written for dynamically loaded code.</p></div><p>gcc will generate one <code>.gcno</code> file per object file. This contains information needed to parse the test coverage information generated during your tests. Archive these files for later use. These files are <em>not</em> needed to run the created binary.</p><p>Run your tests on the instrumented binary as usual. During normal program exit, multiple <code>.gcda</code> files will be written to disk (one per object file). These contain the coverage information in a binary format.</p><div class="warning custom-block"><p class="custom-block-title">Terminate Your Process Gracefully</p><p>Since coverage is being written to disk when your process ends, a graceful shutdown is required. Otherwise, no or incomplete coverage information will be written.</p><p>In particular this means that you must never use <code>SIGTERM</code> to kill the process abruptly. Use <code>SIGINT</code> instead for a graceful shutdown.</p></div><div class="tip custom-block"><p class="custom-block-title">Change the Location of the .gcda Files</p><p>During the execution of the instrumented binary, the <code>.gcda</code> files are written to the same location where the <code>.gcno</code> files were created <strong>during the build</strong>. This is usually not desirable as the build system will have a very different directory layout than the test system. You can use the environment variables <code>GCOV_PREFIX</code> and <code>GCOV_PREFIX_STRIP</code> to change the output directory of the <code>.gcda</code> files.</p><p>Example:</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">export</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> GCOV_PREFIX</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;/coverage&quot;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">export</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> GCOV_PREFIX_STRIP</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;1&quot;</span></span></code></pre></div><p>This will turn the build server path <code>/build/project/file.gcno</code> into the test server path <code>/coverage/project/file.gcda</code>.</p><p><strong>The output directory for the <code>.gcda</code> files must be writable by the instrumented process!</strong></p><p>See <a href="https://gcc.gnu.org/onlinedocs/gcc/Cross-profiling.html" target="_blank" rel="noreferrer">the gcc documentation</a> for further information.</p></div><p><a href="https://github.com/linux-test-project/lcov" target="_blank" rel="noreferrer">lcov</a> is a program that converts the <code>.gcda</code> and <code>.gcno</code> binary files into a format that is readable by Teamscale. It is already included in most installations of gcc.</p><p>To convert your <code>.gcda</code> files to a format that Teamscale can understand, put all <code>.gcda</code> files next to their corresponding <code>.gcno</code> file, all in one directory. Then run</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">lcov</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --capture</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --directory</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> /path/containing/gcda_and_gcno_files</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --output-file</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> /tmp/lcov.info</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --include</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &#39;/path/to/your/code/during/the/build/*&#39;</span></span></code></pre></div><p>This command searches for <code>.gcda</code> and <code>.gcno</code> files recursively and merges them all into the <code>.info</code> file.</p><p>Adjust the <code>--include</code> path so it matches the path to your source code as it was <em>on the build server</em>. This ensures that only coverage for your code is included in the file, not coverage of system libraries or 3rd-party code. Without this flag, report files will be much larger than necessary.</p><p><a href="./../../uploading-external-data/">Upload the <code>.info</code> file to Teamscale</a>. Specify the report format <code>LCOV</code>.</p><div class="danger custom-block"><p class="custom-block-title">Always Use Matching .gcno Files</p><p>You must use the exact <code>.gcno</code> files that were generated during the build of the instrumented executable that produced the <code>.gcda</code> files. Using files from a different build will not work and either result in incorrect or no coverage data.</p><p>As a best practice, always keep the <code>.gcno</code> and <code>.gcda</code> files together when transferring them between computers.</p></div><div class="danger custom-block"><p class="custom-block-title">gcov and gcc Versions Must be The Same</p><p>lcov internally calls gcov to parse the <code>.gcda</code> and <code>.gcno</code> files. Make sure that your gcov version is the same as your gcc version.</p><p>If you use a different computer to run lcov than you used to run <code>gcc --coverage</code>, make sure that both have the same version of gcc and gcov installed.</p><p>You can check the version of both tools by running</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">gcc</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --version</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">gcov</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --version</span></span></code></pre></div><p>The versions must be identical. Otherwise, you will get an empty <code>.info</code> file and compatibility errors from lcov/gcov such as:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>/home/user/coverage-files/system.gcno:version &#39;A74*&#39;, prefer &#39;408*&#39;</span></span></code></pre></div></div><h2 id="clang-and-llvm-cov" tabindex="-1">clang and llvm-cov <a class="header-anchor" href="#clang-and-llvm-cov" aria-label="Permalink to &quot;clang and llvm-cov&quot;">​</a></h2><p>clang supports so-called <a href="https://clang.llvm.org/docs/SourceBasedCodeCoverage.html" target="_blank" rel="noreferrer">source-based code coverage</a>. This coverage mode also works if you enable compiler optimizations.</p><p>To enable the instrumentation, pass the following flags to clang during compilation and linking:</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">-fprofile-instr-generate</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -fcoverage-mapping</span></span></code></pre></div><p>Before you run the instrumented binary in your test environment, set the environment variable <code>LLVM_PROFILE_FILE</code> to the path where the <code>.profraw</code> coverage output file should be written.</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">LLVM_PROFILE_FILE</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">/path/to/coverage.profraw</span></span></code></pre></div><p>This can be a relative path as well. <a href="https://clang.llvm.org/docs/SourceBasedCodeCoverage.html#running-the-instrumented-program" target="_blank" rel="noreferrer">The clang documentation</a> has additional details on the format of this variable. When the process is terminated, it writes its coverage information to that file.</p><p>This binary <code>.profraw</code> file must first be converted to the intermediate <code>.profdata</code> format and then to a format that Teamscale can understand:</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">llvm-profdata</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> merge</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --sparse</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> /path/to/coverage.profraw</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -o</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> ./coverage.profdata</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">llvm-cov</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> export</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --format=lcov</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --instr-profile</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> ./coverage.profdata</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> /path/to/your/binary</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> ./coverage.lcov</span></span></code></pre></div><p><a href="./../../uploading-external-data/">Upload the <code>coverage.lcov</code> file to Teamscale</a>. Specify the report format <code>LCOV</code>.</p><div class="danger custom-block"><p class="custom-block-title">Use the Matching Binary File</p><p>You must use the exact instrumented binary file that produced the <code>.profraw</code> file. Using files from a different build will not work and either result in incorrect or no coverage data.</p><p>As a best practice, always keep the binary and <code>.profraw</code> files together when transferring them between computers.</p></div><div class="tip custom-block"><p class="custom-block-title">Prefer Source-Based Code Coverage</p><p>While clang also has a compatibility mode for gcc&#39;s gcov, we recommend using the source-based code coverage instead as it gives more accurate results and is easier to set up. Furthermore, it allows you to enable compiler optimizations while the gcov-compatible coverage mode requires an unoptimized debug build to function correctly.</p></div><div class="tip custom-block"><p class="custom-block-title">Profiling without a File System</p><p>Clang also supports <a href="https://clang.llvm.org/docs/SourceBasedCodeCoverage.html#using-the-profiling-runtime-without-a-filesystem" target="_blank" rel="noreferrer">profiling binaries that run on hosts without a file system</a>. In this mode, the coverage data is sent to any buffer under your control from where you can forward it out of the constrained environment any way you choose.</p></div><h2 id="msvc-and-opencppcoverage" tabindex="-1">MSVC and OpenCppCoverage <a class="header-anchor" href="#msvc-and-opencppcoverage" aria-label="Permalink to &quot;MSVC and OpenCppCoverage&quot;">​</a></h2><p>OpenCppCoverage is open source and records test coverage for Windows C++ applications.</p><div class="tip custom-block"><p class="custom-block-title">Use Bullseye for Better Performance</p><p>OpenCppCoverage has a certain <a href="#performance-impact">performance impact</a> on your application. In many cases, this is not a problem. Should you notice an unwanted slow-down of your application or timing problems in your tests, we recommend you use <a href="#bullseye">Bullseye</a> instead, the profiler with the smallest performance impact.</p></div><p>When building your binary, make sure to also generate <code>.pdb</code> files for all code for which you wish to receive test coverage data. <strong>You must use a debug build without any compiler optimizations to get useful coverage data.</strong></p><p>Then, run your application with OpenCppCoverage:</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">OpenCppCoverage.exe</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --export_type</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> cobertura:C:</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\p</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">ath</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\t</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">o</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\r</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">eport.xml</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --continue_after_cpp_exception</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --cover_children</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --modules</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">  C:</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\p</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">ath</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\c</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">ontaining</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\b</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">inaries</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --sources</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> SOURCE_FOLDER</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> .</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\Y</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">OUR_APPLICATION.exe</span></span></code></pre></div><p><code>--sources</code> is used to improve profiling performance. By default, OpenCppCoverage will profile all code used by your application, including all libraries. This will cause a significant performance impact. Thus, we filter which source files should be profiled with this parameter. <code>SOURCE_FOLDER</code> is the name of the folder that contains all <em>source</em> code that should be profiled. You can specify the parameter multiple times and <a href="https://github.com/OpenCppCoverage/OpenCppCoverage/wiki/Command-line-reference" target="_blank" rel="noreferrer">use wild cards</a>.</p><h2 id="msvc-and-microsoft-codecoverage-console" tabindex="-1">MSVC and Microsoft.CodeCoverage.Console <a class="header-anchor" href="#msvc-and-microsoft-codecoverage-console" aria-label="Permalink to &quot;MSVC and Microsoft.CodeCoverage.Console&quot;">​</a></h2><div class="warning custom-block"><p class="custom-block-title">VisualStudio Enterprise Required</p><p>Unfortunately, Microsoft no longer provides a free-to-use code coverage tool as of 2024. To use CodeCoverage.Console, you must have a VisualStudio Enterprise license. If you want a free alternative, use <a href="#msvc-and-opencppcoverage">OpenCppCoverage</a> instead.</p></div><div class="tip custom-block"><p class="custom-block-title">Use Bullseye for Better Performance</p><p>Microsoft.CodeCoverage.Console has a certain <a href="#performance-impact">performance impact</a> on your application. In many cases, this is not a problem. Should you notice an unwanted slow-down of your application or timing problems in your tests, we recommend you use <a href="#bullseye">Bullseye</a> instead - the profiler with the smallest performance impact.</p></div><p>When building your binary, you must link with <code>/PROFILE</code> to ensure that appropriate <code>.pdb</code> files are generated for all code for which you wish to receive test coverage data. <strong>You must use a debug build without any compiler optimizations to get useful coverage data.</strong></p><p>Deploy your binary and the <code>.pdb</code> files to your test environment. Wrap the invocation of your binary during your tests with CodeCoverage.exe:</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">Microsoft.CodeCoverage.Console</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> collect</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --output</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;C:\\path\\to\\output.coverage&quot;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> C:</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\p</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">ath</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\t</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">o</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\y</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">our</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\b</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">inary.exe</span></span></code></pre></div><p>After your process is terminated, a <code>.coverage</code> file will be written to the output path you specified.</p><p>Next, convert your <code>output.coverage</code> file to XML:</p><div class="language-powershell vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">powershell</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">Microsoft.CodeCoverage.Console merge </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">--</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">output</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">-</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">format cobertura </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">--</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">output cobertura.xml output.coverage</span></span></code></pre></div><p>Afterwards, you can <a href="./../../uploading-external-data/#upload-from-azure-devops">upload the resulting XML file to Teamscale</a> with format <code>COBERTURA</code>.</p><h2 id="bullseye" tabindex="-1">Bullseye <a class="header-anchor" href="#bullseye" aria-label="Permalink to &quot;Bullseye&quot;">​</a></h2><p><a href="https://bullseye.com/" target="_blank" rel="noreferrer">Bullseye</a> wraps your compiler to instrument your source code before it is compiled. This allows you to compile the instrumented code with all compiler optimizations enabled and still get valid test coverage data. Thus, it has a significantly lower performance impact than many other profilers which require a debug build with optimizations disabled.</p><p>Bullseye offers a <a href="https://bullseye.com/evaluation.html" target="_blank" rel="noreferrer">free trial license</a> on their website, so you can test if it fits your needs.</p><div class="tip custom-block"><p class="custom-block-title">When to Choose Bullseye</p><ul><li>If the other software profilers are not performant enough for your tests</li><li>or you have to compile your binaries with compiler optimizations enabled</li><li>or you are using a compiler that has no profiler of its own (e.g. specialized embedded compiler).</li></ul></div><p>In order to create an instrumented executable:</p><p>Install Bullseye on the computer that builds your binaries. During the installation, select <em>install for all users, build servers, services and kernel mode testing</em>. Also select all relevant compiler integrations, e.g. <em>Microsoft Visual C++ build tools</em> and <em>Microsoft Visual Studio 2019</em>, depending on which versions you are using.</p><p>In your build script/build pipeline, execute the following steps:</p><ol><li>Set the <code>COVFILE</code> environment variable for the entire build pipeline. At this location, the compilation process will create a <code>.cov</code> file that contains information needed by the instrumented binary to record test coverage. <a href="https://bullseye.com/help/build-coverageFile.html" target="_blank" rel="noreferrer">The Bullseye documentation</a> has detailed guidelines for how to set this correctly.</li><li>Delete the old <code>.cov</code> file if present.</li><li>Before invoking your compiler to build your binary, enable coverage collection by running<div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">cov01</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -1</span></span></code></pre></div></li><li>Build your binary as usual. Bullseye wraps your compiler command and automatically injects itself into the build process. I.e. it will instrument everything the compiler compiles, including subprojects etc.</li></ol><div class="tip custom-block"><p class="custom-block-title">Instrumenting Multiple Binaries and Shared Libraries</p><p>If you either have multiple binaries that run on the same test environment/target or your main binary uses shared libraries that have their own build, you can share the same <code>.cov</code> file between these builds. Bullseye will merge the coverage information from all binaries and libraries in this <code>.cov</code> file and all processes can then write their coverage into this file at runtime. This makes deployment much easier than managing multiple <code>.cov</code> files on the same target.</p></div><div class="tip custom-block"><p class="custom-block-title">Exclude Unnecessary Code</p><p>To configure which code should be instrumented, please refer <a href="https://bullseye.com/help/build-exclude.html" target="_blank" rel="noreferrer">to the Bullseye documentation on excludes</a>. Excluding code for which you don&#39;t need test coverage will speed up the instrumented binary.</p></div><p>Your build process produced the instrumented binary and a <code>.cov</code> file. <strong>Make sure to save the <code>.cov</code> file together with your build output, so you always use the correct <code>.cov</code> file that corresponds to the instrumented binary.</strong></p><p>Deploy your binary and the corresponding <code>.cov</code> file to your test environment. Set the environment variable <code>COVFILE</code> on your test environment to point to the copied <code>.cov</code> file. <a href="https://bullseye.com/help/build-coverageFile.html" target="_blank" rel="noreferrer">The Bullseye documentation</a> has detailed guidelines for where to best place the <code>.cov</code> file on your test environment.</p><p>Run your tests with the instrumented binary like you normally do. Coverage data is written into the <code>.cov</code> file.</p><div class="info custom-block"><p class="custom-block-title">Wait 2 seconds before stopping your application</p><p>Bullseye uses a separate thread to write coverage data to disk once every second. Thus, make sure that after the last test is executed, you wait at least 2 seconds before stopping your application so Bullseye has the necessary time to write the remaining coverage data to disk</p></div><p>Convert the <code>.cov</code> file to XML by running</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">covxml</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -f</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> /path/to/cov_file.cov</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -o</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> /path/to/coverage.xml</span></span></code></pre></div><p>Finally, <a href="./../../uploading-external-data/">upload the XML file to Teamscale</a>. Specify the report format <code>BULLSEYE</code>.</p><p>For further configuration options, please refer to <a href="https://bullseye.com/help/index.html" target="_blank" rel="noreferrer">the Bullseye documentation</a>.</p><h3 id="troubleshooting" tabindex="-1">Troubleshooting <a class="header-anchor" href="#troubleshooting" aria-label="Permalink to &quot;Troubleshooting&quot;">​</a></h3><ul><li>Check your compiler logs or stdout of the compilation process for errors.</li><li>If anything goes wrong during the execution of the instrumented executable, Bullseye will log errors to stdout of the instrumented binary&#39;s process.</li><li>Ensure that your process actually sees the <code>COVFILE</code> environment variable.</li><li>Ensure the <code>.cov</code> file is valid and includes all relevant code by inspecting it with Bullseye&#39;s Coverage Browser.</li></ul>`,70)),t("h2",u,[e[4]||(e[4]=i("MSVC and CodeCoverage.exe ",-1)),o(s,{text:"deprecated",type:"warning"}),e[5]||(e[5]=i()),e[6]||(e[6]=t("a",{class:"header-anchor",href:"#msvc-and-codecoverage-exe","aria-label":'Permalink to "MSVC and CodeCoverage.exe <Badge text="deprecated" type="warning" />"'},"​",-1))]),e[9]||(e[9]=a('<div class="warning custom-block"><p class="custom-block-title">Deprecated</p><p>Microsoft has deprecated CodeCoverage.exe. Please use <a href="#msvc-and-microsoft-codecoverage-console">Microsoft.CodeCoverage.Console</a> or <a href="#msvc-and-opencppcoverage">OpenCppCoverage</a> instead.</p></div><p>Microsoft provides CodeCoverage.exe as part of any current VisualStudio installation. It can also be downloaded as <a href="https://www.nuget.org/packages/Microsoft.CodeCoverage/16.8.3" target="_blank" rel="noreferrer">part of this NuGet package</a>.</p><p>When building your binary, make sure to also generate <code>.pdb</code> files for all code for which you wish to receive test coverage data. <strong>You must use a debug build without any compiler optimizations to get useful coverage data.</strong></p><p>Deploy your binary and the <code>.pdb</code> files to your test environment. Wrap the invocation of your binary during your tests with CodeCoverage.exe:</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">CodeCoverage.exe</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> collect</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> /output:&quot;C:\\path\\to\\output.coverage&quot;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> C:</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\p</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">ath</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\t</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">o</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\y</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">our</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\b</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">inary.exe</span></span></code></pre></div><p>After your process is terminated, a <code>.coverage</code> file will be written to the output path you specified.</p><p>Convert this file to XML as described in <a href="./../cs/#visual-studio-tfs-mstest-code-coverage">our guide for Visual Studio Code Coverage</a>. Then, <a href="./../../uploading-external-data/">upload the XML file to Teamscale</a>. Specify the report format <code>VS_COVERAGE</code>.</p><h2 id="performance-impact" tabindex="-1">Performance Impact <a class="header-anchor" href="#performance-impact" aria-label="Permalink to &quot;Performance Impact&quot;">​</a></h2><p>The following table gives an estimate of the runtime performance impact that each profiler might have on your program, however your mileage may vary. The sample program was very computing intensive, most programs that have more user interaction will likely see a significantly lower impact. A release build was used for all baseline runs. For the instrumented runs a release build was used when possible, otherwise a debug build.</p><table tabindex="0"><thead><tr><th>Profiler</th><th style="text-align:center;">Baseline</th><th style="text-align:center;">Instrumented</th><th style="text-align:center;">Average Impact</th></tr></thead><tbody><tr><td>clang / llvm-cov</td><td style="text-align:center;">43s</td><td style="text-align:center;">48s</td><td style="text-align:center;">12%</td></tr><tr><td>Bullseye</td><td style="text-align:center;">43s</td><td style="text-align:center;">55s</td><td style="text-align:center;">28%</td></tr><tr><td>Testwell CTC++</td><td style="text-align:center;">44s</td><td style="text-align:center;">61s</td><td style="text-align:center;">39%</td></tr><tr><td>gcc / gcov</td><td style="text-align:center;">140s</td><td style="text-align:center;">240s</td><td style="text-align:center;">71%</td></tr><tr><td>OpenCppCoverage</td><td style="text-align:center;">44s</td><td style="text-align:center;">110s</td><td style="text-align:center;">150%</td></tr><tr><td>CodeCoverage.exe/Microsoft.CodeCoverage.Console</td><td style="text-align:center;">43s</td><td style="text-align:center;">190s</td><td style="text-align:center;">342%</td></tr></tbody></table><h2 id="hardware-profilers" tabindex="-1">Hardware Profilers <a class="header-anchor" href="#hardware-profilers" aria-label="Permalink to &quot;Hardware Profilers&quot;">​</a></h2><p>A hardware profiler is a physical device that attaches to debug ports on your eval board. It interfaces directly with the CPU to receive debug information about the code that is being run on your board in real time and converts that into test coverage information. This method is advertised to have no performance impact at all.</p><p>Teamscale currently supports test coverage generated by the following hardware profilers:</p><ul><li><a href="https://accemic.com/cedartools/" target="_blank" rel="noreferrer">Accemic CEDARtools</a></li><li><a href="https://www.lauterbach.com/" target="_blank" rel="noreferrer">Lauterbach Trace32</a></li><li><a href="https://www.segger.com/products/debug-probes/j-link/" target="_blank" rel="noreferrer">Segger J-Link</a></li></ul>',14))])}const F=r(d,[["render",g]]);export{C as __pageData,F as default};
