import{_ as i,c as t,ak as a,o as e}from"./chunks/framework.D4LivsWb.js";const o=JSON.parse('{"title":"Maven Plugin","description":"","frontmatter":{"title":"Maven Plugin","pageClass":"wider-content"},"headers":[],"relativePath":"reference/integrations/maven-plugin/index.md","filePath":"reference/integrations/maven-plugin/index.md"}'),n={name:"reference/integrations/maven-plugin/index.md"};function l(h,s,p,r,k,d){return e(),t("div",null,[...s[0]||(s[0]=[a(`<h1 id="teamscale-maven-plugin" tabindex="-1">Teamscale Maven Plugin <a class="header-anchor" href="#teamscale-maven-plugin" aria-label="Permalink to &quot;Teamscale Maven Plugin&quot;">​</a></h1><p>The Teamscale Maven Plugin provides integration between Maven-based builds and Teamscale.</p><nav class="table-of-contents"><ul><li><a href="#overview">Overview</a></li><li><a href="#goals">Goals</a></li><li><a href="#usage">Usage</a><ul><li><a href="#test-impact-analysis">Test Impact Analysis</a></li><li><a href="#upload-to-teamscale">Upload to Teamscale</a></li></ul></li><li><a href="#common-configuration-parameters">Common Configuration Parameters</a><ul><li><a href="#authentication-and-connection">Authentication and Connection</a></li><li><a href="#commit-and-revision-specification">Commit and Revision Specification</a></li><li><a href="#code-coverage-control">Code Coverage Control</a></li><li><a href="#test-execution-control">Test Execution Control</a></li></ul></li><li><a href="#goal-specific-parameters">Goal-Specific Parameters</a><ul><li><a href="#tia-configuration-prepare-tia-unit-test-and-prepare-tia-integration-test">TIA Configuration (prepare-tia-unit-test and prepare-tia-integration-test)</a></li><li><a href="#testwise-coverage-converter-testwise-coverage-converter">Testwise Coverage Converter (testwise-coverage-converter)</a></li><li><a href="#coverage-upload-upload-coverage">Coverage Upload (upload-coverage)</a></li></ul></li><li><a href="#troubleshooting">Troubleshooting</a></li></ul></nav><h2 id="overview" tabindex="-1">Overview <a class="header-anchor" href="#overview" aria-label="Permalink to &quot;Overview&quot;">​</a></h2><p>The plugin offers the following main features:</p><ol><li><strong>Test Impact Analysis (TIA)</strong> – Automatically fetches and executes only impacted tests</li><li><strong>Testwise Coverage Recording</strong> – Records coverage data per test case</li><li><strong>Coverage Upload</strong> – Uploads Testwise Coverage or JaCoCo coverage reports to Teamscale</li></ol><h2 id="goals" tabindex="-1">Goals <a class="header-anchor" href="#goals" aria-label="Permalink to &quot;Goals&quot;">​</a></h2><p>The plugin provides the following goals:</p><table tabindex="0"><thead><tr><th>Goal</th><th>Description</th><th>Default Lifecycle Attachment</th></tr></thead><tbody><tr><td><code>prepare-tia-unit-test</code></td><td>Instruments Surefire unit tests to run impacted tests and collect Testwise Coverage</td><td><code>INITIALIZE</code></td></tr><tr><td><code>prepare-tia-integration-test</code></td><td>Instruments Failsafe integration tests to run impacted tests and collect Testwise Coverage</td><td><code>PACKAGE</code></td></tr><tr><td><code>testwise-coverage-report</code></td><td>Converts binary data produced during the tests to testwise coverage reports</td><td><code>VERIFY</code></td></tr><tr><td><code>upload-coverage</code></td><td>Uploads JaCoCo and Testwise Coverage reports to Teamscale</td><td><code>VERIFY</code></td></tr><tr><td><code>help</code></td><td>Displays help information for the plugin</td><td>-</td></tr></tbody></table><h2 id="usage" tabindex="-1">Usage <a class="header-anchor" href="#usage" aria-label="Permalink to &quot;Usage&quot;">​</a></h2><p>Add the plugin to your Maven POM file:</p><div class="language-xml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">xml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">project</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">   &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">properties</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">teamscale.plugin.version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;35.0.2&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">teamscale.plugin.version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">   &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">properties</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">   &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">build</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">pluginManagement</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">         &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugins</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugin</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">               &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;com.teamscale&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">               &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;teamscale-maven-plugin&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">               &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;\${teamscale.plugin.version}&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">               &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">configuration</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                  &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">teamscaleUrl</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;https://company.teamscale.io&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">teamscaleUrl</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                  &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">projectId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;myProject&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">projectId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                  &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">username</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;build&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">username</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                  &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">accessToken</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;myAccessToken&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">accessToken</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                  &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">includes</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                     &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">include</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;*com.company.*&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">include</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                  &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">includes</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">                  &lt;!-- More options see below --&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">               &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">configuration</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugin</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">         &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugins</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">pluginManagement</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">   &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">build</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">project</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span></code></pre></div><p>Check <a href="https://central.sonatype.com/artifact/com.teamscale/teamscale-maven-plugin" target="_blank" rel="noreferrer">here</a> for the latest version.</p><h3 id="test-impact-analysis" tabindex="-1">Test Impact Analysis <a class="header-anchor" href="#test-impact-analysis" aria-label="Permalink to &quot;Test Impact Analysis&quot;">​</a></h3><p>To perform Test Impact Analysis and/or collect Testwise Coverage you need to:</p><ul><li>Put the <code>impacted-test-engine</code> on the test classpath. This JUnit engine is responsible for querying Teamscale for impacted tests, makes sure to only run the returned subset of tests and informs the coverage profiler about when tests start and end.</li><li>Run the <code>prepare-tia-unit-test</code> and/or <code>prepare-tia-integration-test</code> goals to attach the coverage profiler to the test JVM.</li></ul><p>Apply those settings to all modules that contain relevant tests:</p><div class="language-xml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">xml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">project</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">   &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">dependencies</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">dependency</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">         &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;com.teamscale&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">         &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;impacted-test-engine&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">         &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;\${teamscale.plugin.version}&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">         &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">scope</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;test&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">scope</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">dependency</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">   &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">dependencies</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">   &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">build</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugins</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">         &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugin</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;com.teamscale&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;teamscale-maven-plugin&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">executions</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">               &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">execution</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                  &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goals</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                     &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goal</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;prepare-tia-unit-test&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goal</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                     &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goal</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;prepare-tia-integration-test&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goal</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                  &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goals</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">               &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">execution</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">executions</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">         &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugin</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugins</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">   &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">build</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">project</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span></code></pre></div><p>You might also want to only add this conditionally. By moving the configuration into a profile you can enable TIA by running the build with <code>-Dtia</code></p><div class="language-xml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">xml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">project</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">   &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">profiles</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">profile</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">         &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">id</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;tia&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">id</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">         &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">activation</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">property</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">               &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;tia&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">property</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">         &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">activation</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">         &lt;!-- Configuration from above --&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">profile</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">   &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">profiles</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">project</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span></code></pre></div><p>The profiler produces binary data that needs to be converted into a proper report before it can be uploaded to Teamscale. The <code>testwise-coverage-report</code> goal is responsible for performing this conversion. The goal should only be run once, i.e., in your aggregator module (see below).</p><h4 id="limitations" tabindex="-1">Limitations <a class="header-anchor" href="#limitations" aria-label="Permalink to &quot;Limitations&quot;">​</a></h4><ul><li><strong>JUnit 5</strong>: The plugin only supports tests based on the JUnit Platform and frameworks built on it (e.g., Serenity).</li><li><strong>Surefire Version</strong>: TIA only supports Surefire versions &gt;= 3.1.0</li><li><strong>Parallel Tests</strong>: TIA does not support parallelized tests. Ensure Surefire and Failsafe use:</li></ul><div class="language-xml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">xml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">forkCount</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;1&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">forkCount</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">threadCount</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;1&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">threadCount</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span></code></pre></div><ul><li><strong>Custom Test Execution</strong>: If your system-under-test is launched by means other than Surefire or Failsafe, ensure the <code>argLine</code> property is passed to that JVM. You can also use another property by specifying it via the <code>propertyName</code> configuration.</li></ul><h3 id="upload-to-teamscale" tabindex="-1">Upload to Teamscale <a class="header-anchor" href="#upload-to-teamscale" aria-label="Permalink to &quot;Upload to Teamscale&quot;">​</a></h3><p>The upload to Teamscale should typically only happen once for the whole build. To achieve this with Maven, you need an <strong>aggregator module</strong> that has a dependency (directly or indirectly) on all modules of your project. If you intend to collect Testwise Coverage, apply the plugin with the <code>testwise-coverage-report</code> goal in your aggregator module. If you intend to upload JaCoCo coverage, make sure to configure the JaCoCo Maven Plugin in the modules to generate XML reports.</p><div class="language-xml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">xml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">project</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">   &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">build</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugins</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">         &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugin</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;com.teamscale&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;teamscale-maven-plugin&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">executions</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">               &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">execution</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                  &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goals</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">                     &lt;!-- Only needed if you collect Testwise Coverage --&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                     &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goal</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;testwise-coverage-report&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goal</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                     </span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                     &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goal</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;upload-coverage&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goal</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                  &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goals</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">               &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">execution</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">executions</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">         &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugin</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugins</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">   &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">build</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">project</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span></code></pre></div><h2 id="common-configuration-parameters" tabindex="-1">Common Configuration Parameters <a class="header-anchor" href="#common-configuration-parameters" aria-label="Permalink to &quot;Common Configuration Parameters&quot;">​</a></h2><h3 id="authentication-and-connection" tabindex="-1">Authentication and Connection <a class="header-anchor" href="#authentication-and-connection" aria-label="Permalink to &quot;Authentication and Connection&quot;">​</a></h3><table tabindex="0"><thead><tr><th>Parameter</th><th>Description</th><th>Required</th></tr></thead><tbody><tr><td><code>teamscaleUrl</code></td><td>URL of your Teamscale instance</td><td>Yes</td></tr><tr><td><code>projectId</code></td><td>ID of your Teamscale project</td><td>Yes</td></tr><tr><td><code>username</code></td><td>Username for Teamscale authentication</td><td>Yes</td></tr><tr><td><code>accessToken</code></td><td>Access token for Teamscale authentication</td><td>Yes</td></tr></tbody></table><h3 id="commit-and-revision-specification" tabindex="-1">Commit and Revision Specification <a class="header-anchor" href="#commit-and-revision-specification" aria-label="Permalink to &quot;Commit and Revision Specification&quot;">​</a></h3><table tabindex="0"><thead><tr><th>Parameter</th><th>Description</th><th>Default</th></tr></thead><tbody><tr><td><code>commit</code></td><td>Override the commit to upload coverage to (format: <code>BRANCH:UNIX_EPOCH_TIMESTAMP_IN_MILLISECONDS</code>)</td><td>Auto-detected Git commit</td></tr><tr><td><code>revision</code></td><td>Override the revision to upload coverage to</td><td>Auto-detected Git revision</td></tr><tr><td><code>repository</code></td><td>Repository ID in Teamscale for revision lookup</td><td>All repositories in project</td></tr></tbody></table><h3 id="code-coverage-control" tabindex="-1">Code Coverage Control <a class="header-anchor" href="#code-coverage-control" aria-label="Permalink to &quot;Code Coverage Control&quot;">​</a></h3><table tabindex="0"><thead><tr><th>Parameter</th><th>Description</th><th>Default</th></tr></thead><tbody><tr><td><code>includes</code></td><td>Patterns for code to include in coverage instrumentation</td><td>No default</td></tr><tr><td><code>excludes</code></td><td>Patterns for code to exclude from coverage instrumentation</td><td>No default</td></tr></tbody></table><h3 id="test-execution-control" tabindex="-1">Test Execution Control <a class="header-anchor" href="#test-execution-control" aria-label="Permalink to &quot;Test Execution Control&quot;">​</a></h3><table tabindex="0"><thead><tr><th>Parameter</th><th>Description</th><th>Default</th></tr></thead><tbody><tr><td><code>runImpacted</code></td><td>Whether to execute only impacted tests</td><td><code>true</code></td></tr><tr><td><code>runAllTests</code></td><td>Whether to execute all tests regardless of impact</td><td><code>false</code></td></tr><tr><td><code>skip</code></td><td>Whether to skip the execution of the goal</td><td><code>false</code></td></tr></tbody></table><h2 id="goal-specific-parameters" tabindex="-1">Goal-Specific Parameters <a class="header-anchor" href="#goal-specific-parameters" aria-label="Permalink to &quot;Goal-Specific Parameters&quot;">​</a></h2><h3 id="tia-configuration-prepare-tia-unit-test-and-prepare-tia-integration-test" tabindex="-1">TIA Configuration (<code>prepare-tia-unit-test</code> and <code>prepare-tia-integration-test</code>) <a class="header-anchor" href="#tia-configuration-prepare-tia-unit-test-and-prepare-tia-integration-test" aria-label="Permalink to &quot;TIA Configuration (\`prepare-tia-unit-test\` and \`prepare-tia-integration-test\`)&quot;">​</a></h3><table tabindex="0"><thead><tr><th>Parameter</th><th>Description</th><th>Default</th></tr></thead><tbody><tr><td><code>unitTestPartition</code></td><td>Partition name for unit test reports (<code>prepare-tia-unit-test</code> only)</td><td>&quot;Unit Tests&quot;</td></tr><tr><td><code>integrationTestPartition</code></td><td>Partition name for integration test reports (<code>prepare-tia-integration-test</code> only)</td><td>&quot;Integration Tests&quot;</td></tr><tr><td><code>propertyName</code></td><td>Property name for JVM arguments</td><td><code>argLine</code>/<code>spring-boot.run.jvmArguments</code>/<code>tycho.testArgLine</code></td></tr><tr><td><code>additionalAgentOptions</code></td><td>Additional options for the Teamscale Java Profiler</td><td>None</td></tr><tr><td><code>agentPort</code></td><td>Port for Java agent communication</td><td>Auto-selected</td></tr><tr><td><code>debugLogging</code></td><td>Enable DEBUG level logging for the Java profiler and impacted test engine</td><td><code>false</code></td></tr><tr><td><code>baselineCommit</code></td><td>Baseline for impact analysis</td><td>None</td></tr><tr><td><code>baselineRevision</code></td><td>VCS revision for baseline</td><td>None</td></tr></tbody></table><h3 id="testwise-coverage-converter-testwise-coverage-converter" tabindex="-1">Testwise Coverage Converter (<code>testwise-coverage-converter</code>) <a class="header-anchor" href="#testwise-coverage-converter-testwise-coverage-converter" aria-label="Permalink to &quot;Testwise Coverage Converter (\`testwise-coverage-converter\`)&quot;">​</a></h3><table tabindex="0"><thead><tr><th>Parameter</th><th>Description</th><th>Default</th></tr></thead><tbody><tr><td><code>includes</code></td><td>Wildcard include patterns for JaCoCo class traversal</td><td><code>**</code></td></tr><tr><td><code>excludes</code></td><td>Wildcard exclude patterns for JaCoCo class traversal</td><td>None</td></tr><tr><td><code>splitAfter</code></td><td>Number of tests after which to split coverage into multiple reports</td><td>5000</td></tr></tbody></table><h3 id="coverage-upload-upload-coverage" tabindex="-1">Coverage Upload (<code>upload-coverage</code>) <a class="header-anchor" href="#coverage-upload-upload-coverage" aria-label="Permalink to &quot;Coverage Upload (\`upload-coverage\`)&quot;">​</a></h3><table tabindex="0"><thead><tr><th>Parameter</th><th>Description</th><th>Default</th></tr></thead><tbody><tr><td><code>unitTestPartition</code></td><td>Partition name for unit test reports</td><td>&quot;Unit Tests&quot;</td></tr><tr><td><code>integrationTestPartition</code></td><td>Partition name for integration test reports</td><td>&quot;Integration Tests&quot;</td></tr><tr><td><code>aggregatedTestPartition</code></td><td>Partition name for aggregated test reports</td><td>&quot;Aggregated Tests&quot;</td></tr></tbody></table><h2 id="troubleshooting" tabindex="-1">Troubleshooting <a class="header-anchor" href="#troubleshooting" aria-label="Permalink to &quot;Troubleshooting&quot;">​</a></h2><p>The plugin creates log files in the <code>target/tia/</code> directory to help diagnose issues:</p><ul><li><strong><code>agent.log</code></strong> – Logs from the Java profiler</li><li><strong><code>engine.log</code></strong> – Logs from the impacted test engine</li></ul><p>You can enable debug logging by adding the <code>debugLogging</code> configuration property or via the command line with <code>-DdebugLogging=true</code>:</p><div class="language-xml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">xml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugins</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">	&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugin</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;com.teamscale&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;teamscale-maven-plugin&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;\${teamscale.plugin.version}&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">configuration</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">			&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">debugLogging</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;true&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">debugLogging</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">			&lt;!-- More options --&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">configuration</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">	&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugin</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugins</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span></code></pre></div><p>If the log files are not created when executing your tests, check if you have <code>&lt;argLine&gt;...&lt;/argLine&gt;</code> in your <code>pom.xml</code> and remove it. This overwrites the arguments we set in the plugin and thus de-registers the coverage profiler.</p><p>In some cases, the test reports generated by Surefire/Failsafe may also contain error information. You can find them under <code>target/surefire-reports</code> after all tests have finished. Check the stdout/stderr of failing tests for additional error messages.</p><p>If the build fails after applying the above POM changes but works without them, try to re-run the build with <code>-e</code> to discover the error that caused this.</p><p>If you notice largely increased test runtimes on systems that set <code>&lt;reuseForks&gt;true&lt;/reuseForks&gt;</code> it is recommended to set the <code>tiaMode</code> to <code>exec-file</code>:</p><div class="language-xml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">xml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugins</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">	&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugin</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;com.teamscale&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;teamscale-maven-plugin&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;\${teamscale.plugin.version}&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">configuration</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">			&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">tiaMode</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;exec-file&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">tiaMode</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">			&lt;!-- More options --&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">configuration</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">	&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugin</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugins</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span></code></pre></div><p>Writing a testwise coverage report every time the JVM closes can be time-consuming, so writing raw .exec files instead, has been shown to increase test execution times. Have a look at the <a href="#testwise-coverage-converter-testwise-coverage-converter">testwise-coverage-converter</a> goal for more information. You can use the <a href="#coverage-upload-upload-coverage">upload-coverage</a> goal to then upload the created testwise coverage report to Teamscale.</p>`,55)])])}const g=i(n,[["render",l]]);export{o as __pageData,g as default};
