import{_ as a,c as s,ak as t,o as i}from"./chunks/framework.D4LivsWb.js";const o="/assets/api-reference-from-menu.Ch23_h9j.png",m=JSON.parse('{"title":"REST API","description":"","frontmatter":{},"headers":[],"relativePath":"reference/rest-api/index.md","filePath":"reference/rest-api/index.md"}'),n={name:"reference/rest-api/index.md"};function l(r,e,c,h,p,d){return i(),s("div",null,[...e[0]||(e[0]=[t('<h1 id="rest-api" tabindex="-1">REST API <a class="header-anchor" href="#rest-api" aria-label="Permalink to &quot;REST API&quot;">​</a></h1><p>The Teamscale server exposes all of its functionality as REST web services. All functionality used in the Web UI and the IDE integrations is built upon these services and can also be used programmatically.</p><nav class="table-of-contents"><ul><li><a href="#available-rest-services">Available REST Services</a></li><li><a href="#authentication">Authentication</a></li><li><a href="#result-representation">Result representation</a></li><li><a href="#examples">Examples</a></li><li><a href="#common-pitfalls">Common pitfalls</a></li></ul></nav><h2 id="available-rest-services" tabindex="-1">Available REST Services <a class="header-anchor" href="#available-rest-services" aria-label="Permalink to &quot;Available REST Services&quot;">​</a></h2><p>The list of REST services is available from a running Teamscale instance by clicking on the <i class="very large grey question icon"></i> icon at the top right and selecting <em>API Reference</em>.</p><p><img src="'+o+'" alt="API Reference menu item" width="411" height="318"></p><p>Our public API is versioned, so you can call <code>/api/v2025.8/projects</code> instead of <code>/api/projects</code> to receive the data model as of Teamscale 2025.8 even when a future version would return a different data model. Without a version the latest data model is returned. It is recommended to use the versioned API whenever possible.</p><p>To get an idea which service might be useful, you can also observe the calls made from the Web UI using the development tools of your web browser.</p><p>In case the necessary call is not shown in the documentation you can also switch to the internal services in the API reference to see the non-public services. However, we do not provide any guarantees on backwards compatibility for the internal services.</p><h2 id="authentication" tabindex="-1">Authentication <a class="header-anchor" href="#authentication" aria-label="Permalink to &quot;Authentication&quot;">​</a></h2><p>Authentication for Teamscale&#39;s REST API happens via <a href="https://en.wikipedia.org/wiki/Basic_access_authentication" target="_blank" rel="noreferrer">HTTP Basic Authentication</a> and thus requires a <em>user name</em> and the user&#39;s <a href="./../../glossary/#access-key"><em>access key</em></a> (<strong>not</strong> the password). The service call is then executed with the permissions of this user.</p><p>You can generate an access key on your profile page: <code>&lt;TEAMSCALE_URL&gt;/user/access-key</code></p><p>A sample call using authentication using <a href="https://curl.haxx.se/" target="_blank" rel="noreferrer">curl</a> to <code>https://demo.teamscale.com</code> for user <code>demo</code> with an access key <code>7eSRFFOEUqO7NhhqDeyB1yEbUsMzZGDN</code> would be:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">curl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --user</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> demo:7eSRFFOEUqO7NhhqDeyB1yEbUsMzZGDN</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;https://demo.teamscale.com/api/v2025.8/health-check&quot;</span></span></code></pre></div><h2 id="result-representation" tabindex="-1">Result representation <a class="header-anchor" href="#result-representation" aria-label="Permalink to &quot;Result representation&quot;">​</a></h2><p>Services will return JSON responses.</p><h2 id="examples" tabindex="-1">Examples <a class="header-anchor" href="#examples" aria-label="Permalink to &quot;Examples&quot;">​</a></h2><p>For first experiments, the tool curl can be used to query services from the command line. For this we assume the service to be running on <a href="http://localhost:8080/" target="_blank" rel="noreferrer">http://localhost:8080/</a>, the user name to be <code>bob</code> and his access key to be <code>e434mikm35d</code>.</p><p>To get the list of all projects visible to the user, you can use</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">curl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --user</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> bob:e434mikm35d</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;http://localhost:8080/api/v2025.8/projects&quot;</span></span></code></pre></div><p>To get the list of all findings for the project with ID <code>mon</code>:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">curl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --user</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> bob:e434mikm35d</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;http://localhost:8080/api/v2025.8/projects/mon/findings/list?all=true&quot;</span></span></code></pre></div><p>And, finally, to get the details for a single finding with specific ID for the same project:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">curl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --user</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> bob:e434mikm35d</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;http://localhost:8080/api/v2025.8/projects/mon/findings/D83B237D487AB7DE656ED61CA7032DC6&quot;</span></span></code></pre></div><h2 id="common-pitfalls" tabindex="-1">Common pitfalls <a class="header-anchor" href="#common-pitfalls" aria-label="Permalink to &quot;Common pitfalls&quot;">​</a></h2><p>Always make sure that you use the access key as password and not the actual password of the user when making REST calls. Also, the user needs to have sufficient permissions to view or change the corresponding data.</p><p>The branch information is usually passed in as parameter <code>t</code> in the format <code>BRANCHNAME:TIMESTAMP</code> (note the colon, which can stay unescaped in the URL), such as <code>master:1597993879000</code>. The timestamp is provided as milliseconds since the epoch (start of 1970), but you can also pass in the special value <code>HEAD</code> to get the latest data on the specified branch.</p><div class="warning custom-block"><p class="custom-block-title">WARNING</p><p>Timestamps are in milliseconds, while many other tools might produce timestamps in seconds. Make sure to convert these before passing to Teamscale.</p></div><p>If something does not work as expected, you can often find additional information in the <em>Service Log</em>, which is available via the Web UI (<em>System</em> perspective).</p>',29)])])}const k=a(n,[["render",l]]);export{m as __pageData,k as default};
