The name of the first class defined in a file should be the same as the filename.

# What Does This Check Look For?
This check identifies classes that are declared first in MATLAB (.m) files but whose names do not match the file name (excluding the extension).

# Why is This a Problem?
MATLAB may throw errors or behave unexpectedly if the first class name in the file and filename do not match.
Matching the class name to the filename makes your code easier to understand and maintain.

# How Can I Resolve This?
To avoid such problems, ensure that the class name matches the filename.
You can do this by either renaming the class or renaming the file to ensure consistency.

# Examples
## Non-Compliant

**myClass.m**
```matlab
classdef MyClass
    methods
        function obj = MyClass()
            % Constructor code
        end
        
        function greet(obj)
            disp('Hello from MyClass');
        end
    end
end
```

## Compliant

**MyClass.m**
```matlab
classdef MyClass
    methods
        function obj = MyClass()
            % Constructor code
        end
        
        function greet(obj)
            disp('Hello from MyClass');
        end
    end
end
```
