<h2>Why is this an issue?</h2>
<p>Unstable / flaky tests are tests which sometimes pass and sometimes fail, without any code change. Obviously, they slow down developments when
developers have to rerun failed tests. However, the real problem is that you can’t completely trust these tests, they might fail for many different
reasons and you don’t know if any of them will happen in production.</p>
<p>Some tools, such as TestNG, enable developers to automatically retry flaky tests. This might be acceptable as a temporary solution, but it should
eventually be fixed. The more flaky tests you add, the more chances there are for a bug to arrive in production.</p>
<p>This rule raises an issue when the annotation <code>org.testng.annotations.Test</code> is given a <code>successPercentage</code> argument with a
value lower than <code>100</code>.</p>
<h3>Noncompliant code example</h3>

```java
import org.testng.annotations.Test;

public class PercentageTest {
    @Test(successPercentage = 80, invocationCount = 10)  // Noncompliant. The test is allowed to fail 2 times.
    public void flakyTest() {
    }
}
```
<h2>Resources</h2>
<ul>
  <li> TestNG documentation - <a href="https://testng.org/#_annotations">Annotations</a> </li>
  <li> Spotify Engineering - <a
  href="https://engineering.atspotify.com/2019/11/18/test-flakiness-methods-for-identifying-and-dealing-with-flaky-tests/">Test Flakiness - Methods
  for identifying and dealing with flaky tests</a> </li>
</ul>