/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.ConfigurableObjectBase;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.commons.util.SerializationViews;
import org.conqat.engine.commons.util.canonical.CanonicalJson;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class QualityIndicator
extends ConfigurableObjectBase {
    private static final long serialVersionUID = 1L;
    static final String NAME_PROPERTY = "name";
    public static final String GROUPS_PROPERTY = "groups";
    public static final String INSTANCE_COMPARISON_ANALYSIS_GROUP_VIEW_PROPERTY = "analysisGroup";
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="groups")
    @CanonicalJson(ordering=@CanonicalJson.OrderBy(properties={"name"}))
    private final List<AnalysisGroup> groups = new ArrayList<AnalysisGroup>();

    @JsonCreator
    public QualityIndicator(@JsonProperty(value="name") String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UnmodifiableList<AnalysisGroup> getGroups() {
        return CollectionUtils.asUnmodifiable(this.groups);
    }

    public void addGroup(AnalysisGroup group) {
        this.groups.add(group);
    }

    public void removeGroup(AnalysisGroup group) {
        this.groups.remove(group);
    }

    @JsonGetter(value="analysisGroup")
    @JsonView(value={SerializationViews.InstanceComparisonView.class})
    @Schema(hidden=true)
    Map<String, AnalysisGroup> instanceComparisonAnalysisGroups() {
        return this.groups.stream().collect(Collectors.toMap(NamedConfigurableObjectBase::getName, Function.identity()));
    }

    public String toString() {
        return this.name;
    }

    public Map<String, Map<String, String>> getGroupToOptionsMapping() {
        HashMap<String, Map<String, String>> optionsMapPerGroup = new HashMap<String, Map<String, String>>();
        this.getGroups().forEach(group -> optionsMapPerGroup.put(group.getName(), group.getOptions()));
        return optionsMapPerGroup;
    }
}

