/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.model.EPasswordType;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public enum ERequirementsManagementTool implements IConnectorEnum<ERequirementsManagementTool>
{
    POLARION("Polarion", "images/connectors/polarion.png", "https://polarion.plm.automation.siemens.com/", "Reads work items from Polarion Application Lifecycle Management tool."),
    JIRA("Jira as Requirement Management Tool", "images/connectors/jira.svg", "https://www.atlassian.com/en/software/jira", "Loads issues from the Jira tracker.", true, EPasswordType.PASSWORD_OR_ACCESS_TOKEN),
    AZURE_DEVOPS("Azure DevOps Boards as Requirement Management Tool", "images/connectors/azure_devops.png", "https://docs.microsoft.com/en-us/azure/devops/boards/index?view=azure-devops", "Loads work items from Azure DevOps Boards (formerly known as TFS)."),
    RTC("IBM RTC/Jazz as Requirement Management Tool", "images/connectors/jazz.png", "http://www.jazz.net/", "Loads work items from an IBM RTC/Jazz server."),
    CODEBEAMER("codebeamer", "images/connectors/codebeamer.png", "https://codebeamer.com/", "Loads tracker items from codebeamer."),
    GITLAB("GitLab Issues as Requirement Management Tool", "images/connectors/gitlab.svg", "https://about.gitlab.com/", "Loads work items from a GitLab repository.", true, EPasswordType.ACCESS_TOKEN);

    private static final Map<String, ERequirementsManagementTool> REQUIREMENTS_MANAGEMENT_TOOL_BY_READABLE_NAME;
    private static final String READABLE_NAME_PROPERTY_NAME = "readableName";
    private static final String LOGO_URL_PROPERTY_NAME = "logoUrl";
    private static final String WEBSITE_URL_PROPERTY_NAME = "websiteUrl";
    private static final String DESCRIPTION_PROPERTY_NAME = "description";
    private static final String ACCOUNT_BASED_PROPERTY_NAME = "accountBased";
    private static final String PASSWORD_TYPE_PROPERTY_NAME = "passwordType";
    @JsonProperty(value="readableName")
    private final String readableName;
    @JsonProperty(value="logoUrl")
    private final String logoUrl;
    @JsonProperty(value="websiteUrl")
    private final String websiteUrl;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="accountBased")
    private final boolean accountBased;
    @JsonProperty(value="passwordType")
    private final EPasswordType passwordType;

    private ERequirementsManagementTool(String readableName, String logoUrl, String websiteUrl, String description) {
        this(readableName, logoUrl, websiteUrl, description, true, EPasswordType.PASSWORD);
    }

    private ERequirementsManagementTool(@JsonProperty(value="websiteUrl") String readableName, @JsonProperty(value="description") String logoUrl, @JsonProperty(value="accountBased") String websiteUrl, @JsonProperty(value="passwordType") String description, boolean accountBased, EPasswordType passwordType) {
        this.readableName = readableName;
        this.logoUrl = logoUrl;
        this.websiteUrl = websiteUrl;
        this.description = description;
        this.accountBased = accountBased;
        this.passwordType = passwordType;
    }

    @Override
    public String getReadableName() {
        return this.readableName;
    }

    @Override
    public String getLogoUrl() {
        return this.logoUrl;
    }

    @Override
    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public @Nullable String getLongDescription() {
        return null;
    }

    @Override
    public EPasswordType getPasswordType() {
        return this.passwordType;
    }

    @Override
    public Boolean isBeta() {
        return false;
    }

    public static Optional<ERequirementsManagementTool> findByReadableName(String readableName) {
        return Optional.ofNullable(REQUIREMENTS_MANAGEMENT_TOOL_BY_READABLE_NAME.get(readableName));
    }

    public static UnmodifiableSet<String> getReadableNames() {
        return CollectionUtils.asUnmodifiable(REQUIREMENTS_MANAGEMENT_TOOL_BY_READABLE_NAME.keySet());
    }

    static {
        REQUIREMENTS_MANAGEMENT_TOOL_BY_READABLE_NAME = Collections.unmodifiableMap(Arrays.stream(ERequirementsManagementTool.values()).collect(Collectors.toMap(ERequirementsManagementTool::getReadableName, Function.identity())));
    }
}

