/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.profiler;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.log.LogCount;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.ShortLogEntryBase;
import java.util.stream.Stream;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ShortProfilerLog
extends ShortLogEntryBase {
    private static final long serialVersionUID = 1L;
    private static final String MESSAGE_PROPERTY_NAME = "message";
    private static final String LEVEL_PROPERTY_NAME = "level";
    @JsonProperty(value="level")
    private final ELogLevel level;
    @JsonProperty(value="message")
    private final String message;

    public ShortProfilerLog(LogEntryIdentifier id, LogCount logCount, String message) {
        this(id, logCount.getHighestLogLevel(), logCount, message);
    }

    public ShortProfilerLog(LogEntryIdentifier id, ELogLevel level, LogCount logCount, String message) {
        super(id, logCount, null);
        this.level = level;
        this.message = message;
    }

    @Override
    protected void appendFields(StringBuilder builder) {
        builder.append(this.getLogCount().getHighestLogLevel()).append("\t");
        builder.append(this.getTimestampFormattedWithZone()).append("\t");
        builder.append(this.message).append("\n ");
    }

    @Override
    protected void appendErrorStatistics(StringBuilder builder) {
    }

    @Override
    protected Stream<String> getFilterCriteria() {
        return Stream.concat(super.getFilterCriteria(), Stream.of(this.message));
    }

    @Override
    public LogIndexBase.EIndexLogLevel getIndexLogLevel() {
        LogIndexBase.EIndexLogLevel indexLogLevel = super.getIndexLogLevel();
        if (indexLogLevel != LogIndexBase.EIndexLogLevel.INFO) {
            return indexLogLevel;
        }
        LogCount logCount = this.getLogCount();
        if (logCount.info() == 0 && logCount.debug() > 0) {
            return LogIndexBase.EIndexLogLevel.DEBUG;
        }
        return LogIndexBase.EIndexLogLevel.INFO;
    }
}

