/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.source;

import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.source.IMetricSource;
import com.teamscale.core.metrics.source.MetricAggregationUtils;
import com.teamscale.core.metrics.values.EMetricValueType;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class IndexMetricSource
implements IMetricSource {
    private static final long serialVersionUID = 1L;
    private final String metricPartition;

    public IndexMetricSource(String metricPartition) {
        this.metricPartition = metricPartition;
    }

    public String getMetricPartition() {
        return this.metricPartition;
    }

    @Override
    public void init(int metricOffset, MetricDirectorySchema schema) {
        MetricDirectorySchemaEntry entry = schema.getEntry(metricOffset);
        CCSMAssert.isTrue((boolean)entry.getValueType().supportsAggregation(entry.getAggregation()), (String)("Unsupported combination of aggregation and type for metric " + entry.getName()));
    }

    @Override
    public boolean isDerived() {
        return false;
    }

    @Override
    public void generateValue(Object[] values, boolean hasChildren, MetricDirectorySchemaEntry schemaEntry, CounterSet<String> codeScopeNames) {
    }

    @Override
    public Object aggregate(List<Object> values, MetricDirectorySchemaEntry schemaEntry) {
        MetricDirectorySchemaEntry.EAggregation aggregation = schemaEntry.getAggregation();
        if (aggregation == MetricDirectorySchemaEntry.EAggregation.NONE) {
            return null;
        }
        return switch (schemaEntry.getValueType()) {
            default -> throw new MatchException(null, null);
            case EMetricValueType.NUMERIC -> MetricAggregationUtils.aggregateDouble(values, aggregation);
            case EMetricValueType.ASSESSMENT -> MetricAggregationUtils.aggregateAssessment(values);
            case EMetricValueType.COUNTER_SET -> MetricAggregationUtils.aggregateCounterSet(values);
            case EMetricValueType.TIMESTAMP -> MetricAggregationUtils.aggregateTimestamp(values, aggregation);
            case EMetricValueType.STRING -> MetricAggregationUtils.aggregateStrings(values);
            case EMetricValueType.DATE_ONLY -> MetricAggregationUtils.aggregateTimestamp(values, aggregation);
        };
    }
}

