/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public abstract class DashboardMigratorBase
extends SerializedValueMigratorBase {
    private static final Pattern MULTI_WHITESPACE = Pattern.compile("\\s{2,}");
    private static final String RANDOM_SESSION_IDENTIFIER = RandomStringUtils.randomAlphabetic((int)100);
    private static final String PATH_REPLACER = RANDOM_SESSION_IDENTIFIER + "PATH";
    private static final String PROJECT_REPLACER = RANDOM_SESSION_IDENTIFIER + "PROJECT";
    public static final String PROJECT_ID_PLACEHOLDER = "<PROJECT>";
    public static final String PATH_PLACEHOLDER = "<PATH>";
    public static final String PROJECT_NAME_PLACEHOLDER = "<PROJECT_NAME>";

    protected DashboardMigratorBase() {
        super(true);
    }

    @Override
    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    @Override
    public String getStoreName() {
        return "dashboards";
    }

    @Override
    public Set<String> getAdditionalStoreNames() {
        return Set.of("dashboard-templates");
    }

    public abstract String migrateDescriptorJSON(String var1) throws MigrationException;

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws IOException, MigrationException {
        for (SerializedObject entity : entityPool.getRootEntities(SerializedObject.class)) {
            int fieldValueHandle = (Integer)entity.getFieldValue("descriptorJSON");
            if (fieldValueHandle == 0) continue;
            SerializedStringObject entityObject = (SerializedStringObject)entityPool.getEntity(fieldValueHandle, SerializedStringObject.class);
            if (entityObject == null) {
                return;
            }
            entityObject.setValue(this.migrateDescriptorJSON(entityObject.getValue()));
        }
    }

    public static String migrateJsonInDescriptorXml(String xml, Function<JsonNode, JsonNode> migrator) throws MigrationException {
        return DashboardMigratorBase.migrateDescriptorJSONContent(xml, new SafeJsonDescriptorMigrator(migrator));
    }

    public static String migrateJsonWidgetsInDescriptor(String json, Function<ObjectNode, ObjectNode> widgetMigrator) throws MigrationException {
        return new SafeJsonWidgetMigrator(widgetMigrator).migrate(json);
    }

    private static JsonNode parseAsSafeJson(String json) throws JsonSerializationException {
        String safeValidJson = json.replace(PROJECT_ID_PLACEHOLDER, PROJECT_REPLACER).replace(PATH_PLACEHOLDER, PATH_REPLACER);
        return JsonUtils.deserializeFromJson((String)safeValidJson);
    }

    private static String serializeSafeJsonToString(JsonNode jsonNode) throws JsonSerializationException {
        String migratedJson = JsonUtils.serializeToJSONPrettyPrinted((Object)jsonNode);
        return migratedJson.replace(PROJECT_REPLACER, PROJECT_ID_PLACEHOLDER).replace(PATH_REPLACER, PATH_PLACEHOLDER);
    }

    protected static void renameAttribute(ObjectNode widgetElement, String oldAttribute, String newAttribute) {
        if (widgetElement.has(oldAttribute)) {
            widgetElement.set(newAttribute, widgetElement.get(oldAttribute));
            widgetElement.remove(oldAttribute);
        }
    }

    private static String migrateDescriptorJSONContent(String xml, JsonDescriptorMigrator migrator) throws MigrationException {
        String changedXml = DashboardMigratorBase.compactXmlContent(xml);
        String findDescriptorJsonRegex = "<descriptorJSON><!\\[CDATA\\[(.*)\\]\\]></descriptorJSON>";
        Matcher matcher = Pattern.compile(findDescriptorJsonRegex).matcher(changedXml);
        if (!matcher.find()) {
            return xml;
        }
        String descriptorJsonContent = matcher.group(1);
        String migratedJsonContent = migrator.migrate(descriptorJsonContent);
        return changedXml.replace(descriptorJsonContent, migratedJsonContent);
    }

    private static String compactXmlContent(String xml) {
        return StringUtils.replaceAll((String)StringUtils.replaceLineBreaks((String)xml, (String)""), (Pattern)MULTI_WHITESPACE, (String)" ");
    }

    @Override
    public abstract EStorageSystemVersion getVersion();

    public static final class SafeJsonDescriptorMigrator
    implements JsonDescriptorMigrator {
        private final Function<JsonNode, JsonNode> migrator;

        public SafeJsonDescriptorMigrator(Function<JsonNode, JsonNode> migrator) {
            this.migrator = migrator;
        }

        @Override
        public String migrate(String descriptorJSON) throws MigrationException {
            try {
                JsonNode descriptor = DashboardMigratorBase.parseAsSafeJson(descriptorJSON);
                return DashboardMigratorBase.serializeSafeJsonToString(this.migrator.apply(descriptor));
            }
            catch (ConQATException e) {
                throw new MigrationException("Error during JSON migration.", e);
            }
        }
    }

    @FunctionalInterface
    protected static interface JsonDescriptorMigrator {
        public String migrate(String var1) throws MigrationException;
    }

    public static final class SafeJsonWidgetMigrator
    implements JsonDescriptorMigrator {
        private final Function<ObjectNode, ObjectNode> widgetMigrator;

        public SafeJsonWidgetMigrator(Function<ObjectNode, ObjectNode> widgetMigrator) {
            this.widgetMigrator = widgetMigrator;
        }

        @Override
        public String migrate(String descriptorJSON) throws MigrationException {
            return new SafeJsonDescriptorMigrator(this::migrateDescriptor).migrate(descriptorJSON);
        }

        private JsonNode migrateDescriptor(JsonNode json) {
            ArrayNode widgets;
            JsonNode descriptor = json.get("descriptor");
            if (descriptor == null) {
                descriptor = json;
            }
            if ((widgets = (ArrayNode)descriptor.get("widgets")) == null) {
                return json;
            }
            ArrayList<JsonNode> migratedWidgets = new ArrayList<JsonNode>();
            for (JsonNode widgetElement : widgets) {
                if (widgetElement.isNull()) continue;
                migratedWidgets.add((JsonNode)this.widgetMigrator.apply((ObjectNode)widgetElement));
            }
            widgets.removeAll();
            widgets.addAll(migratedWidgets);
            return json;
        }
    }
}

