/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.api.progress;

import java.util.EnumSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass
public enum EAnalysisState {
    INITIAL_ANALYSIS,
    HISTORY_ANALYSIS,
    LIVE_ANALYSIS,
    CATCHUP_LIVE_ANALYSIS,
    ROLLBACK_ANALYSIS;

    private static final EnumSet<EAnalysisState> INTERMEDIATE_ANALYSIS_STATES;
    private static final EnumSet<EAnalysisState> LIVE_ANALYSIS_STATES;

    public static EAnalysisState getAnalysisStateAfterRollback(EAnalysisState preRollbackState) {
        return switch (preRollbackState.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> INITIAL_ANALYSIS;
            case 1 -> HISTORY_ANALYSIS;
            case 2, 3, 4 -> ROLLBACK_ANALYSIS;
        };
    }

    public boolean isLive() {
        return LIVE_ANALYSIS_STATES.contains((Object)this);
    }

    public boolean isIntermediate() {
        return INTERMEDIATE_ANALYSIS_STATES.contains((Object)this);
    }

    static {
        INTERMEDIATE_ANALYSIS_STATES = EnumSet.of(HISTORY_ANALYSIS, ROLLBACK_ANALYSIS, CATCHUP_LIVE_ANALYSIS);
        LIVE_ANALYSIS_STATES = EnumSet.of(LIVE_ANALYSIS, CATCHUP_LIVE_ANALYSIS);
    }
}

