/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.performance;

import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.runtime.api.performance.PerformanceDetailEntry;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SectionProfilingMonitor
implements IProfilingMonitor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, Long> startNanoTimes = new HashMap<String, Long>();
    private final Map<String, Long> spentNanoTimes = new LinkedHashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startProfiling(String sectionName) {
        String key = SectionProfilingMonitor.makeStartNanoTimesKey(sectionName);
        Map<String, Long> map = this.startNanoTimes;
        synchronized (map) {
            if (this.startNanoTimes.containsKey(key)) {
                LOGGER.warn("Had start profiling event twice for section " + sectionName + " and thread id " + Thread.currentThread().getId());
            }
            this.startNanoTimes.put(key, System.nanoTime());
        }
    }

    private static String makeStartNanoTimesKey(String sectionName) {
        return Thread.currentThread().getId() + "-" + sectionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopProfiling(String sectionName) {
        Long startTime;
        String key = SectionProfilingMonitor.makeStartNanoTimesKey(sectionName);
        Map<String, Long> map = this.startNanoTimes;
        synchronized (map) {
            startTime = this.startNanoTimes.remove(key);
        }
        if (startTime == null) {
            LOGGER.warn("Stopped profiling for a section that was not even started: " + sectionName + " and thread id " + Thread.currentThread().getId());
            return;
        }
        long time = System.nanoTime() - startTime;
        Map<String, Long> map2 = this.spentNanoTimes;
        synchronized (map2) {
            this.spentNanoTimes.merge(sectionName, time, Long::sum);
        }
    }

    public void appendToEntry(PerformanceDetailEntry performanceEntry) {
        for (Map.Entry<String, Long> entry : this.spentNanoTimes.entrySet()) {
            performanceEntry.addSectionTime(entry.getKey(), Math.round((double)entry.getValue().longValue() / 1000000.0));
        }
    }
}

