/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.trigger.RollbackRequestedCommitDescriptor;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.trigger.ConcurrentSchedulingLimit;
import com.teamscale.core.runtime.impl.analysis.trigger.ETriggerType;
import com.teamscale.core.runtime.impl.analysis.trigger.ITrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.rollback.RollbackTrigger;
import com.teamscale.core.runtime.impl.scheduling.AssignedJobs;
import com.teamscale.core.runtime.impl.scheduling.CommitDescriptorMerger;
import com.teamscale.core.runtime.impl.scheduling.JobQueue;
import com.teamscale.core.runtime.impl.scheduling.PredecessorCommitFinder;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.scheduling.TriggerCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class BestAssignableJobFinder {
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    protected static final String PENDING_WRITE_CONFLICT_ERROR_MESSAGE = "Not schedulable due to pending writes";
    @VisibleForTesting
    protected static String MAINTENANCE_CONFLICT_ERROR_MESSAGE = "Not schedulable due to maintenance concurrency conflict";
    private static final int PER_BRANCH_COMMIT_LIMIT = Integer.getInteger("com.teamscale.scheduler.per-branch-commit-limit", 10);
    private static final int OVERALL_COMMIT_LIMIT = Integer.getInteger("com.teamscale.scheduler.overall-commit-limit", 100);
    private final AssignedJobs assignedJobs;
    private final SupplierWithException<Collection<JobDescriptor>, StorageException> overallAssignedJobs;
    private final JobQueue jobQueue;
    private final TriggerCache triggerCache;
    private final SetMap<CommitDescriptor, String> currentlyWrittenStores = new SetMap();
    private final SetMap<CommitDescriptor, String> currentlyWrittenIsolatedStores = new SetMap();
    private final Map<@Nullable CommitDescriptor, Set<String>> transitiveWriteSetByCommitCache = new HashMap<CommitDescriptor, Set<String>>();
    private final Map<@Nullable CommitDescriptor, Set<String>> transitiveWriteBlockingReadSetByCommitCache = new HashMap<CommitDescriptor, Set<String>>();
    private final Set<String> usedCrossCommitWriteBlockingStores = new HashSet<String>();
    private Consumer<String> traceWriter;
    private final PredecessorCommitFinder predecessorCommitFinder;

    public BestAssignableJobFinder(AssignedJobs assignedJobs, JobQueue jobQueue, TriggerCache triggerCache, @Nullable CommitDescriptorIndex commitDescriptorIndex, boolean onlyPrivileged, SupplierWithException<Collection<JobDescriptor>, StorageException> overallAssignedJobs) throws TriggerCompilationException, StorageException {
        this.assignedJobs = assignedJobs;
        this.overallAssignedJobs = overallAssignedJobs;
        this.jobQueue = onlyPrivileged ? BestAssignableJobFinder.filterToPrivileged(jobQueue) : jobQueue;
        for (ScheduledJob job : jobQueue.getAllJobs()) {
            if (triggerCache == null || !triggerCache.findTrigger(job.getJob()).isEmpty()) continue;
            LOGGER.error("Had to remove job because it was not found in the trigger cache: {}", (Object)job);
            jobQueue.removeJob(job);
        }
        this.triggerCache = triggerCache;
        this.predecessorCommitFinder = new PredecessorCommitFinder(jobQueue, assignedJobs, commitDescriptorIndex);
        this.fillCurrentlyWrittenStores();
    }

    public void setTraceWriter(Consumer<String> traceWriter) {
        this.traceWriter = traceWriter;
    }

    private static JobQueue filterToPrivileged(JobQueue jobQueue) throws StorageException {
        List contained = CollectionUtils.filter(jobQueue.getAllJobs(), job -> job.getJob().getTriggerType() == ETriggerType.PRIVILEGED);
        return jobQueue.createFilteredView(contained);
    }

    private void fillCurrentlyWrittenStores() throws TriggerCompilationException {
        for (ScheduledJob job : this.assignedJobs.getAllJobs()) {
            ITrigger trigger = this.triggerCache.getTrigger(job);
            this.currentlyWrittenStores.addAll((Object)job.getSchedulingCommit(), trigger.getWriteStores());
            if (trigger.getConcurrency() != ETriggerConcurrency.PARALLEL) {
                this.currentlyWrittenIsolatedStores.addAll((Object)job.getSchedulingCommit(), trigger.getWriteStores());
            }
            this.usedCrossCommitWriteBlockingStores.addAll(trigger.getCrossCommitBlockingWriteStores());
        }
    }

    private Set<String> getTransitiveWriteSetByCommit(@Nullable CommitDescriptor commit) throws TriggerCompilationException {
        return this.getStoreSetCached(commit, this.transitiveWriteSetByCommitCache, ITrigger::getTransitiveWriteStores);
    }

    private Set<String> getTransitiveWriteBlockingReadSetByCommit(@Nullable CommitDescriptor commit) throws TriggerCompilationException {
        return this.getStoreSetCached(commit, this.transitiveWriteBlockingReadSetByCommitCache, ITrigger::getTransitiveWriteBlockingReadStores);
    }

    private Set<String> getStoreSetCached(CommitDescriptor commit, Map<@Nullable CommitDescriptor, Set<String>> cache, Function<ITrigger, Set<String>> triggerToStoreResolver) throws TriggerCompilationException {
        Set<String> result = cache.get(commit);
        if (result != null) {
            return result;
        }
        result = new HashSet<String>();
        for (ScheduledJob job : this.jobQueue.getJobsForCommit(commit)) {
            result.addAll((Collection<String>)triggerToStoreResolver.apply(this.triggerCache.getTrigger(job)));
        }
        for (ScheduledJob job : this.assignedJobs.getJobsForCommit(commit)) {
            result.addAll((Collection<String>)triggerToStoreResolver.apply(this.triggerCache.getTrigger(job)));
        }
        cache.put(commit, result);
        return result;
    }

    public ScheduledJob findBestAssignableJob() throws TriggerCompilationException, StorageException {
        LOGGER.traceEntry("Try to find best assignable job", new org.apache.logging.log4j.util.Supplier[0]);
        this.writeTrace(() -> "Job queue:\n%s\n".formatted(this.jobQueue));
        this.writeTrace(() -> "Assigned jobs:\n%s\n".formatted(this.assignedJobs));
        if (this.isFullyIsolatedJobRunning()) {
            this.writeTrace("No job, as fully isolated job is running");
            return (ScheduledJob)LOGGER.traceExit("Found no job", null);
        }
        List<ScheduledJob> precommitRollbackJobs = this.listPrecommitRollbackJobs();
        if (!precommitRollbackJobs.isEmpty()) {
            this.writeTrace("Early exit, as pre-commit rollback was found");
            return (ScheduledJob)LOGGER.traceExit("Found job: {}", (Object)BestAssignableJobFinder.pickEarliest(precommitRollbackJobs));
        }
        List<ScheduledJob> allFullyIsolatedJobs = this.listFullyIsolatedJobs();
        if (!allFullyIsolatedJobs.isEmpty()) {
            if (this.assignedJobs.isEmpty()) {
                this.writeTrace("Early exit, as fully isolated jobs are pending and no jobs are assigned");
                return (ScheduledJob)LOGGER.traceExit("Found job: {}", (Object)BestAssignableJobFinder.pickEarliest(allFullyIsolatedJobs));
            }
            this.writeTrace("Early exit, as fully isolated pre-commit jobs are pending");
            return (ScheduledJob)LOGGER.traceExit("Found job: {}", (Object)this.findFullyIsolatedPreCommitJob());
        }
        if (this.isRollbackRunningForNonPreCommitBranch()) {
            this.writeTrace("Early exit, as rollback is running for non-precommit branch is running");
            LOGGER.traceExit((Object)"Found no job");
            return null;
        }
        if (this.jobQueue.existsJobForCommit(null)) {
            this.writeTrace("Jobs without scheduling commit are pending and are preferred. No other jobs are considered.");
            ScheduledJob job = this.findBestAssignableJob(null);
            if (job != null) {
                return (ScheduledJob)LOGGER.traceExit("Found job: {}", (Object)job);
            }
            LOGGER.traceExit((Object)"Found no job");
            return null;
        }
        if (this.jobQueue.existsJobForCommit(RollbackRequestedCommitDescriptor.ROLLBACK_REQUESTED_COMMIT)) {
            this.writeTrace("Jobs for ROLLBACK_REQUESTED_COMMIT are pending and are preferred. No other jobs are considered.");
            return (ScheduledJob)LOGGER.traceExit("Found job: {}", (Object)this.findBestAssignableJob(RollbackRequestedCommitDescriptor.ROLLBACK_REQUESTED_COMMIT));
        }
        return (ScheduledJob)LOGGER.traceExit("Found job: {}", (Object)this.findBestNormalAssignableJob());
    }

    private ScheduledJob findFullyIsolatedPreCommitJob() throws TriggerCompilationException {
        List preCommitCommits = CollectionUtils.filter(this.jobQueue.getAllNonNullSchedulingCommits(), PreCommitUtils::isPrecommitCommit);
        for (CommitDescriptor commit : preCommitCommits) {
            for (ScheduledJob job : this.jobQueue.getJobsForCommit(commit)) {
                if (this.triggerCache.getTrigger(job).getConcurrency() != ETriggerConcurrency.PRIORITY_FULLY_ISOLATED) continue;
                return job;
            }
        }
        return null;
    }

    private static ScheduledJob pickEarliest(List<ScheduledJob> jobs) {
        return Collections.min(jobs, Comparator.comparing(ScheduledJob::getSchedulingCommit, CommitDescriptor.BY_TIMESTAMP_COMPARATOR));
    }

    private List<ScheduledJob> listPrecommitRollbackJobs() {
        return this.queuedRollbackJobs().filter(job -> PreCommitUtils.isPrecommitJob(job.getJob())).collect(Collectors.toList());
    }

    private List<ScheduledJob> listFullyIsolatedJobs() throws TriggerCompilationException {
        ArrayList<ScheduledJob> result = new ArrayList<ScheduledJob>();
        for (ScheduledJob job : this.jobQueue.getOneJobForEachTrigger()) {
            if (this.triggerCache.getTrigger(job).getConcurrency() != ETriggerConcurrency.PRIORITY_FULLY_ISOLATED) continue;
            result.addAll(this.jobQueue.getJobsForTrigger(job.getTriggerName()));
        }
        return result;
    }

    private boolean isRollbackRunningForNonPreCommitBranch() {
        return this.runningRollbackJobs().anyMatch(scheduledJob -> !PreCommitUtils.isPrecommitJob(scheduledJob.getJob()));
    }

    private boolean isRollbackRunningOrQueuedForAnyPreCommitBranch() {
        return this.queuedAndRunningRollbackJobs().anyMatch(scheduledJob -> PreCommitUtils.isPrecommitJob(scheduledJob.getJob()));
    }

    private Stream<ScheduledJob> runningRollbackJobs() {
        return this.assignedJobs.getJobsForTrigger(RollbackTrigger.class.getName()).stream();
    }

    private Stream<ScheduledJob> queuedAndRunningRollbackJobs() {
        Stream<ScheduledJob> queued = this.queuedRollbackJobs();
        return Stream.concat(this.runningRollbackJobs(), queued);
    }

    private Stream<ScheduledJob> queuedRollbackJobs() {
        return this.jobQueue.getJobsForTrigger(RollbackTrigger.class.getName()).stream();
    }

    private ScheduledJob findBestNormalAssignableJob() throws TriggerCompilationException, StorageException {
        LOGGER.traceEntry("Try to find best normal assignable job", new org.apache.logging.log4j.util.Supplier[0]);
        int count = 0;
        CounterSet commitsPerBranch = new CounterSet();
        HashSet<String> blockedByRollbackBranches = new HashSet<String>();
        for (CommitDescriptor commit : this.jobQueue.getOrderedCommits()) {
            this.writeTrace("Considering scheduling commit {}", commit);
            if (commit == null || commitsPerBranch.inc((Object)commit.getBranchName()) > PER_BRANCH_COMMIT_LIMIT || blockedByRollbackBranches.contains(commit.getBranchName())) {
                this.writeTrace("Done with branch, as too many commits are pending or rollbacks are pending");
                continue;
            }
            ScheduledJob bestJob = this.findBestAssignableJob(commit);
            if (bestJob != null) {
                return (ScheduledJob)LOGGER.traceExit("Found job: {}", (Object)bestJob);
            }
            if (this.isRollbackInQueueForCommit(commit)) {
                this.writeTrace("Marking branch as blocked by rollback: {}", commit.getBranchName());
                blockedByRollbackBranches.add(commit.getBranchName());
                continue;
            }
            if (++count <= OVERALL_COMMIT_LIMIT) continue;
            break;
        }
        if ((this.traceWriter != null || LOGGER.isTraceEnabled()) && !this.jobQueue.isEmpty()) {
            this.writeTrace("Unable to find normal job to assign.\nJob Queue size: {}\nOrdered commits size: {}\n", this.jobQueue.size(), this.jobQueue.getOrderedCommits().size());
            if (this.jobQueue.getOrderedCommits().stream().map(this.jobQueue::getJobsForCommit).mapToInt(Collection::size).sum() != this.jobQueue.size()) {
                this.writeTrace("Inconsistent job queue!\nJobQueue: {}\nOrdered commits: {}\n", this.jobQueue.getAllJobs(), this.jobQueue.getOrderedCommits());
            }
        }
        LOGGER.traceExit((Object)"Found no normal job");
        return null;
    }

    private boolean isRollbackInQueueForCommit(CommitDescriptor commit) {
        return CollectionUtils.anyMatch(this.jobQueue.getJobsForCommit(commit), job -> RollbackTrigger.class.getName().equals(job.getTriggerName()));
    }

    private boolean isFullyIsolatedJobRunning() throws TriggerCompilationException {
        for (ScheduledJob job : this.assignedJobs.getAllJobs()) {
            if (this.triggerCache.getTrigger(job).getConcurrency() != ETriggerConcurrency.PRIORITY_FULLY_ISOLATED) continue;
            return true;
        }
        return false;
    }

    private ScheduledJob findBestAssignableJob(CommitDescriptor commit) throws TriggerCompilationException, StorageException {
        LOGGER.traceEntry("Try to find best assignable job for commit: {}", new Object[]{commit});
        Set<ScheduledJob> assignableJobs = this.jobQueue.getJobsForCommit(commit);
        int maxExecutionOrder = Integer.MAX_VALUE;
        for (ScheduledJob job : this.assignedJobs.getJobsForCommit(commit)) {
            maxExecutionOrder = Math.min(maxExecutionOrder, this.triggerCache.getTrigger(job).getExecutionOrderIndex());
        }
        this.writeTrace("Only considering jobs with execution order {}", maxExecutionOrder);
        for (ScheduledJob job : this.getBestExecutionOrderJobs(assignableJobs, maxExecutionOrder)) {
            this.writeTrace("Considering job {}", job);
            if (!this.canBeScheduled(job)) continue;
            return (ScheduledJob)LOGGER.traceExit("Found job {}", (Object)job);
        }
        LOGGER.traceExit((Object)"Found no job");
        return null;
    }

    private Collection<ScheduledJob> getBestExecutionOrderJobs(Collection<ScheduledJob> jobs, int maxExecutionOrder) throws TriggerCompilationException {
        int bestExecutionOrderIndex = maxExecutionOrder;
        PairList jobCandidates = new PairList();
        for (ScheduledJob job : jobs) {
            ITrigger trigger = this.triggerCache.getTrigger(job);
            int executionOrderIndex = trigger.getExecutionOrderIndex();
            if (executionOrderIndex < bestExecutionOrderIndex) {
                bestExecutionOrderIndex = executionOrderIndex;
                jobCandidates.clear();
            }
            if (executionOrderIndex != bestExecutionOrderIndex) continue;
            jobCandidates.add((Object)job, (Object)trigger.getPriority());
        }
        CollectionUtils.sortBySecond((PairList)jobCandidates, Comparator.reverseOrder());
        return jobCandidates.getFirstList();
    }

    private boolean canBeScheduled(ScheduledJob job) throws TriggerCompilationException, StorageException {
        boolean isRegularJob;
        LOGGER.traceEntry("Trying to schedule job {}", new Object[]{job});
        if (job.getEarliestScheduleTimestamp() > DateTimeUtils.millisNow()) {
            this.writeTrace("Execution blocked by trigger until {}", job.getEarliestScheduleTimestamp());
            return false;
        }
        ITrigger trigger = this.triggerCache.getTrigger(job);
        if (this.isInRollbackConflict(job, trigger)) {
            this.writeTrace("Not schedulable due to rollback conflict");
            return (Boolean)LOGGER.traceExit("Can be scheduled: {}", (Object)false);
        }
        if (this.isInIsolationConflict(job, trigger)) {
            this.writeTrace("Not schedulable due to isolation conflict");
            return (Boolean)LOGGER.traceExit("Can be scheduled: {}", (Object)false);
        }
        if (this.isInMaintenanceConcurrencyConflict(job, trigger)) {
            this.writeTrace(MAINTENANCE_CONFLICT_ERROR_MESSAGE);
            return (Boolean)LOGGER.traceExit("Can be scheduled: {}", (Object)false);
        }
        if (this.isBlockedByPrecommitRollbackJob(job)) {
            this.writeTrace("Not schedulable due to pending precommit rollback");
            return (Boolean)LOGGER.traceExit("Can be scheduled: {}", (Object)false);
        }
        if (this.isBlockedByCrossCommitWrites(trigger)) {
            this.writeTrace("Not schedulable due to cross-commit write blocks");
            return (Boolean)LOGGER.traceExit("Can be scheduled: {}", (Object)false);
        }
        if (this.isSchedulingCommitBlocked(job)) {
            this.writeTrace("Not schedulable due to scheduling commit block");
            return (Boolean)LOGGER.traceExit("Can be scheduled: {}", (Object)false);
        }
        if (this.isBlockedByMaxConcurrentExecutions(job, trigger)) {
            this.writeTrace("Not schedulable due to maximum concurrent executions");
            return false;
        }
        CommitDescriptor schedulingCommit = job.getSchedulingCommit();
        boolean bl = isRegularJob = schedulingCommit != null;
        if (isRegularJob && this.isBlockedByIsolatedStores(job, trigger)) {
            this.writeTrace("Not schedulable due to currently written isolated stores");
            return (Boolean)LOGGER.traceExit("Can be scheduled: {}", (Object)false);
        }
        if (isRegularJob && this.isBlockedByOutputIsolatedPendingWrites(job, trigger)) {
            this.writeTrace("Not schedulable due to output isolation (and other pending writes)");
            return (Boolean)LOGGER.traceExit("Can be scheduled: {}", (Object)false);
        }
        if (this.isBlockedByPendingWritesOnSameCommit(trigger, schedulingCommit)) {
            this.writeTrace("Not schedulable as inputs are still potentially written to");
            return (Boolean)LOGGER.traceExit("Can be scheduled: {}", (Object)false);
        }
        if (this.isBlockedByPendingWrites(trigger, schedulingCommit)) {
            this.writeTrace(PENDING_WRITE_CONFLICT_ERROR_MESSAGE);
            return (Boolean)LOGGER.traceExit("Can be scheduled: {}", (Object)false);
        }
        if (this.isBlockedByPendingTransitiveReads(trigger, schedulingCommit)) {
            this.writeTrace("Not schedulable due to pending transitive reads");
            return (Boolean)LOGGER.traceExit("Can be scheduled: {}", (Object)false);
        }
        return (Boolean)LOGGER.traceExit("Can be scheduled: {}", (Object)true);
    }

    private boolean isBlockedByIsolatedStores(ScheduledJob job, ITrigger trigger) {
        if (BestAssignableJobFinder.hasWriteOverlap(this.currentlyWrittenIsolatedStores, job, trigger)) {
            this.writeTrace(() -> "Is blocked by isolated stores: %s".formatted(BestAssignableJobFinder.getWriteOverlap(this.currentlyWrittenIsolatedStores, job, trigger)));
            return true;
        }
        return false;
    }

    private boolean isBlockedByOutputIsolatedPendingWrites(ScheduledJob job, ITrigger trigger) {
        if (trigger.getConcurrency() != ETriggerConcurrency.OUTPUT_ISOLATED) {
            return false;
        }
        if (BestAssignableJobFinder.hasWriteOverlap(this.currentlyWrittenStores, job, trigger)) {
            this.writeTrace(() -> "Is blocked by output isolated stores: %s".formatted(BestAssignableJobFinder.getWriteOverlap(this.currentlyWrittenStores, job, trigger)));
            return true;
        }
        return false;
    }

    private boolean isBlockedByPendingWritesOnSameCommit(ITrigger trigger, @Nullable CommitDescriptor commit) throws TriggerCompilationException {
        Set<String> writeSet = this.getTransitiveWriteSetByCommit(commit);
        if (CollectionUtils.containsAnyBut(writeSet, trigger.getReadStores(), trigger.getWriteStores())) {
            this.writeTrace(() -> {
                HashSet overlap = new HashSet(writeSet);
                overlap.removeAll(trigger.getWriteStores());
                overlap.retainAll(trigger.getReadStores());
                return "Is blocked by pending writes on same commit into input stores: %s".formatted(overlap);
            });
            return true;
        }
        return false;
    }

    private boolean isBlockedByCrossCommitWrites(ITrigger trigger) {
        if (CollectionUtils.containsAny(this.usedCrossCommitWriteBlockingStores, trigger.getCrossCommitBlockingWriteStores())) {
            this.writeTrace(() -> "Is blocked by cross-commit blocking stores: %s".formatted(CollectionUtils.intersectionSet(this.usedCrossCommitWriteBlockingStores, (Collection[])new Collection[]{trigger.getCrossCommitBlockingWriteStores()})));
            return true;
        }
        return false;
    }

    private boolean isBlockedByMaxConcurrentExecutions(ScheduledJob job, ITrigger trigger) throws StorageException {
        if (job.getSchedulingCommit() == null) {
            return false;
        }
        int limit = trigger.getConcurrentSchedulingLimit().map(ConcurrentSchedulingLimit::getLimit).orElse(-1);
        if (limit < 0) {
            return false;
        }
        String prefixedTriggerName = TriggerBuilder.buildTriggerName("", TriggerBuilder.getSimpleTriggerName(trigger.getAnalysisStepClass()));
        Predicate<String> isSameTrigger = triggerName -> triggerName.equals(job.getTriggerName()) || triggerName.endsWith(prefixedTriggerName);
        int alreadyAssignedJobCount = (int)((Collection)this.overallAssignedJobs.get()).stream().map(JobDescriptor::getTriggerName).filter(isSameTrigger).count();
        return alreadyAssignedJobCount >= limit;
    }

    private static boolean hasWriteOverlap(SetMap<CommitDescriptor, String> writtenStoresByCommit, ScheduledJob job, ITrigger trigger) {
        Set writtenStores = (Set)writtenStoresByCommit.getCollection((Object)job.getSchedulingCommit());
        if (writtenStores == null || writtenStores.isEmpty()) {
            return false;
        }
        return CollectionUtils.containsAny((Set)writtenStores, trigger.getWriteStores());
    }

    private static Set<String> getWriteOverlap(SetMap<CommitDescriptor, String> writtenStoresByCommit, ScheduledJob job, ITrigger trigger) {
        Set writtenStores = (Set)writtenStoresByCommit.getCollection((Object)job.getSchedulingCommit());
        if (writtenStores == null || writtenStores.isEmpty()) {
            return Collections.emptySet();
        }
        return CollectionUtils.intersectionSet((Collection)writtenStores, (Collection[])new Collection[]{trigger.getWriteStores()});
    }

    private boolean isSchedulingCommitBlocked(ScheduledJob job) throws TriggerCompilationException {
        CommitDescriptor schedulingCommit = job.getSchedulingCommit();
        return this.isBlockedByAssignedParentCandidates(schedulingCommit) || this.isBlockedByPreAnnouncement(job);
    }

    private boolean isBlockedByAssignedParentCandidates(CommitDescriptor commit) {
        EntryMessage entryMessage = LOGGER.traceEntry("isBlockedByAssignedParentCandidates(commit={})", new Object[]{commit});
        if (!(commit instanceof ParentedCommitDescriptor)) {
            this.writeTrace(() -> "Commit is no parented commit");
            return (Boolean)LOGGER.traceExit(entryMessage, (Object)false);
        }
        for (CommitDescriptor parentCommit : BestAssignableJobFinder.getParentsOnOtherBranches((ParentedCommitDescriptor)commit)) {
            for (ScheduledJob assignedJob : this.assignedJobs.getAllJobs()) {
                long offset;
                CommitDescriptor assignedCommit = assignedJob.getSchedulingCommit();
                if (assignedCommit == null || !parentCommit.getBranchName().equals(assignedCommit.getBranchName()) || assignedCommit.getTimestamp() < parentCommit.getTimestamp() || assignedCommit.getTimestamp() >= commit.getTimestamp() || !CommitDescriptorMerger.isInMergeWindow(offset = assignedCommit.getTimestamp() - parentCommit.getTimestamp())) continue;
                this.writeTrace(() -> "Blocked by commit %s in merge window for parent %s".formatted(assignedCommit, parentCommit));
                return (Boolean)LOGGER.traceExit(entryMessage, (Object)true);
            }
        }
        return (Boolean)LOGGER.traceExit(entryMessage, (Object)false);
    }

    private boolean isBlockedByPrecommitRollbackJob(ScheduledJob job) {
        if (PreCommitUtils.isPrecommitChangeRetriever(job.getTriggerName())) {
            return this.isRollbackRunningOrQueuedForAnyPreCommitBranch();
        }
        return this.isBlockingRollbackRunningForSamePreCommitBranch(job);
    }

    private boolean isBlockingRollbackRunningForSamePreCommitBranch(ScheduledJob job) {
        CommitDescriptor schedulingCommit = job.getSchedulingCommit();
        if (schedulingCommit == null || !PreCommitUtils.isPrecommitBranch(schedulingCommit.getBranchName())) {
            return false;
        }
        return this.runningRollbackJobs().anyMatch(rollbackJob -> {
            CommitDescriptor rollbackCommit = rollbackJob.getSchedulingCommit();
            if (rollbackCommit == null) {
                LOGGER.error("Encountered unexpected rollback job with no rollback commit: {}", (Object)job);
                return false;
            }
            if (!PreCommitUtils.isPrecommitCommit(rollbackCommit)) {
                LOGGER.error("Encountered rollback job for non-precommit branch at unexpected scheduler phase: {}", (Object)job);
                return false;
            }
            if (!schedulingCommit.getBranchName().equals(rollbackCommit.getBranchName())) {
                return false;
            }
            return schedulingCommit.getTimestamp() > rollbackCommit.getTimestamp();
        });
    }

    private static List<CommitDescriptor> getParentsOnOtherBranches(ParentedCommitDescriptor commit) {
        return CollectionUtils.filter((Collection)commit.getParentCommits(), parent -> !parent.getBranchName().equals(commit.getBranchName()));
    }

    private boolean isBlockedByPreAnnouncement(ScheduledJob job) throws TriggerCompilationException {
        EntryMessage entryMessage = LOGGER.traceEntry("isBlockedByPreAnnouncement(job={})", new Object[]{job});
        CommitDescriptor commit = job.getSchedulingCommit();
        if (commit == null) {
            this.writeTrace(() -> "Periodic execution");
            return (Boolean)LOGGER.traceExit(entryMessage, (Object)false);
        }
        OptionalLong optionalFirstPreAnnouncedTimestamp = this.jobQueue.getFirstBlockingPreAnnouncement(commit);
        if (optionalFirstPreAnnouncedTimestamp.isPresent() && this.isBlockedByPreAnnouncement(job, commit, optionalFirstPreAnnouncedTimestamp.getAsLong())) {
            long timestamp = optionalFirstPreAnnouncedTimestamp.getAsLong();
            this.writeTrace(() -> "Blocked by pre-announcement %d".formatted(timestamp));
            return (Boolean)LOGGER.traceExit(entryMessage, (Object)true);
        }
        if (!(commit instanceof ParentedCommitDescriptor)) {
            this.writeTrace(() -> "Commit is no parented commit");
            return (Boolean)LOGGER.traceExit(entryMessage, (Object)false);
        }
        for (CommitDescriptor parentCommit : BestAssignableJobFinder.getParentsOnOtherBranches((ParentedCommitDescriptor)commit)) {
            long firstPreAnnouncedTimestamp;
            optionalFirstPreAnnouncedTimestamp = this.jobQueue.getFirstBlockingPreAnnouncement(parentCommit);
            if (optionalFirstPreAnnouncedTimestamp.isEmpty() || this.isBlockedByPreAnnouncement(job, parentCommit, firstPreAnnouncedTimestamp = optionalFirstPreAnnouncedTimestamp.getAsLong())) continue;
            long timestampOffset = firstPreAnnouncedTimestamp - parentCommit.getTimestamp();
            if (firstPreAnnouncedTimestamp >= commit.getTimestamp() || !CommitDescriptorMerger.isInMergeWindow(timestampOffset)) continue;
            this.writeTrace(() -> "Blocked by pre-announcement %d in merge window for parent %s".formatted(firstPreAnnouncedTimestamp, parentCommit));
            return (Boolean)LOGGER.traceExit(entryMessage, (Object)true);
        }
        return (Boolean)LOGGER.traceExit(entryMessage, (Object)false);
    }

    private boolean isBlockedByPreAnnouncement(ScheduledJob job, CommitDescriptor commit, long firstPreAnnouncedTimestamp) throws TriggerCompilationException {
        long timestamp = commit.getTimestamp();
        if (RollbackTrigger.class.getName().equals(job.getTriggerName())) {
            return timestamp > firstPreAnnouncedTimestamp;
        }
        if (JobQueue.isPreAnnouncingTrigger(this.triggerCache, job)) {
            if (this.jobQueue.isPreAnnouncementCausedByJob(job, commit.getBranchName(), firstPreAnnouncedTimestamp)) {
                return timestamp > firstPreAnnouncedTimestamp;
            }
            return timestamp >= firstPreAnnouncedTimestamp;
        }
        return timestamp >= firstPreAnnouncedTimestamp;
    }

    private boolean isInRollbackConflict(ScheduledJob job, ITrigger trigger) {
        boolean blocked;
        if (trigger.getConcurrency() != ETriggerConcurrency.ROLLBACK_ISOLATED) {
            return false;
        }
        Set<String> preCommitCommits = BestAssignableJobFinder.getPreCommitRollbackCommits(job.getSchedulingCommit());
        if (!preCommitCommits.isEmpty()) {
            return this.mayRollbackPreCommitBranch(preCommitCommits);
        }
        boolean bl = blocked = !this.assignedJobs.isEmpty();
        if (blocked) {
            this.writeTrace("Is blocked by non-empty assigned jobs");
        }
        return blocked;
    }

    private static Set<String> getPreCommitRollbackCommits(CommitDescriptor schedulingCommit) {
        List<CommitDescriptor> rollbackCommits;
        if (schedulingCommit instanceof RollbackRequestedCommitDescriptor) {
            RollbackRequestedCommitDescriptor rollbackRequestedCommit = (RollbackRequestedCommitDescriptor)schedulingCommit;
            rollbackCommits = rollbackRequestedCommit.getSchedulingHints();
        } else {
            rollbackCommits = List.of(schedulingCommit);
        }
        return rollbackCommits.stream().filter(PreCommitUtils::isPrecommitCommit).map(CommitDescriptor::getBranchName).collect(Collectors.toSet());
    }

    private boolean mayRollbackPreCommitBranch(Set<String> rollbackPreCommitCommits) {
        return CollectionUtils.anyMatch(this.assignedJobs.getAllJobs(), assigned -> {
            if (PreCommitUtils.isPrecommitChangeRetriever(assigned.getTriggerName())) {
                this.writeTrace(() -> "Is blocked by pre-commit change retriever");
                return true;
            }
            CommitDescriptor assignedSchedulingCommit = assigned.getSchedulingCommit();
            if (assignedSchedulingCommit == null) {
                return false;
            }
            boolean blocked = rollbackPreCommitCommits.contains(assignedSchedulingCommit.getBranchName());
            if (blocked) {
                this.writeTrace(() -> "Is blocked by assigned pre-commit job on same branch: " + String.valueOf(assigned));
            }
            return blocked;
        });
    }

    private boolean isBlockedByPendingWrites(ITrigger trigger, @Nullable CommitDescriptor commit) throws StorageException, TriggerCompilationException {
        for (CommitDescriptor previousCommit : this.getPotentialPredecessorCommits(commit)) {
            Set<String> previousWrittenStores = this.getTransitiveWriteSetByCommit(previousCommit);
            if (!CollectionUtils.containsAnyBut(previousWrittenStores, trigger.getWriteStores(), trigger.getWriteVirtualStores()) && !CollectionUtils.containsAny(previousWrittenStores, trigger.getReadOnlyPreviousStores()) && !CollectionUtils.containsAny(previousWrittenStores, trigger.getReadStores())) continue;
            this.writeTrace(() -> {
                HashSet writeOverlap = new HashSet(previousWrittenStores);
                writeOverlap.retainAll(trigger.getWriteStores());
                writeOverlap.removeAll(trigger.getWriteVirtualStores());
                HashSet readOverlap = new HashSet(previousWrittenStores);
                readOverlap.retainAll(trigger.getReadOnlyPreviousStores());
                return "Is blocked by pending writes in previous commit %s.\nWrite overlap: %s\nRead overlap: %s".formatted(previousCommit, writeOverlap, readOverlap);
            });
            return true;
        }
        return false;
    }

    private boolean isBlockedByPendingTransitiveReads(ITrigger trigger, @Nullable CommitDescriptor commit) throws StorageException, TriggerCompilationException {
        for (CommitDescriptor previousCommit : this.getPotentialPredecessorCommits(commit)) {
            Set<String> previousWriteBlockingReadStores = this.getTransitiveWriteBlockingReadSetByCommit(previousCommit);
            if (!CollectionUtils.containsAnyBut(previousWriteBlockingReadStores, trigger.getWriteStores(), trigger.getWriteVirtualStores())) continue;
            this.writeTrace(() -> {
                HashSet writeOverlap = new HashSet(previousWriteBlockingReadStores);
                writeOverlap.retainAll(trigger.getWriteStores());
                writeOverlap.removeAll(trigger.getWriteVirtualStores());
                return "Is blocked by pending transitive reads in previous commit %s.\nOverlap: %s".formatted(previousCommit, writeOverlap);
            });
            return true;
        }
        return false;
    }

    private boolean isInIsolationConflict(ScheduledJob isolatedJob, ITrigger trigger) throws TriggerCompilationException {
        if (trigger.getConcurrency() != ETriggerConcurrency.ISOLATED) {
            return false;
        }
        if (isolatedJob.getSchedulingCommit() == null && isolatedJob.getJob().getTriggerType() == ETriggerType.PRIVILEGED) {
            boolean blocked;
            boolean bl = blocked = !this.assignedJobs.isEmpty();
            if (blocked) {
                this.writeTrace("Is blocked by non-empty assigned jobs");
            }
            return blocked;
        }
        for (ScheduledJob assignedJob : this.assignedJobs.getAllJobs()) {
            if (this.triggerCache.getTrigger(assignedJob).getConcurrency() != ETriggerConcurrency.ISOLATED) continue;
            this.writeTrace(() -> "Is blocked by another currently running isolated trigger: %s".formatted(assignedJob));
            return true;
        }
        return false;
    }

    private boolean isInMaintenanceConcurrencyConflict(ScheduledJob maintenanceJob, ITrigger trigger) {
        return switch (trigger.getConcurrency()) {
            case ETriggerConcurrency.MAINTENANCE -> this.assignedJobs.existsJobForTrigger(maintenanceJob.getTriggerName());
            case ETriggerConcurrency.MAINTENANCE_PARALLEL -> BestAssignableJobFinder.isParallelJobWithSchedulingConflict(maintenanceJob, this.assignedJobs, this.triggerCache.getParallelPrivilegedTriggers());
            default -> false;
        };
    }

    private static boolean isParallelJobWithSchedulingConflict(ScheduledJob maintenanceJob, AssignedJobs assignedJobs, List<ITrigger> parallelPrivilegedTriggers) {
        Set assignedParallelJobs = parallelPrivilegedTriggers.stream().map(privilegedTrigger -> assignedJobs.getJobsForTrigger(privilegedTrigger.getAnalysisStepClass().getName())).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        String currentJobParameter = maintenanceJob.getJob().getParameter();
        for (ScheduledJob assignedJob : assignedParallelJobs) {
            String parameter = assignedJob.getJob().getParameter();
            if (parameter == null || !parameter.equals(currentJobParameter)) continue;
            return true;
        }
        return false;
    }

    private List<CommitDescriptor> getPotentialPredecessorCommits(@Nullable CommitDescriptor commit) throws StorageException {
        return this.predecessorCommitFinder.getPotentialPredecessorCommits(commit);
    }

    private void writeTrace(String text, Object ... params) {
        if (this.traceWriter != null) {
            String result = text;
            for (Object param : params) {
                String replacementString = Matcher.quoteReplacement(String.valueOf(param));
                result = result.replaceFirst("\\{}", replacementString);
            }
            this.traceWriter.accept(result);
        }
        LOGGER.trace(text, params);
    }

    private void writeTrace(String text) {
        if (this.traceWriter != null) {
            this.traceWriter.accept(text);
        }
        LOGGER.trace(text);
    }

    private void writeTrace(Supplier<String> textSupplier) {
        String text = null;
        if (this.traceWriter != null) {
            text = textSupplier.get();
            this.traceWriter.accept(text);
        }
        if (LOGGER.isTraceEnabled()) {
            if (text == null) {
                text = textSupplier.get();
            }
            LOGGER.trace(text);
        }
    }
}

