/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.StringValuePairListOptionDescriptor;
import com.teamscale.core.migration.IJsonFileVersion;
import com.teamscale.core.migration.IJsonMigration;
import com.teamscale.core.migration.IJsonMigrator;
import com.teamscale.core.migration.JsonMigrator;
import com.teamscale.core.migration.JsonMigratorWithKnownResult;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.index.configuration.AnalysisProfileMigrationUtils;
import com.teamscale.index.configuration.CommentAnalysisConfiguration;
import com.teamscale.index.configuration.migrations.V174CrossComponentCloneMigration;
import com.teamscale.index.configuration.migrations.V195SonarLintUpdateMigration;
import com.teamscale.index.configuration.migrations.V200ExternalFindingTypeIds;
import com.teamscale.index.configuration.tools.ABAPLintConfiguration;
import com.teamscale.index.configuration.tools.CodeInspectorConfiguration;
import com.teamscale.index.configuration.tools.SonarLintConfiguration;
import com.teamscale.index.migration.AnalysisProfileVersion184MagicNumberUsageOptions;
import com.teamscale.index.migration.ConditionalStatementsSwiftMigrator;
import com.teamscale.index.migration.MigrateVersion185CppcheckUseCheckID;
import com.teamscale.index.migration.MigrateVersion195CppcheckSeparateChecks;
import com.teamscale.index.migration.MigrationVersion125TslintRules;
import com.teamscale.index.migration.MigrationVersion130ClangTidyCheckNames;
import com.teamscale.index.migration.MigrationVersion144ABAPLintConfigFileUtils;
import com.teamscale.index.migration.MigrationVersion158VariousUpdates;
import com.teamscale.index.migration.MigrationVersion159ESLintUpdates;
import com.teamscale.index.migration.MigrationVersion160SecurityCodeScan;
import com.teamscale.index.migration.MigrationVersion163RemoveDeletedSecurityCodeScanChecks;
import com.teamscale.index.migration.MigrationVersion170ExceptionCatching;
import com.teamscale.index.migration.MigrationVersion205RemoveTestSmellGroup;
import com.teamscale.index.migration.finding.ConfigurationOptionDeletion;
import com.teamscale.index.migration.finding.ConfigurationOptionMigrationBase;
import com.teamscale.index.migration.finding.ConfigurationOptionReplacement;
import com.teamscale.index.migration.finding.DataDrivenFindingMigration;
import com.teamscale.index.migration.finding.GlobalBooleanOptionAddition;
import com.teamscale.index.migration.finding.GlobalOptionDeletion;
import com.teamscale.index.migration.finding.GlobalOptionReplacement;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.registry.CheckRegistry;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.NonNull;

@IndexValueClass
public enum EAnalysisProfileVersion implements IJsonFileVersion<AnalysisProfile, Context>,
MetaIndex.IMetaIndexEntry
{
    ANALYSIS_PROFILE_VERSION_121{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_122{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(List.of(new ConfigurationOptionDeletion("ABAPLint cli executable path", "")));
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_123{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{DataDrivenFindingMigration.migrateQualityIndicatorAndCategory(SonarLintConfiguration.class, EAnalysisProfileVersion.SONARLINT_MIGRATIONS_LOCATION, 122, false)});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_124{

        public @NonNull JsonMigrator getMigrator(String json, Context context) throws MigrationException {
            Set<String> languages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(json);
            if (languages.contains("SWIFT") && !languages.contains("ABAP")) {
                return new JsonMigrator(List.of(new ConfigurationOptionReplacement("nesting", "Nesting Depth", "swift-nesting", "Nesting Depth"), new ConfigurationOptionReplacement("cyclomatic_complexity", "Complexity", "swift-cyclomatic_complexity", "Complexity")));
            }
            return JsonMigrator.NO_OP_MIGRATOR;
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_125{

        public @NonNull JsonMigrator getMigrator(String json, Context context) throws MigrationException {
            Set<String> languages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(json);
            if (languages.contains("CPP") && !languages.contains("JAVA") && !languages.contains("CS")) {
                return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionDeletion("Possible division by zero", "Possible Bugs")});
            }
            return JsonMigrator.NO_OP_MIGRATOR;
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_126{

        public @NonNull IJsonMigrator getMigrator(@Language(value="JSON") String json, Context context) throws MigrationException {
            String resultJson = json;
            try {
                ObjectNode profile = (ObjectNode)JsonUtils.deserializeFromJson((String)json, ObjectNode.class);
                if (6.replaceTsLintInTools(profile)) {
                    6.replaceTsLintOptions(profile);
                    resultJson = JsonUtils.serializeToJSON((Object)profile);
                }
            }
            catch (JsonSerializationException e) {
                throw new MigrationException((Throwable)e);
            }
            ArrayList<ConfigurationOptionMigrationBase> migrations = new ArrayList<ConfigurationOptionMigrationBase>();
            migrations.addAll(MigrationVersion125TslintRules.MIGRATION_125_REMOVED_RULES_MIGRATIONS);
            migrations.addAll(MigrationVersion125TslintRules.MIGRATION_125_REPLACED_RULES_MIGRATIONS);
            if (resultJson.equals(json)) {
                return new JsonMigrator(migrations);
            }
            return new JsonMigratorWithKnownResult(new JsonMigrator(migrations).migrate(resultJson));
        }

        private static boolean replaceTsLintInTools(ObjectNode profile) {
            JsonNode toolNode = profile.get("tools");
            boolean foundTslint = false;
            boolean foundEslint = false;
            Iterator iterator = toolNode.elements();
            while (iterator.hasNext()) {
                JsonNode currentNode = (JsonNode)iterator.next();
                if (currentNode.textValue().equals("TSLINT")) {
                    foundTslint = true;
                    iterator.remove();
                    continue;
                }
                if (!currentNode.textValue().equals("ESLINT")) continue;
                foundEslint = true;
            }
            if (foundTslint && !foundEslint) {
                ((ArrayNode)toolNode).add("ESLINT");
            }
            return foundTslint;
        }

        private static void replaceTsLintOptions(ObjectNode profile) throws MigrationException {
            LinkedHashMap<String, String> options = AnalysisProfileMigrationUtils.getOptionsInUse(profile);
            CCSMAssert.isNotNull(options);
            if (!((String)options.get("TSLint settings file")).isEmpty()) {
                LogManager.getLogger().warn("TSLint settings file detected. The migration from TSLint to ESLint will ignore all settings from the old settings files. These settings need to be manually migrated to an ESLint config file.");
            }
            options.remove("TSLint settings file");
            options.remove("TSLint executable path");
            options.putIfAbsent("ESLint settings file", "");
            ObjectMapper mapper = JsonUtils.getObjectMapper();
            profile.set("options", mapper.valueToTree(options));
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_127{

        public @NonNull JsonMigrator getMigrator(String json, Context context) throws MigrationException {
            if (!AnalysisProfileMigrationUtils.getToolsInUseJson(json).contains("CLANG_TIDY")) {
                return JsonMigrator.NO_OP_MIGRATOR;
            }
            Set<String> languages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(json);
            if (languages.contains("OBJECTIVE_C") && !languages.contains("CPP")) {
                return 7.removeOptionsPresentInFile("clangtidy_cpp_options.txt");
            }
            if (languages.contains("CPP") && !languages.contains("OBJECTIVE_C")) {
                return 7.removeOptionsPresentInFile("clangtidy_objc_options.txt");
            }
            return JsonMigrator.NO_OP_MIGRATOR;
        }

        private static JsonMigrator removeOptionsPresentInFile(String fileName) {
            ArrayList<ConfigurationOptionDeletion> migrations = new ArrayList<ConfigurationOptionDeletion>();
            for (String line : Resource.of(EAnalysisProfileVersion.class, (String)("migration/ANALYSIS_PROFILE_VERSION_127/" + fileName)).getLines()) {
                String[] groupAndOptionName = StringUtils.splitByWholeSeparator((String)line, (String)"---", (int)2);
                String analysisGroup = groupAndOptionName[0];
                String optionName = groupAndOptionName[1];
                migrations.add(new ConfigurationOptionDeletion(optionName, analysisGroup));
            }
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_128{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            ArrayList<IJsonMigration> migrations = new ArrayList<IJsonMigration>(DataDrivenFindingMigration.migrateFromReadableNameToIds(EAnalysisProfileVersion.class, EAnalysisProfileVersion.SONARLINT_MIGRATIONS_LOCATION, 128));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_129{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            ArrayList<DataDrivenFindingMigration> migrations = new ArrayList<DataDrivenFindingMigration>();
            migrations.add(DataDrivenFindingMigration.migrateQualityIndicatorAndCategory(CheckRegistry.class, "/META-INF/migrations/internal-checks/", 128, true));
            migrations.add(DataDrivenFindingMigration.migrateQualityIndicatorAndCategory(SonarLintConfiguration.class, EAnalysisProfileVersion.SONARLINT_CS_MIGRATIONS_LOCATION, 128, true));
            migrations.add(DataDrivenFindingMigration.migrateQualityIndicatorAndCategory(CodeInspectorConfiguration.class, EAnalysisProfileVersion.CODE_INSPECTOR_MIGRATIONS_LOCATION, 128, true));
            migrations.add(DataDrivenFindingMigration.migrateQualityIndicatorAndCategory(ABAPLintConfiguration.class, EAnalysisProfileVersion.ABAPLINT_MIGRATIONS_LOCATION, 128, true));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_130{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            List<IJsonMigration> migrations = DataDrivenFindingMigration.migrateFromReadableNameToIds(EAnalysisProfileVersion.class, EAnalysisProfileVersion.CLANG_TIDY_MIGRATIONS_LOCATION, 130);
            migrations.addAll(MigrationVersion130ClangTidyCheckNames.CHECK_OPTION_RENAMING);
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_131{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionDeletion("SA1603", "Malformed Comments")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_132{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{DataDrivenFindingMigration.migrateQualityIndicatorAndCategory(CodeInspectorConfiguration.class, EAnalysisProfileVersion.ABAPLINT_MIGRATIONS_LOCATION, 131, true)});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_133{

        public @NonNull JsonMigrator getMigrator(String json, Context context) throws MigrationException {
            Set<String> analysisProfileLanguages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(json);
            if (analysisProfileLanguages.contains("CPP")) {
                return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionReplacement("cqse-friend-declaration", "Error-prone Practices", "cqse-friend-declaration", "Design Flaws")});
            }
            return JsonMigrator.NO_OP_MIGRATOR;
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_134{

        public @NonNull JsonMigrator getMigrator(String json, Context context) throws MigrationException {
            Set<String> analysisProfileLanguages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(json);
            ArrayList<ConfigurationOptionMigrationBase> replacements = new ArrayList<ConfigurationOptionMigrationBase>();
            if (analysisProfileLanguages.contains("ABAP")) {
                replacements.add(new ConfigurationOptionReplacement("cqse-multiple-statements-per-line", "Formatting", "cqse-abap-multiple-statements-per-line", "Formatting", false));
            } else {
                replacements.add(new ConfigurationOptionDeletion("Ignored ABAP statements", "Formatting"));
            }
            List<String> nonAbapLanguagesOfMultipleStatementsInLineCheck = Arrays.asList("JAVA", "ADA", "CS", "C", "CPP", "PLSQL", "JAVASCRIPT", "PYTHON", "DELPHI", "MATLAB", "FORTRAN", "IEC61131", "XTEND", "OCAML", "TSQL", "GROOVY", "PHP", "SQLSCRIPT", "OPEN_CL", "RUST", "VB", "SWIFT", "GOSU", "OSCRIPT", "COBOL", "KOTLIN", "LINE", "OBJECTIVE_C");
            boolean checkAddedByOtherLanguage = nonAbapLanguagesOfMultipleStatementsInLineCheck.stream().anyMatch(analysisProfileLanguages::contains);
            if (!checkAddedByOtherLanguage) {
                replacements.add(new ConfigurationOptionDeletion("cqse-multiple-statements-per-line", "Formatting"));
            }
            if (!replacements.isEmpty()) {
                return new JsonMigrator(replacements);
            }
            return JsonMigrator.NO_OP_MIGRATOR;
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_135{

        public @NonNull IJsonMigrator getMigrator(String json, Context context) throws MigrationException {
            String languageProperty = "languages";
            ObjectNode analysisProfile = AnalysisProfileMigrationUtils.getAnalysisProfileObjectNode(json);
            Set<String> properties = AnalysisProfileMigrationUtils.getPropertiesFromProfile(analysisProfile, languageProperty);
            if (properties.contains("CPP")) {
                15.addELanguageC(analysisProfile, properties, languageProperty);
            }
            return new JsonMigratorWithKnownResult((JsonNode)analysisProfile);
        }

        private static void addELanguageC(ObjectNode analysisProfile, Set<String> properties, String analysisProfileProperty) {
            properties.add("C");
            JsonNodeFactory factory = JsonNodeFactory.instance;
            ArrayNode arrayNode = factory.arrayNode();
            for (String value : properties) {
                arrayNode.add(value);
            }
            analysisProfile.set(analysisProfileProperty, (JsonNode)arrayNode);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_136{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionReplacement("Custom Exception Definition.", "Exception Handling", "Custom Exception Definition", "Exception Handling")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_137{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionDeletion("Include method hierarchies", "Bad Practice")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_138{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            ArrayList<ConfigurationOptionDeletion> migrations = new ArrayList<ConfigurationOptionDeletion>();
            migrations.add(new ConfigurationOptionDeletion("bugprone-not-null-terminated-result:   want to use safe functions", "Possible Bugs"));
            migrations.add(new ConfigurationOptionDeletion("bugprone-string-constructor:   large length threshold", "Error-prone Practices"));
            migrations.add(new ConfigurationOptionDeletion("bugprone-string-constructor:   warn on large length", "Error-prone Practices"));
            migrations.add(new ConfigurationOptionDeletion("bugprone-suspicious-missing-comma:   max concatenated tokens", "Error-prone Practices"));
            migrations.add(new ConfigurationOptionDeletion("bugprone-suspicious-missing-comma:   ratio threshold", "Error-prone Practices"));
            migrations.add(new ConfigurationOptionDeletion("bugprone-suspicious-missing-comma:   size threshold", "Error-prone Practices"));
            migrations.add(new ConfigurationOptionDeletion("readability-implicit-bool-conversion:   allow integer conditions", "Bad Practice"));
            migrations.add(new ConfigurationOptionDeletion("readability-implicit-bool-conversion:   allow pointer conditions", "Bad Practice"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_139{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            List<ConfigurationOptionReplacement> migrations = List.of(new ConfigurationOptionReplacement("Allowed Block Types on Top Level (Integration Model)", "Bad Practice", "Allowed Block Types on All Levels Below Root (Integration Model)", "Bad Practice"), new ConfigurationOptionReplacement("Allowed Block Types on Top Level (Functional Model)", "Bad Practice", "Allowed Block Types on All Levels Below Root (Functional Model)", "Bad Practice"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_140{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            List<ConfigurationOptionReplacement> migrations = List.of(new ConfigurationOptionReplacement("Regex for C++ constants", "Naming", "Regex for C++ global constants", "Naming"), new ConfigurationOptionReplacement("Regex for C constants", "Naming", "Regex for C global constants", "Naming"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_141{

        public @NonNull JsonMigrator getMigrator(String xmlOrJson, Context context) throws MigrationException {
            ArrayList<ConfigurationOptionDeletion> migrations = new ArrayList<ConfigurationOptionDeletion>();
            Set<String> languages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(xmlOrJson);
            if (languages.contains("CPP") && !languages.contains("C")) {
                migrations.add(new ConfigurationOptionDeletion("cqse-c-method-parameter-count", "Excessive Parameters"));
                migrations.add(new ConfigurationOptionDeletion("Methods should not have too many parameters (C): max. parameters", "Excessive Parameters"));
                migrations.add(new ConfigurationOptionDeletion("cqse-flexible-array-member", "Error-prone Practices"));
                migrations.add(new ConfigurationOptionDeletion("cqse-types-shall-be-explicitly-specified", "Bad Practice"));
            } else if (languages.contains("C") && !languages.contains("CPP")) {
                migrations.add(new ConfigurationOptionDeletion("cqse-cpp-forbidden-types", "Discouraged APIs"));
                migrations.add(new ConfigurationOptionDeletion("Forbidden types", "Discouraged APIs"));
                migrations.add(new ConfigurationOptionDeletion("cqse-method-definition-in-header", "Design Flaws"));
            }
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_142{

        public @NonNull JsonMigrator getMigrator(String xmlOrJson, Context context) {
            List<IJsonMigration> migrations = List.of(new ConfigurationOptionReplacement("A possible null value may not be passed to a target marked with the [DisallowNull] attribute (CS8607)", "Compiler warning Level 1 (C# Compiler)", "A possible null value may not be used for a type marked with [NotNull] or [DisallowNull] (CS8607)", "Compiler warning Level 1 (C# Compiler)"), new ConfigurationOptionReplacement("Expected disable, restore or enable after #pragma warning (CS1634)", "Compiler warning Level 1 (C# Compiler)", "Expected 'disable' or 'restore' after #pragma warning (CS1634)", "Compiler warning Level 1 (C# Compiler)"), new ConfigurationOptionReplacement("Non-nullable field is uninitialized (CS8618)", "Compiler warning Level 1 (C# Compiler)", "Non-nullable field must contain a non-null value when exiting constructor. Consider declaring as nullable (CS8618)", "Compiler warning Level 1 (C# Compiler)"), new ConfigurationOptionReplacement("Nullability of reference types in return type doesn't match the target delegate (CS8621)", "Compiler warning Level 1 (C# Compiler)", "Nullability of reference types in return type doesn't match the target delegate (possibly because of nullability attributes) (CS8621)", "Compiler warning Level 1 (C# Compiler)"), new ConfigurationOptionReplacement("Nullability of reference types in type of parameter doesn't match the target delegate (CS8622)", "Compiler warning Level 1 (C# Compiler)", "Nullability of reference types in type of parameter doesn't match the target delegate (possibly because of nullability attributes) (CS8622)", "Compiler warning Level 1 (C# Compiler)"), new ConfigurationOptionReplacement("The annotation for nullable reference types should only be used in code within a '#nullable' context (CS8632)", "Compiler warning Level 1 (C# Compiler)", "The annotation for nullable reference types should only be used in code within a '#nullable' annotations context (CS8632)", "Compiler warning Level 1 (C# Compiler)"), new ConfigurationOptionReplacement("The switch expression does not handle all possible inputs (it is not exhaustive) (CS8509)", "Compiler warning Level 1 (C# Compiler)", "The switch expression does not handle all possible values of its input type (it is not exhaustive) (CS8509)", "Compiler warning Level 1 (C# Compiler)"), new ConfigurationOptionReplacement("The entry point of the program is global script code; ignoring entry point (CS7022)", "Compiler warning Level 2 (C# Compiler)", "The entry point of the program is global code; ignoring entry point (CS7022)", "Compiler warning Level 2 (C# Compiler)"), new ConfigurationOptionReplacement("The result of the expression is always the same since a value of this type is never equal to 'null' (CS8073)", "Compiler warning Level 2 (C# Compiler)", "The result of the expression is always the same since a value of this type is never equal to 'null' (CS8073)", "Compiler warning Level 5 (C# Compiler)"), new ConfigurationOptionReplacement("Type does not implement the collection pattern; member is either static or not public (CS0279)", "Compiler warning Level 2 (C# Compiler)", "Type does not implement the collection pattern; member is is not a public instance or extension method (CS0279)", "Compiler warning Level 2 (C# Compiler)"), new ConfigurationOptionReplacement("New protected member declared in sealed class (CS0628)", "Compiler warning Level 4 (C# Compiler)", "New protected member declared in sealed type (CS0628)", "Compiler warning Level 4 (C# Compiler)"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_143{

        public @NonNull IJsonMigrator getMigrator(@Language(value="JSON") String json, Context context) throws MigrationException {
            try {
                ObjectNode profile = (ObjectNode)JsonUtils.deserializeFromJson((String)json, ObjectNode.class);
                JsonNode toolNode = profile.get("tools");
                Iterator iterator = toolNode.elements();
                while (iterator.hasNext()) {
                    JsonNode currentNode = (JsonNode)iterator.next();
                    if (!currentNode.textValue().equals("PROFILER_COVERAGE")) continue;
                    iterator.remove();
                    return new JsonMigratorWithKnownResult((JsonNode)profile);
                }
                return JsonMigrator.NO_OP_MIGRATOR;
            }
            catch (JsonSerializationException e) {
                throw new MigrationException((Throwable)e);
            }
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_144{

        public @NonNull JsonMigrator getMigrator(@Language(value="JSON") String json, Context context) throws MigrationException {
            ArrayList<Object> migrations = new ArrayList<Object>();
            migrations.add(new ConfigurationOptionDeletion("check_no_handler_pragma", "Bad Practice"));
            migrations.add(new ConfigurationOptionDeletion("form_no_dash", "Naming"));
            migrations.add(new ConfigurationOptionDeletion("local_testclass_location", "Test Smells"));
            migrations.add(new ConfigurationOptionDeletion("type_begin_single_include", "Design Flaws"));
            try {
                ObjectNode analysisProfile = (ObjectNode)JsonUtils.deserializeFromJson((String)json, ObjectNode.class);
                ObjectNode options = (ObjectNode)analysisProfile.get("options");
                if (options.has("ABAPLint config file") && !options.get("ABAPLint config file").asText().isEmpty()) {
                    LogManager.getLogger().warn(MigrationVersion144ABAPLintConfigFileUtils.getWarningMessage(analysisProfile.get("name").asText()));
                }
            }
            catch (JsonSerializationException e) {
                throw new MigrationException((Throwable)e);
            }
            migrations.add(new GlobalOptionDeletion("ABAPLint config file"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_145{

        public @NonNull IJsonMigrator getMigrator(@Language(value="JSON") String json, Context context) throws MigrationException {
            try {
                ObjectNode profile = (ObjectNode)JsonUtils.deserializeFromJson((String)json, ObjectNode.class);
                JsonNode toolNode = profile.get("tools");
                Iterator iterator = toolNode.elements();
                while (iterator.hasNext()) {
                    JsonNode currentNode = (JsonNode)iterator.next();
                    if (!currentNode.textValue().equals("PROFILER_COVERAGE")) continue;
                    iterator.remove();
                    return new JsonMigratorWithKnownResult((JsonNode)profile);
                }
                return JsonMigrator.NO_OP_MIGRATOR;
            }
            catch (JsonSerializationException e) {
                throw new MigrationException((Throwable)e);
            }
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_146{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            ArrayList<ConfigurationOptionDeletion> migrations = new ArrayList<ConfigurationOptionDeletion>();
            migrations.add(new ConfigurationOptionDeletion("S1128", "Unused Code"));
            migrations.add(new ConfigurationOptionDeletion("S3990", "Compatibility"));
            migrations.add(new ConfigurationOptionDeletion("S3992", "Bad Practice"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_147{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new GlobalOptionReplacement("ABAPLint default language", "abaplint default language")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_148{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionDeletion("java:S1228", "Comment Completeness")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_150{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            ArrayList<ConfigurationOptionDeletion> migrations = new ArrayList<ConfigurationOptionDeletion>();
            migrations.add(new ConfigurationOptionDeletion("@typescript-eslint/no-unused-vars-experimental", "Error-prone Practices"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_151{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new GlobalBooleanOptionAddition("Enable Code Ownership Analysis", true)});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_152{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            ArrayList<ConfigurationOptionReplacement> migrations = new ArrayList<ConfigurationOptionReplacement>();
            migrations.add(new ConfigurationOptionReplacement("cqse-no-data-declaration-in-functional-code-block", "Bad Practice", "cqse-no-data-declaration-in-statement-block", "Bad Practice"));
            migrations.add(new ConfigurationOptionReplacement("No data declarations in functional code blocks", "VW ABAP Coding Guideline", "No data declarations in statement blocks", "VW ABAP Coding Guideline"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_153{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            ArrayList<ConfigurationOptionDeletion> migrations = new ArrayList<ConfigurationOptionDeletion>();
            migrations.add(new ConfigurationOptionDeletion("SA1215", "Member Ordering"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_154{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            List<ConfigurationOptionReplacement> migrations = List.of(new ConfigurationOptionReplacement("C/C++ Unwanted Methods", "Unwanted function calls", "Discouraged APIs"), new ConfigurationOptionReplacement("cqse-cpp-unwanted-method-calls", "cqse-clike-unwanted-function-calls", "Discouraged APIs"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_155{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            List<ConfigurationOptionReplacement> migrations = List.of(new ConfigurationOptionReplacement("identifier_name.validates_start_lowercase", "identifier_name.validates_start_with_lowercase", "Naming"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_156{

        public @NonNull JsonMigrator getMigrator(String json, Context context) throws MigrationException {
            Set<String> languages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(json);
            ArrayList<ConfigurationOptionDeletion> migrations = new ArrayList<ConfigurationOptionDeletion>();
            if (!CommentAnalysisConfiguration.isCommentClassificationSupportedFromStringSet(languages)) {
                migrations.add(new ConfigurationOptionDeletion("Commented-out code", "Bad Practice"));
            }
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_157{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(List.of(new ConfigurationOptionReplacement("Name from java.lang used: Allow names from sub-packages", "Type uses name from java.lang: Allow names from sub-packages", "Bad Practice")));
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_158{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            ArrayList<ConfigurationOptionMigrationBase> migrations = new ArrayList<ConfigurationOptionMigrationBase>();
            migrations.addAll(MigrationVersion158VariousUpdates.MIGRATION_158_INTERNAL_MIGRATIONS);
            migrations.addAll(MigrationVersion158VariousUpdates.MIGRATION_158_SONARLINT_MIGRATIONS);
            migrations.addAll(MigrationVersion158VariousUpdates.MIGRATION_158_SONARLINT_CS_MIGRATIONS);
            migrations.addAll(MigrationVersion158VariousUpdates.MIGRATION_158_CLANG_TIDY_MIGRATIONS);
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_159{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            ArrayList<ConfigurationOptionMigrationBase> migrations = new ArrayList<ConfigurationOptionMigrationBase>(MigrationVersion159ESLintUpdates.MIGRATION_159_CHECK_MIGRATIONS);
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_160{

        public @NonNull IJsonMigrator getMigrator(String json, Context context) throws MigrationException {
            HashSet<String> toolsInUse = new HashSet<String>(AnalysisProfileMigrationUtils.getToolsInUseJson(json));
            if (!toolsInUse.contains("RAEX")) {
                return JsonMigrator.NO_OP_MIGRATOR;
            }
            toolsInUse.add(EAnalysisTool.SECURITY_CODE_SCAN.name());
            ObjectNode analysisProfileAsJsonObject = AnalysisProfileMigrationUtils.getAnalysisProfileObjectNode(json);
            analysisProfileAsJsonObject.set("tools", new ObjectMapper().valueToTree(toolsInUse));
            json = JsonUtils.serializeToJSON((Object)analysisProfileAsJsonObject);
            ArrayList<ConfigurationOptionReplacement> migrations = new ArrayList<ConfigurationOptionReplacement>(MigrationVersion160SecurityCodeScan.MIGRATION_160_CHECK_MIGRATIONS);
            return new JsonMigratorWithKnownResult(new JsonMigrator(migrations).migrate(json));
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_161{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return JsonMigrator.NO_OP_MIGRATOR;
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_162{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            ArrayList<ConfigurationOptionReplacement> migrations = new ArrayList<ConfigurationOptionReplacement>();
            migrations.add(new ConfigurationOptionReplacement("line_length.ignores urls", "line_length.ignores_urls", "Bad Practice"));
            migrations.add(new ConfigurationOptionReplacement("line_length.ignores function declarations", "line_length.ignores_function_declarations", "Bad Practice"));
            migrations.add(new ConfigurationOptionReplacement("line_length.ignores comments", "line_length.ignores_comments", "Bad Practice"));
            migrations.add(new ConfigurationOptionReplacement("line_length.ignores interpolated strings", "line_length.ignores_interpolated_strings", "Bad Practice"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_163{

        public @NonNull IJsonMigrator getMigrator(String json, Context context) throws MigrationException {
            HashSet<String> toolsInUse = new HashSet<String>(AnalysisProfileMigrationUtils.getToolsInUseJson(json));
            if (!toolsInUse.contains("RAEX")) {
                return JsonMigrator.NO_OP_MIGRATOR;
            }
            ObjectNode analysisProfileAsJsonObject = AnalysisProfileMigrationUtils.getAnalysisProfileObjectNode(json);
            ObjectNode options = (ObjectNode)analysisProfileAsJsonObject.get("options");
            options.remove("RA\u00cbX executable path");
            analysisProfileAsJsonObject.set("options", (JsonNode)options);
            ArrayList deletions = new ArrayList();
            for (Map.Entry<String, ObjectNode> groupEntry : AnalysisProfileMigrationUtils.getAnalysisGroupsByName(analysisProfileAsJsonObject).entrySet()) {
                JsonNode optionsInGroup = groupEntry.getValue().get("options");
                if (optionsInGroup == null) continue;
                String groupName = groupEntry.getKey();
                MigrationVersion163RemoveDeletedSecurityCodeScanChecks.SECURITY_CODE_SCAN_CHECKS_TO_DELETE.forEach(checkId -> {
                    if (optionsInGroup.has(checkId)) {
                        deletions.add(new ConfigurationOptionDeletion((String)checkId, groupName));
                    }
                });
            }
            return new JsonMigratorWithKnownResult(new JsonMigrator(deletions).migrate(JsonUtils.serializeToJSON((Object)analysisProfileAsJsonObject)));
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_164{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            ArrayList<ConfigurationOptionReplacement> migrations = new ArrayList<ConfigurationOptionReplacement>();
            migrations.add(new ConfigurationOptionReplacement("Column Threshold", "SQL SELECT INTO unique object count - Object Threshold", "Bad Practice"));
            migrations.add(new ConfigurationOptionReplacement("Column Threshold", "SQL SELECT INTO unique object count - Object Threshold", "IFS Checks"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_165{

        public @NonNull JsonMigrator getMigrator(String json, Context context) throws MigrationException {
            Set<String> languages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(json);
            if (!languages.contains(ELanguage.ESQL.name()) || languages.contains(ELanguage.PLSQL.name())) {
                return JsonMigrator.NO_OP_MIGRATOR;
            }
            return new JsonMigrator(List.of(new ConfigurationOptionDeletion("cqse-runtime-literal-concatenation", "Runtime Performance")));
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_166{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(List.of(new ConfigurationOptionDeletion("Ignore partial classes", "Unused Code")));
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_167{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(List.of(new ConfigurationOptionDeletion("clang-analyzer-apiModeling.StdCLibraryFunctions", "API Misuse")));
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_168{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(List.of(new ConfigurationOptionReplacement("Max (kotlin:S104)", "max (kotlin:S104)", "File Length")));
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_169{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            List<ConfigurationOptionReplacement> migrations = List.of(new ConfigurationOptionReplacement("Allow only simple ternary operators", "Allow non-nested simple ternary operators", "Bad Practice"), new ConfigurationOptionReplacement("Allow only single-line ternary expressions", "Allow single-line non-nested ternary expressions", "Bad Practice"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_170{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(MigrationVersion170ExceptionCatching.MIGRATIONS);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_171{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionDeletion("Unused function", "Unused Code"), new ConfigurationOptionDeletion("Unused struct member", "Unused Code")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_172{

        public @NonNull IJsonMigrator getMigrator(String json, Context context) throws MigrationException {
            String resultJson = AnalysisProfileMigrationUtils.mergeDuplicateCodeClonesGroups(json);
            if (resultJson.equals(json)) {
                return JsonMigrator.NO_OP_MIGRATOR;
            }
            return new JsonMigratorWithKnownResult(resultJson);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_173{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionReplacement("Ignore missing default cases of switch statements", "Ignore missing default cases in switch statements over enums", "Error-prone Practices")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_174{

        public @NonNull IJsonMigrator getMigrator(String json, Context context) throws MigrationException {
            String resultJson = V174CrossComponentCloneMigration.migrate(json);
            if (resultJson.equals(json)) {
                return JsonMigrator.NO_OP_MIGRATOR;
            }
            return new JsonMigratorWithKnownResult(resultJson);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_175{

        public @NonNull IJsonMigrator getMigrator(String json, Context context) throws MigrationException {
            ObjectNode profile = AnalysisProfileMigrationUtils.getAnalysisProfileObjectNode(json);
            List<ObjectNode> analysisGroups = AnalysisProfileMigrationUtils.getAnalysisGroups(profile);
            for (ObjectNode analysisGroup : analysisGroups) {
                LinkedHashMap<String, String> options = AnalysisProfileMigrationUtils.getOptionsInUse(analysisGroup);
                options.forEach((option, optionValue) -> {
                    boolean optionIsFindingEnablement = Arrays.stream(EFindingEnablement.values()).anyMatch(enablement -> enablement.name().equalsIgnoreCase((String)optionValue));
                    if (optionIsFindingEnablement) {
                        options.put((String)option, optionValue.toUpperCase());
                    } else {
                        options.put((String)option, (String)optionValue);
                    }
                });
                analysisGroup.set("options", JsonUtils.getObjectMapper().valueToTree(options));
            }
            return new JsonMigratorWithKnownResult((JsonNode)profile);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_176{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            ArrayList<ConfigurationOptionMigrationBase> migrations = new ArrayList<ConfigurationOptionMigrationBase>();
            migrations.add(new ConfigurationOptionDeletion("custom_rules.user-defined", "Bad Practice"));
            migrations.add(new ConfigurationOptionDeletion("custom_rules", "Bad Practice"));
            migrations.add(new ConfigurationOptionDeletion("file_header.forbidden_pattern", "Bad Practice"));
            migrations.add(new ConfigurationOptionDeletion("file_header.forbidden_string", "Bad Practice"));
            migrations.add(new ConfigurationOptionDeletion("file_header.required_pattern", "Bad Practice"));
            migrations.add(new ConfigurationOptionDeletion("file_header.required_string", "Bad Practice"));
            migrations.add(new ConfigurationOptionDeletion("number_separator.minimum_fraction_length", "Bad Practice"));
            migrations.add(new ConfigurationOptionDeletion("inclusive_language.additional_terms", "Naming"));
            migrations.add(new ConfigurationOptionDeletion("inclusive_language.override_terms", "Naming"));
            migrations.add(new ConfigurationOptionDeletion("inclusive_language.override_allowed_terms", "Naming"));
            migrations.add(new ConfigurationOptionDeletion("expiring_todo.approaching_expiry_severity", "Task Tags"));
            migrations.add(new ConfigurationOptionDeletion("expiring_todo.reached_or_passed_expiry_severity", "Task Tags"));
            migrations.add(new ConfigurationOptionDeletion("private_unit_test.error", "Test Smells"));
            migrations.add(new ConfigurationOptionDeletion("private_unit_test.warning", "Test Smells"));
            migrations.add(new ConfigurationOptionReplacement("multiline_parameters.allowsSingleLine", "multiline_parameters.allows_single_line", "Formatting"));
            migrations.add(new ConfigurationOptionReplacement("opening_brace.allowMultilineFunc", "opening_brace.allow_multiline_func", "Formatting"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_177{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            ConfigurationOptionDeletion deletion = new ConfigurationOptionDeletion("@typescript-eslint/no-redundant-type-constituents", "Possible Bugs");
            List<ConfigurationOptionDeletion> migrations = List.of(deletion);
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_178{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionReplacement("Cross Component Clones: Architecture filename", "Component-based Clone Analysis: Architecture filename", "Code Clones")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_179{

        public @NonNull IJsonMigrator getMigrator(String json, Context context) throws MigrationException {
            String resultJson = ConditionalStatementsSwiftMigrator.migrate(json);
            if (resultJson.equals(json)) {
                return JsonMigrator.NO_OP_MIGRATOR;
            }
            return new JsonMigratorWithKnownResult(resultJson);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_180{

        public @NonNull IJsonMigrator getMigrator(String json, Context context) throws MigrationException {
            String optionName;
            ObjectNode profile = AnalysisProfileMigrationUtils.getAnalysisProfileObjectNode(json);
            LinkedHashMap<String, String> options = AnalysisProfileMigrationUtils.getOptionsInUse(profile);
            String testIdentificationPatterns = (String)options.get(optionName = "Test identification patterns");
            if (testIdentificationPatterns == null) {
                return JsonMigrator.NO_OP_MIGRATOR;
            }
            try {
                PairList patterns = StringValuePairListOptionDescriptor.parseFromString((String)testIdentificationPatterns);
                patterns = (PairList)patterns.stream().filter(pattern -> 59.isValidTestExtractionPattern((String)pattern.getSecond())).collect(PairList.toPairList());
                options.put(optionName, StringValuePairListOptionDescriptor.getValueAsString((Object)patterns));
            }
            catch (ProjectConfigurationException e) {
                options.put(optionName, "");
            }
            profile.set("options", JsonUtils.getObjectMapper().valueToTree(options));
            return new JsonMigratorWithKnownResult((JsonNode)profile);
        }

        private static boolean isValidTestExtractionPattern(String pattern) {
            try {
                Pattern compiledPattern = Pattern.compile(pattern);
                Matcher matcher = compiledPattern.matcher("");
                if (matcher.groupCount() < 1) {
                    return false;
                }
            }
            catch (PatternSyntaxException e) {
                return false;
            }
            return true;
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_181{

        public @NonNull IJsonMigrator getMigrator(String json, Context context) throws MigrationException {
            Set<String> analysisProfileLanguages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(json);
            Set<String> naturalLanguages = Set.of("NL_TESTS", "NL_ISSUES", "NL_REQUIREMENTS");
            for (String analysisProfileLanguage : analysisProfileLanguages) {
                if (naturalLanguages.contains(analysisProfileLanguage)) continue;
                return JsonMigrator.NO_OP_MIGRATOR;
            }
            ObjectNode profileNode = AnalysisProfileMigrationUtils.getAnalysisProfileObjectNode(json);
            ArrayNode qualityIndicators = AnalysisProfileMigrationUtils.getQualityIndicators(profileNode);
            if (qualityIndicators == null) {
                return JsonMigrator.NO_OP_MIGRATOR;
            }
            for (JsonNode indicator : qualityIndicators) {
                if (!indicator.has("options")) continue;
                ObjectNode options = (ObjectNode)CCSMAssert.checkedCast((Object)indicator.get("options"), ObjectNode.class);
                options.remove("Findings Density");
                options.remove("Findings Density (Red)");
                options.remove("Findings Density (Yellow)");
            }
            return new JsonMigratorWithKnownResult((JsonNode)profileNode);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_182{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionReplacement("Minimal clone length", "Minimal code clone length", "Code Clones"), new ConfigurationOptionReplacement("Allow gaps", "Allow code gaps", "Code Clones"), new ConfigurationOptionReplacement("Clone instance limit", "Code clone instance limit", "Code Clones"), new ConfigurationOptionReplacement("Minimal clone length", "Minimal spec item clone length", "Specification Clones"), new ConfigurationOptionReplacement("Allow gaps", "Allow spec item gaps", "Specification Clones"), new ConfigurationOptionReplacement("Clone instance limit", "Spec item clone instance limit", "Specification Clones"), new ConfigurationOptionReplacement("Exclude Path Patterns", "Exclude Spec Item Patterns", "Specification Clones")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_183{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionDeletion("Buffer is being written before its old content has been used", "Bad Practice"), new ConfigurationOptionDeletion("Address of an auto-variable is returned", "Error-prone Practices"), new ConfigurationOptionDeletion("Possible leak in public functin", "Memory Leaks"), new ConfigurationOptionDeletion("Address of function parameter returned", "Possible Bugs"), new ConfigurationOptionDeletion("Deallocating a deallocated pointer", "Possible Bugs"), new ConfigurationOptionDeletion("Pointer to local array variable returned", "Possible Bugs"), new ConfigurationOptionDeletion("Reading from an empty container", "Possible Bugs"), new ConfigurationOptionDeletion("The allocated size is not a multiple of the underlying type's size", "Possible Bugs"), new ConfigurationOptionDeletion("Using an uninitialized string", "Possible Bugs"), new ConfigurationOptionDeletion("Using an uninitialized variable", "Possible Bugs"), new ConfigurationOptionDeletion("Wrong pipe parameter size", "Possible Bugs")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_184{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new AnalysisProfileVersion184MagicNumberUsageOptions()});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_185{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(MigrateVersion185CppcheckUseCheckID.getMigrations());
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_186{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionReplacement("Clones", "spec-item-clones", "Specification Clones")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_187{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionReplacement("Control flow depending on system variable (SY-...) - relevant system fields", "Control flow depending on system variables - relevant system variables", "Usage of System Fields"), new ConfigurationOptionReplacement("Usage of system variables (SY-...) - relevant system fields", "Usage of system variables - relevant system variables", "Usage of System Fields"), new ConfigurationOptionReplacement("Usage of system variables (SY-...) - ignore control statements", "Usage of system variables - ignore control statements", "Usage of System Fields"), new ConfigurationOptionReplacement("Hard-coded user name - Ignore in context of SY-UNAME", "Hard-coded user name - Ignore in context of SY-UNAME or ABAP context info class", "Hard-Coded Credentials")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_188{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            List<ConfigurationOptionDeletion> migrations = List.of(new ConfigurationOptionDeletion("S4834", "Critical and Suspicious Statements"), new ConfigurationOptionDeletion("S4823", "Critical and Suspicious Statements"), new ConfigurationOptionDeletion("S4829", "Critical and Suspicious Statements"), new ConfigurationOptionDeletion("S4818", "Critical and Suspicious Statements"), new ConfigurationOptionDeletion("S2255", "Critical and Suspicious Statements"), new ConfigurationOptionDeletion("S4784", "Critical and Suspicious Statements"), new ConfigurationOptionDeletion("S4787", "Critical and Suspicious Statements"), new ConfigurationOptionDeletion("S4564", "Insufficient Authority Checks"), new ConfigurationOptionDeletion("S2228", "Logging"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_189{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new GlobalOptionDeletion("Disable clone-based move tracking")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_190{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionDeletion("boostForeachError", "Possible Bugs")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_191{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionReplacement("premium-ignoredReturnValue", "Error-prone Practice", "premium-ignoredReturnValue", "Error-prone Practices"), new ConfigurationOptionReplacement("premium-misra-cpp-2023-5.13.7", "Possible Bugs-cpp", "premium-misra-cpp-2023-5.13.7", "Possible Bugs"), new ConfigurationOptionReplacement("premium-misra-c-2023-12.6", "Error-prone Practices Bugs", "premium-misra-c-2023-12.6", "Error-prone Practices"), new ConfigurationOptionReplacement("premium-cert-dcl40-c", "Eror-prone Practices", "premium-cert-dcl40-c", "Error-prone Practices")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_192{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            List<ConfigurationOptionDeletion> migrations = List.of(new ConfigurationOptionDeletion("Disable browser-based rating", "Code review"), new ConfigurationOptionDeletion("Read in-file ratings", "Code review"));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_193{

        public @NonNull JsonMigrator getMigrator(String xmlOrJson, Context context) {
            String analysisGroup = "Naming";
            List<ConfigurationOptionReplacement> migrations = List.of(new ConfigurationOptionReplacement("JavaScript naming conventions", "JavaScript/TypeScript naming conventions", analysisGroup), new ConfigurationOptionReplacement("Regex for JavaScript attributes", "Regex for JavaScript/TypeScript attributes", analysisGroup), new ConfigurationOptionReplacement("Regex for JavaScript classes", "Regex for JavaScript/TypeScript classes", analysisGroup), new ConfigurationOptionReplacement("Regex for JavaScript constants", "Regex for JavaScript/TypeScript constants", analysisGroup), new ConfigurationOptionReplacement("Regex for JavaScript function parameters", "Regex for JavaScript/TypeScript function parameters", analysisGroup), new ConfigurationOptionReplacement("Regex for JavaScript functional components", "Regex for JavaScript/TypeScript functional components", analysisGroup), new ConfigurationOptionReplacement("Regex for JavaScript functions", "Regex for JavaScript/TypeScript functions", analysisGroup), new ConfigurationOptionReplacement("Regex for JavaScript global variables", "Regex for JavaScript/TypeScript global variables", analysisGroup), new ConfigurationOptionReplacement("Regex for JavaScript local variables", "Regex for JavaScript/TypeScript local variables", analysisGroup), new ConfigurationOptionReplacement("Regex for JavaScript namespaces", "Regex for JavaScript/TypeScript namespaces", analysisGroup));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_194{

        public @NonNull JsonMigrator getMigrator(String xmlOrJson, Context context) throws MigrationException {
            Set<String> languages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(xmlOrJson);
            if (languages.contains("ABAP")) {
                return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionReplacement("strict_sql", "Possible Bugs", "strict_sql", "Bad Practice", true)});
            }
            return JsonMigrator.NO_OP_MIGRATOR;
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_195{

        public @NonNull JsonMigrator getMigrator(String json, Context context) throws MigrationException {
            return new JsonMigrator(MigrateVersion195CppcheckSeparateChecks.getMigrations(AnalysisProfileMigrationUtils.getLanguagesInUseJson(json)));
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_196{

        public @NonNull JsonMigrator getMigrator(String xmlOrJson, Context context) {
            return new JsonMigrator(V195SonarLintUpdateMigration.MIGRATIONS);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_197{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new GlobalOptionReplacement("jQAssistant Project Findings File", "jQAssistant Project Findings Files")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_198{

        public @NonNull JsonMigrator getMigrator(String json, Context context) throws MigrationException {
            Set<String> languages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(json);
            ArrayList<ConfigurationOptionDeletion> migrations = new ArrayList<ConfigurationOptionDeletion>();
            if (!languages.contains("CS") && !languages.contains("JAVA")) {
                migrations.add(new ConfigurationOptionDeletion("Custom assert methods", "Possible Bugs"));
                migrations.add(new ConfigurationOptionDeletion("Token stream transformations", "Possible Bugs"));
            }
            if (!languages.contains("JAVA")) {
                migrations.add(new ConfigurationOptionDeletion("Java: JUnit asserts", "Possible Bugs"));
                migrations.add(new ConfigurationOptionDeletion("Java: JUnit version", "Possible Bugs"));
            }
            if (!languages.contains("CS")) {
                migrations.add(new ConfigurationOptionDeletion("C#: NUnit/xUnit.NET/MSTest asserts", "Possible Bugs"));
            }
            if (!languages.contains("C") && !languages.contains("CPP")) {
                migrations.add(new ConfigurationOptionDeletion("Ignore null-pointer dereference for pointers assigned by malloc", "Possible Bugs"));
            }
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_199{

        public @NonNull JsonMigrator getMigrator(String xmlOrJson, Context context) throws MigrationException {
            final Set<String> languages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(xmlOrJson);
            if (!languages.contains("CPP")) {
                return JsonMigrator.NO_OP_MIGRATOR;
            }
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionMigrationBase(this, "Enable Microsoft-C++/Cli support", "group is irrelevant here"){

                @Override
                protected void doMigrateJson(ObjectNode analysisProfile) {
                    if (this.options.get("Enable Microsoft-C++/Cli support").textValue().equals("true")) {
                        languages.remove("CPP");
                        languages.add("MS C++/CLI");
                    }
                    this.options.remove("Enable Microsoft-C++/Cli support");
                }
            }});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_200{

        public @NonNull IJsonMigrator getMigrator(String xmlOrJson, Context context) throws MigrationException {
            try {
                return new JsonMigrator(V200ExternalFindingTypeIds.getMigrations(context.globalStorageSystem()));
            }
            catch (StorageException e) {
                throw new MigrationException((Throwable)e);
            }
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_201{

        public @NonNull JsonMigrator getMigrator(String xmlOrJson, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new GlobalBooleanOptionAddition("Enable Test Gap Analysis, Pareto Optimization and Test Impact Analysis", true)});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_202{

        public @NonNull JsonMigrator getMigrator(String xmlOrJson, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionDeletion("Clone Coverage", "Specification Clones")});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_203{

        public @NonNull JsonMigrator getMigrator(String xmlOrJson, Context context) {
            return new JsonMigrator(new IJsonMigration[]{new ConfigurationOptionReplacement("premium-misra-cpp-2023-19.3.1", "Possible Bugs", "premium-misra-cpp-2023-19.3.1", "Bad Practice", true)});
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_204{

        public @NonNull JsonMigrator getMigrator(String xmlOrJson, Context context) throws MigrationException {
            Set<String> languages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(xmlOrJson);
            if (languages.contains("C")) {
                return JsonMigrator.NO_OP_MIGRATOR;
            }
            if (languages.contains("CPP") || languages.contains("OBJECTIVE_CPP") || languages.contains("CPP_MS_CLI") || languages.contains("OPEN_CL")) {
                return new JsonMigrator(List.of(new ConfigurationOptionDeletion("Excluded function names", "Bad Practice"), new ConfigurationOptionDeletion("cqse-compatible-declaration-shall-be-visible", "Bad Practice")));
            }
            return JsonMigrator.NO_OP_MIGRATOR;
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_205{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            ArrayList<ConfigurationOptionMigrationBase> migrations = new ArrayList<ConfigurationOptionMigrationBase>(MigrationVersion205RemoveTestSmellGroup.MIGRATION_205_CHECK_MIGRATIONS);
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_206{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            String criticalStatements = "Critical and Suspicious Statements";
            List<ConfigurationOptionReplacement> migrations = List.of(new ConfigurationOptionDeletion("rules_lgpl_javascript_memory_rule-buffer-noassert", criticalStatements), new ConfigurationOptionReplacement("javascript_buf_rule-buffer-noassert", criticalStatements, "javascript_buf_rule-buffer-noassert-read", criticalStatements, false), new ConfigurationOptionReplacement("javascript_buf_rule-buffer-noassert", criticalStatements, "javascript_buf_rule-buffer-noassert-write", criticalStatements, true));
            return new JsonMigrator(migrations);
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_207{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(List.of(new ConfigurationOptionReplacement("cqse-avoid-insecure-hash-algorithms", "Insufficient Authority Checks", "cqse-avoid-insecure-hash-algorithms", "Weak Cryptography")));
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_208{

        public @NonNull JsonMigrator getMigrator(String json, Context context) {
            return new JsonMigrator(List.of(new ConfigurationOptionReplacement("cqse-abap-check-usage-released-apis-tier1", "cqse-abap-usage-of-released-apis", "Compatibility")));
        }
    }
    ,
    ANALYSIS_PROFILE_VERSION_209{

        public @NonNull IJsonMigrator getMigrator(String json, Context context) {
            List<IJsonMigration> migrations = DataDrivenFindingMigration.migrateQualityIndicatorAndCategory(EAnalysisProfileVersion.class, EAnalysisProfileVersion.SONARLINT_MIGRATIONS_LOCATION, 208, true).getInnerMigrations();
            return new JsonMigrator(migrations);
        }
    };

    private static final String ABAPLINT_MIGRATIONS_LOCATION = "/META-INF/migrations/abaplint/";
    private static final String CODE_INSPECTOR_MIGRATIONS_LOCATION = "/META-INF/migrations/code-inspector/";
    private static final String CLANG_TIDY_MIGRATIONS_LOCATION = "/META-INF/migrations/clang-tidy/";
    private static final String SONARLINT_MIGRATIONS_LOCATION = "/META-INF/migrations/sonarlint/";
    private static final String SONARLINT_CS_MIGRATIONS_LOCATION = "/META-INF/migrations/sonarlint-cs/";
    public static final EAnalysisProfileVersion CURRENT_VERSION;

    public static Context context(GlobalStorageSystem globalStorageSystem) {
        return new Context(globalStorageSystem);
    }

    static {
        CURRENT_VERSION = EAnalysisProfileVersion.values()[EAnalysisProfileVersion.values().length - 1];
    }

    public record Context(GlobalStorageSystem globalStorageSystem) {
        public Context {
            Objects.requireNonNull(globalStorageSystem, "globalStorageSystem");
        }
    }
}

