/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.index.dataflow.taintpropagation.MethodTaintGraphGenerationAnalysisRunner;
import com.teamscale.index.dataflow.taintpropagation.TaintAnalysisRunner;
import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Collectors;

public enum ETaintAnalysisOptions {
    SUPPORT_SIDEEFFECTS_ON_UNUSED_FIELDS(true, false),
    STORE_PARTIAL_GRAPH_ON_ABORT(true, false),
    ASSUME_UNKNOWN_METHODS_CLEAR_TAINTS(false, true),
    IGNORE_CALLS_TO_SAP_LIBRARY(true, false),
    TREAT_PARAMETERS_OF_RFC_ENABLED_FUNCTION_MODULES_AS_TAINT_SOURCE(true, false),
    TREAT_EXPORTING_PARAMETERS_OF_RFC_ENABLED_FUNCTION_MODULES_AS_TAINT_SOURCE(true, false);

    private final boolean influencesLocalGraphGeneration;
    private final boolean influencesGlobalFlowGeneration;

    private ETaintAnalysisOptions(boolean influencesLocalGraphGeneration, boolean influencesGlobalFlowGeneration) {
        this.influencesLocalGraphGeneration = influencesLocalGraphGeneration;
        this.influencesGlobalFlowGeneration = influencesGlobalFlowGeneration;
    }

    public static EnumSet<ETaintAnalysisOptions> filterOptionsFor(Class<?> analysisClass, Collection<ETaintAnalysisOptions> enabledOptions) {
        EnumSet<ETaintAnalysisOptions> options = EnumSet.noneOf(ETaintAnalysisOptions.class);
        if (analysisClass.equals(MethodTaintGraphGenerationAnalysisRunner.class)) {
            options.addAll(enabledOptions.stream().filter(enumValue -> enumValue.influencesLocalGraphGeneration).collect(Collectors.toSet()));
        } else if (analysisClass.equals(TaintAnalysisRunner.class)) {
            options.addAll(enabledOptions.stream().filter(enumValue -> enumValue.influencesGlobalFlowGeneration).collect(Collectors.toSet()));
        }
        return options;
    }
}

