/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.google.common.collect.Multimap;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.findings.bandit.BanditSynchronizer;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import eu.cqse.check.framework.core.option.ToolCheckOption;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class BanditConfiguration
extends ToolConfigurationBase {
    public static final String FINDING_CATEGORY = "Bandit";
    private final Multimap<String, ToolCheckOption> toolCheckOptionsByCheckId = this.readOptions("bandit/check-options.tsv");
    private static final String MAPPINGS_TSV_ROOT_DIR = "bandit";
    private static final String CHECK_MAPPINGS_TSV = "bandit/check-mappings.tsv";
    private static final String CHECK_OPTIONS_TSV = "bandit/check-options.tsv";
    public static final String EXPECTED_VERSION_FILE = "bandit/version.txt";
    private static final String DESCRIPTIONS_ROOT_DIR = "bandit";

    public BanditConfiguration() {
        super(EAnalysisTool.BANDIT, FINDING_CATEGORY);
        this.declareCodeScopeAware();
    }

    private void registerFindingDescriptors(CodeScopeName codeScopeName) throws ProjectConfigurationException {
        Map groupToQualityIndicator = this.getGroupToQualityIndicator(codeScopeName);
        try {
            Map<String, CheckMapping> checks = BanditConfiguration.loadChecksFromTSV();
            for (Map.Entry<String, CheckMapping> entry : checks.entrySet()) {
                CheckMapping mapping = entry.getValue();
                EFindingEnablement enablement = mapping.defaultEnablement;
                if (enablement == null) continue;
                CheckMappingAndCheckOptionTSVUtils.validateGroupToCategoryMapping((String)mapping.group, (String)mapping.category, (Map)groupToQualityIndicator);
                groupToQualityIndicator.put(mapping.group, mapping.category);
                this.registerFindingDescriptorAndConfigOptions(entry.getKey(), mapping, enablement, codeScopeName);
            }
        }
        catch (IOException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
    }

    private void registerFindingDescriptorAndConfigOptions(String checkId, CheckMapping checkMapping, EFindingEnablement enablement, CodeScopeName codeScopeName) throws IOException, ProjectConfigurationException {
        String readableCheckName = checkMapping.getReadableCheckName();
        String group = this.getGroup(checkMapping.group);
        String description = this.getDescription(checkId, "bandit");
        Collection options = this.toolCheckOptionsByCheckId.get((Object)checkId);
        if (StringUtils.isEmpty((String)description)) {
            LogManager.getLogger().error("Empty description for check {}", (Object)checkId);
        }
        this.createFindingType(checkId, readableCheckName, description, group, enablement, checkMapping.autoAllowed, options, codeScopeName);
    }

    private static @NonNull Map<String, CheckMapping> loadChecksFromTSV() throws IOException {
        Resource mappingsFile = Resource.of(BanditConfiguration.class, (String)CHECK_MAPPINGS_TSV);
        return CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)mappingsFile);
    }

    protected String determineQualityIndicator(String groupName, CodeScopeName codeScopeName) {
        return this.getGroupToQualityIndicator(codeScopeName).getOrDefault(groupName, "Uncategorized Bandit Check");
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CodeScopeAware activeChecksPerCodeScope = this.getActiveCheckPerCodeScope(proxy.getCodeScopeNames());
        if (activeChecksPerCodeScope == null) {
            return;
        }
        CodeScopeAware selectedOptionsPerCodeScope = CodeScopeAware.empty();
        CodeScopeAware optionValuesPerCodeScope = CodeScopeAware.empty();
        CodeScopeAware optionTypesPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : activeChecksPerCodeScope.getCodeScopeNames()) {
            BanditConfiguration.initForCodeScope(codeScopeName, (CodeScopeAware<Collection<String>>)selectedOptionsPerCodeScope, (CodeScopeAware<Collection<String>>)optionValuesPerCodeScope, (CodeScopeAware<Collection<String>>)optionTypesPerCodeScope);
            if (((Collection)activeChecksPerCodeScope.getValue(codeScopeName)).isEmpty()) continue;
            HashSet<String> selectedChecks = new HashSet<String>((Collection)activeChecksPerCodeScope.getValue(codeScopeName));
            for (Map.Entry entry : this.toolCheckOptionsByCheckId.entries()) {
                ToolCheckOption option = (ToolCheckOption)entry.getValue();
                String optionName = option.fullQualifiedID;
                if (!BanditConfiguration.checkIsActive(selectedChecks, optionName)) continue;
                this.configureOption(codeScopeName, optionName, option, (CodeScopeAware<Collection<String>>)selectedOptionsPerCodeScope, (CodeScopeAware<Collection<String>>)optionValuesPerCodeScope, (CodeScopeAware<Collection<String>>)optionTypesPerCodeScope);
            }
        }
        TriggerBuilder triggerBuilder = BanditConfiguration.createTrigger((CodeScopeAware<Collection<String>>)activeChecksPerCodeScope, (CodeScopeAware<Collection<String>>)selectedOptionsPerCodeScope, (CodeScopeAware<Collection<String>>)optionValuesPerCodeScope, (CodeScopeAware<Collection<String>>)optionTypesPerCodeScope);
        proxy.createTrigger(triggerBuilder);
        super.configureProjectInternal(proxy);
    }

    private void configureOption(CodeScopeName codeScopeName, String optionName, ToolCheckOption option, CodeScopeAware<Collection<String>> selectedOptionsPerCodeScope, CodeScopeAware<Collection<String>> optionValuesPerCodeScope, CodeScopeAware<Collection<String>> optionTypesPerCodeScope) {
        Object value = ((Map)this.valueByOptionsId.getValue(codeScopeName)).get(optionName);
        String optionValue = Optional.ofNullable(value).map(String::valueOf).orElse(null);
        String optionType = option.type.getTypeName();
        if (option.type == EToolCheckOptionType.STRING_LIST && optionValue != null) {
            optionValue = StringUtils.stripPrefix((String)optionValue, (String)"[");
            optionValue = StringUtils.stripSuffix((String)optionValue, (String)"]");
        }
        ((Collection)selectedOptionsPerCodeScope.getValue(codeScopeName)).add(option.getReadableName());
        ((Collection)optionValuesPerCodeScope.getValue(codeScopeName)).add(optionValue);
        ((Collection)optionTypesPerCodeScope.getValue(codeScopeName)).add(optionType);
    }

    private static void initForCodeScope(CodeScopeName codeScopeName, CodeScopeAware<Collection<String>> selectedOptionsPerCodeScope, CodeScopeAware<Collection<String>> optionValuesPerCodeScope, CodeScopeAware<Collection<String>> optionTypesPerCodeScope) {
        selectedOptionsPerCodeScope.setValue(codeScopeName, new ArrayList());
        optionValuesPerCodeScope.setValue(codeScopeName, new ArrayList());
        optionTypesPerCodeScope.setValue(codeScopeName, new ArrayList());
    }

    private static TriggerBuilder createTrigger(CodeScopeAware<Collection<String>> activeChecksPerCodeScope, CodeScopeAware<Collection<String>> selectedOptionsPerCodeScope, CodeScopeAware<Collection<String>> optionValuesPerCodeScope, CodeScopeAware<Collection<String>> optionTypesPerCodeScope) {
        TriggerBuilder triggerBuilder = new TriggerBuilder(BanditSynchronizer.class, ETriggerConcurrency.PARALLEL);
        triggerBuilder.setTriggerParameter("checks", ITriggerParameter.of(activeChecksPerCodeScope));
        triggerBuilder.setTriggerParameter("check-options", ITriggerParameter.of(selectedOptionsPerCodeScope));
        triggerBuilder.setTriggerParameter("check-option-values", ITriggerParameter.of(optionValuesPerCodeScope));
        triggerBuilder.setTriggerParameter("check-option-types", ITriggerParameter.of(optionTypesPerCodeScope));
        return triggerBuilder;
    }

    private static boolean checkIsActive(Set<String> activeChecks, String optionName) {
        String checkId = StringUtils.getFirstPart((String)optionName, (String)"#");
        return activeChecks.contains(checkId);
    }

    public void validateTools() throws ProjectConfigurationException {
        try {
            BanditSynchronizer.verifyVersion();
        }
        catch (ConQATException e) {
            throw new ProjectConfigurationException("Bandit tool validation failed", (Throwable)e);
        }
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (!tools.contains(this.tool)) {
            return;
        }
        this.registerFindingDescriptors(template.getCodeScope());
        super.registerQualityIndicators(template, languages, tools);
        template.registerConfiguration((AnalysisConfigurationBase)this);
    }
}

