/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.EnumSet;
import java.util.List;
import java.util.OptionalInt;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ReadAfterAssignmentDeadStoreFilter
implements IFalsePositiveFilter {
    private static final int ASSIGNED_VARIABLE_GROUP = 0;
    private static final int ASSIGNMENT_END_GROUP = 1;
    private static final TokenPattern ASSIGNMENT_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.ETokenClass.DELIMITER}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.EQ}).sequence(new Object[]{ReadAfterAssignmentDeadStoreFilter.createSubExpressionEndPattern()}).group(1);

    private static TokenPattern createSubExpressionEndPattern() {
        TokenPattern recursiveSubExpressionEndPattern = new TokenPattern(){
            private final String identityHash = Integer.toString(System.identityHashCode((Object)this));
            private final ThreadLocal<Boolean> inToString = ThreadLocal.withInitial(() -> false);

            public String toString() {
                if (this.inToString.get().booleanValue()) {
                    return "<recursive: " + this.identityHash + ">";
                }
                this.inToString.set(true);
                try {
                    String string = "(" + this.identityHash + ") " + super.toString();
                    return string;
                }
                finally {
                    this.inToString.remove();
                }
            }
        };
        EnumSet<ETokenType> openingParenthesis = EnumSet.of(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LBRACK);
        EnumSet<ETokenType> closingParenthesis = EnumSet.of(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.RBRACK);
        return recursiveSubExpressionEndPattern.skipUntil(new Object[]{ETokenType.ETokenClass.DELIMITER}).alternative(new Object[]{ETokenType.COMMA, ETokenType.RPAREN, new TokenPattern().alternative(new Object[]{new TokenPattern().skipNested(openingParenthesis, closingParenthesis, false), ETokenType.ETokenClass.DELIMITER}).sequence(new Object[]{recursiveSubExpressionEndPattern})});
    }

    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph cfg, List<ShallowEntity> fileEntities, TokenElementInfo node) {
        List<IToken> tokens = statement.getTokens();
        for (TokenPatternMatch match : ASSIGNMENT_PATTERN.findAll(tokens)) {
            if (!match.groupString(0).equals(variable)) continue;
            int assignmentExpressionEndIndex = ReadAfterAssignmentDeadStoreFilter.getAssignmentExpressionEndIndex(match).orElseGet(tokens::size);
            List afterAssignmentTokens = CollectionUtils.subListFrom(tokens, (int)assignmentExpressionEndIndex);
            if (!ReadAfterAssignmentDeadStoreFilter.isVariableUsedInTokens(variable, afterAssignmentTokens)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVariableUsedInTokens(String variable, List<IToken> tokens) {
        return tokens.stream().anyMatch(token -> token.getType() == ETokenType.IDENTIFIER && variable.equals(token.getText()));
    }

    private static OptionalInt getAssignmentExpressionEndIndex(TokenPatternMatch match) {
        return match.groupIndices(1).stream().mapToInt(Integer::intValue).max();
    }
}

