/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.update;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.index.external.ExternalUploadIndexBase;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryContentUpdaterUtils;
import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.committree.BranchRenamingCommitTreeFacade;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.StringTransformation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public abstract class ExternalUploadPersisterBase<T extends Serializable>
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected CommitDescriptorIndex commitDescriptorIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected ElementHistoryIndex elementHistoryIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected RepositoryLogIndex logIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected RepositoryLogFileIndex logFileIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected MetaIndex projectMetaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected RepositoryRevisionIndex repositoryRevisionIndex;
    protected ParentedCommitDescriptor parentedSchedulingCommit;

    public final void execute() throws StorageException, RepositoryException {
        PairList additionalNodes;
        CommitDescriptor currentCommit = this.getSchedulingCommit();
        this.assertAndDoFinally(!this.getCommitTreeDelta().isEmpty(), () -> "May not schedule with empty delta", currentCommit);
        CommitTree commitTree = this.getCommitTreeIndex().loadTree();
        ICommitTreeNode commitTreeNode = commitTree.getNodeByBranchAndAdjustedTimestamp(currentCommit.getBranchName(), currentCommit.getTimestamp());
        this.assertAndDoFinally(commitTreeNode != null, () -> "Expected commit tree to contain node for " + String.valueOf(currentCommit), currentCommit);
        if (Objects.requireNonNull(commitTreeNode).getState() == ECommitTreeNodeState.SKIPPED) {
            return;
        }
        this.parentedSchedulingCommit = this.commitDescriptorIndex.getCommit(currentCommit);
        if (this.parentedSchedulingCommit == null && PreCommitUtils.isPrecommitCommit((CommitDescriptor)currentCommit)) {
            throw new RepositoryNeedsRollbackException("The injected commit " + String.valueOf(currentCommit) + " does not exist! Resetting pre-commits on branch " + currentCommit.getBranchName(), Collections.singletonMap(currentCommit.getBranchName(), 1L));
        }
        this.assertAndDoFinally(this.parentedSchedulingCommit != null, () -> "Expected commit " + String.valueOf(currentCommit) + " to be present in commit descriptor index!", currentCommit);
        try {
            additionalNodes = RepositoryContentUpdaterUtils.determineRequiredAdditionalNodesToBeScanned(this.parentedSchedulingCommit, commitTreeNode, new BranchRenamingCommitTreeFacade((IChangeRetrieverCommitTree)commitTree, new StringTransformation(), this.getCommitTreeIndex()), this.commitDescriptorIndex, false);
        }
        catch (CommitResolutionException e) {
            LOGGER.error("Failed to determine required additional nodes to be scanned for commit '{}'.", (Object)currentCommit, (Object)e);
            return;
        }
        additionalNodes = additionalNodes.reversed();
        additionalNodes.add((Object)commitTreeNode, (Object)EChangeEntryOrigin.EXTERNAL_UPLOAD);
        this.processCommitsForNodes(additionalNodes.extractFirstList());
    }

    @Contract(value="false, _, _ -> fail")
    private void assertAndDoFinally(boolean condition, Supplier<String> errorMessage, CommitDescriptor currentCommit) throws StorageException {
        if (!condition) {
            this.markUploadAsFailed(errorMessage.get(), currentCommit);
            throw new AssertionError((Object)errorMessage.get());
        }
    }

    protected void markUploadAsFailed(String errorMessage, CommitDescriptor currentCommit) throws StorageException {
    }

    protected abstract KeyDelta getCommitTreeDelta();

    protected abstract IBranchingLayer getExternalUploadBranchingLayer();

    protected ExternalUploadIndexBase<T> getExternalUploadIndex(ICommitTreeNode node) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)node.getRevision().getBranchName(), (long)node.getOriginalTimestamp());
        return this.createExternalUploadIndex(this.getExternalUploadBranchingLayer().openStore(historyAccessOption));
    }

    protected ExternalUploadIndexBase<T> getExternalUploadIndex(CommitDescriptor commitDescriptor) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)commitDescriptor.getBranchName(), (long)commitDescriptor.getTimestamp());
        return this.createExternalUploadIndex(this.getExternalUploadBranchingLayer().openStore(historyAccessOption));
    }

    protected abstract ExternalUploadIndexBase<T> createExternalUploadIndex(IStore var1);

    protected abstract void processCommitsForNodes(List<ICommitTreeNode> var1) throws StorageException;

    protected abstract CommitTreeIndex getCommitTreeIndex();

    protected abstract String getRepositoryIdentifier();

    protected abstract ECommitType getCommitType();

    protected void writeRepositoryLogEntry(CommitDescriptor commit, String revisionPrefix, String commitMessage, String commitUser, int numAddedFiles, int numEditedFiles, int numDeletedFiles) throws StorageException {
        this.writeRepositoryLogEntry(commit, revisionPrefix, commitMessage, commitUser, numAddedFiles, numEditedFiles, numDeletedFiles, null);
    }

    protected void writeRepositoryLogEntry(CommitDescriptor commit, String revisionPrefix, @Nullable String commitMessage, String commitUser, int numAddedFiles, int numEditedFiles, int numDeletedFiles, @Nullable Long uploadDateTimestamp) throws StorageException {
        String revision = revisionPrefix + ":" + String.valueOf(Objects.requireNonNull(commit, "Must pass a non-null commit to store a log entry."));
        String repositoryIdentifier = this.getRepositoryIdentifier();
        RepositoryLogEntry logEntry = new RepositoryLogEntry(revision, commit, commitMessage, commitUser, numAddedFiles, numEditedFiles, numDeletedFiles, repositoryIdentifier, this.getCommitType(), uploadDateTimestamp);
        this.repositoryRevisionIndex.setProcessedCommit(new RepositoryRevisionIndex.RevisionAndRepository(revision, repositoryIdentifier), commit);
        this.logIndex.setEntry(logEntry);
    }

    protected void writeRepositoryLogFileEntries(CommitDescriptor commit, Collection<UniformPath> addedOrChangedFiles, List<UniformPath> deletedFiles, ECommitType commitType) throws StorageException {
        ArrayList<RepositoryLogFileEntry> logFileEntries = new ArrayList<RepositoryLogFileEntry>();
        for (UniformPath uniformPath : addedOrChangedFiles) {
            logFileEntries.add(new RepositoryLogFileEntry(commit, uniformPath, commitType, null, false));
        }
        for (UniformPath uniformPath : deletedFiles) {
            logFileEntries.add(new RepositoryLogFileEntry(commit, uniformPath, commitType, null, true));
        }
        this.logFileIndex.insertEntries(logFileEntries);
    }
}

