/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.cross_file_analysis;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.findings.cross_file_analysis.CrossFileAnalysisFindingsIndex;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

public abstract class CrossFileFindingsAnalysisBase
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected CrossFileAnalysisFindingsIndex crossFileFindingsIndex;

    protected void storeFindings(Map<String, List<IndexFinding>> findings, CodeScopeAware<Set<String>> analyzedPathsPerCodeScope, List<String> deletedUniformPaths, String findingIndexPartition) throws StorageException {
        HashMap<String, CodeScopeName> codeScopeNames = new HashMap<String, CodeScopeName>();
        for (CodeScopeName codeScopeName : analyzedPathsPerCodeScope.getCodeScopeNames()) {
            for (String analyzedPath : (Set)analyzedPathsPerCodeScope.getValue(codeScopeName)) {
                codeScopeNames.put(analyzedPath, codeScopeName);
            }
        }
        for (Map.Entry entry : findings.entrySet()) {
            String analyzedPath = (String)entry.getKey();
            CodeScopeName codeScopeName = (CodeScopeName)codeScopeNames.get(analyzedPath);
            List findingsFromAnalysisPath = (List)entry.getValue();
            for (IndexFinding finding : findingsFromAnalysisPath) {
                CCSMAssert.isTrue((boolean)codeScopeName.equals((Object)finding.getCodeScopeName()), (String)"Finding has code scope name that does not match the code scope name of the analyzed file.");
            }
        }
        this.crossFileFindingsIndex.storeFindings(findings, CrossFileFindingsAnalysisBase.getAllAnalyzedPaths(analyzedPathsPerCodeScope), deletedUniformPaths, findingIndexPartition);
    }

    private static Set<String> getAllAnalyzedPaths(CodeScopeAware<Set<String>> analyzedPathsPerCodeScope) {
        return analyzedPathsPerCodeScope.getValues().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

