/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint.dev_utils;

import com.teamscale.index.configuration.tools.SonarLintConfiguration;
import com.teamscale.index.findings.sonarlint.SonarLintRulesExtractor;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import eu.cqse.check.framework.core.option.ToolCheckOption;
import eu.cqse.check.framework.core.registry.CheckMapping;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneRuleDetails;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneRuleParam;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneRuleParamType;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneSonarLintEngine;

public class SonarLintRuleOptionsExtractor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TSV_OPTIONS_HEADER_ROW = "Check ID\tOption ID\tReadable Name\tDescription\tType\tDefault Value";
    private static final File SONAR_LINT_CHECK_OPTIONS = new File("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/message/sonarlint/check-options.tsv");
    private final StandaloneSonarLintEngine engine;

    public SonarLintRuleOptionsExtractor(StandaloneSonarLintEngine engine) {
        this.engine = engine;
    }

    public void execute() throws ConQATException, IOException {
        Set<ToolCheckOption> existingOptions = SonarLintRuleOptionsExtractor.getExistingSonarLintOptionsBySonarRuleID();
        Set<String> disabledChecks = SonarLintRuleOptionsExtractor.getDisabledChecks();
        this.addNewCheckOptions(existingOptions);
        Set<ToolCheckOption> deletedOptions = this.determineRemovedOptions(existingOptions, disabledChecks);
        existingOptions.removeAll(deletedOptions);
        SonarLintRuleOptionsExtractor.regenerateCheckOptionsFile(existingOptions);
    }

    private static Set<String> getDisabledChecks() {
        HashSet<String> disabledChecks = new HashSet<String>();
        Map<String, CheckMapping> existingSonarLintRulesBySonarID = SonarLintRulesExtractor.getExistingSonarLintRulesBySonarID();
        for (Map.Entry<String, CheckMapping> entry : existingSonarLintRulesBySonarID.entrySet()) {
            if (entry.getValue().defaultEnablement != null) continue;
            disabledChecks.add(entry.getKey());
        }
        return disabledChecks;
    }

    private static void regenerateCheckOptionsFile(Set<ToolCheckOption> options) throws IOException {
        ArrayList<String> checkOptions = new ArrayList<String>();
        checkOptions.add(TSV_OPTIONS_HEADER_ROW);
        for (ToolCheckOption option : options) {
            checkOptions.add(SonarLintRuleOptionsExtractor.writeLine(option));
        }
        FileSystemUtils.writeLines((File)SONAR_LINT_CHECK_OPTIONS, checkOptions, (Charset)StandardCharsets.UTF_8);
        LOGGER.info("New options TSV file has been written to " + String.valueOf(SONAR_LINT_CHECK_OPTIONS));
    }

    private static Set<ToolCheckOption> getExistingSonarLintOptionsBySonarRuleID() {
        Resource optionsFile = Resource.of(SonarLintConfiguration.class, (String)"message/sonarlint/check-options.tsv");
        return CheckMappingAndCheckOptionTSVUtils.readCheckOptionsFromTsv((Resource)optionsFile);
    }

    private Set<ToolCheckOption> determineRemovedOptions(Set<ToolCheckOption> existingOptions, Set<String> disabledChecks) {
        TreeSet<ToolCheckOption> removedOptions = new TreeSet<ToolCheckOption>();
        for (ToolCheckOption option : existingOptions) {
            Optional ruleDetails = this.engine.getRuleDetails(option.checkId);
            if (disabledChecks.contains(option.checkId)) {
                removedOptions.add(option);
                continue;
            }
            if (ruleDetails.isEmpty()) {
                removedOptions.add(option);
                continue;
            }
            Set paramIds = ((StandaloneRuleDetails)ruleDetails.get()).paramDetails().stream().map(StandaloneRuleParam::key).collect(Collectors.toSet());
            if (paramIds.contains(option.optionId)) continue;
            removedOptions.add(option);
            LOGGER.warn("Option {} of rule {} is no longer supported by SonarLint. Please verify this manually and write a migration.", (Object)option.optionId, (Object)option.checkId);
        }
        return removedOptions;
    }

    private void addNewCheckOptions(Set<ToolCheckOption> availableOptions) {
        this.engine.getAllRuleDetails().forEach(rule -> rule.paramDetails().forEach(param -> {
            ToolCheckOption option = SonarLintRuleOptionsExtractor.buildCheckOption(rule, param);
            availableOptions.add(option);
        }));
    }

    private static ToolCheckOption buildCheckOption(StandaloneRuleDetails rule, StandaloneRuleParam param) {
        EToolCheckOptionType type = SonarLintRuleOptionsExtractor.parseType(param.type());
        String name = param.name() + " (" + rule.getKey() + ")";
        String description = StringUtils.emptyIfNull((String)param.description());
        return new ToolCheckOption(rule.getKey(), param.key(), name, description, type, param.defaultValue());
    }

    private static EToolCheckOptionType parseType(StandaloneRuleParamType sonarLintType) {
        if (sonarLintType == StandaloneRuleParamType.TEXT) {
            return EToolCheckOptionType.MULTILINE_STRING;
        }
        return (EToolCheckOptionType)EnumUtils.valueOfIgnoreCase(EToolCheckOptionType.class, (String)sonarLintType.toString());
    }

    private static String writeLine(ToolCheckOption option) {
        String optionId = StringUtils.getLastPart((String)option.fullQualifiedID, (String)"#");
        return option.checkId + "\t" + optionId + "\t" + option.getReadableName() + "\t" + option.getDescription() + "\t" + String.valueOf(option.type) + "\t" + StringUtils.emptyIfNull((String)option.getDefaultValue());
    }
}

