/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap;

import com.teamscale.index.gitbridge.GitBridgeException;
import com.teamscale.index.gitbridge.abap.AbapExportXmlTableReaderBase;
import com.teamscale.index.gitbridge.abap.CommitCluster;
import com.teamscale.index.gitbridge.abap.CommitInfo;
import com.teamscale.index.metadata.abap.AbapFileMetadata;
import com.teamscale.index.metadata.abap.EAbapLanguageVersion;
import com.teamscale.index.metadata.abap.EAbapProgramType;
import com.teamscale.index.metadata.abap.ECompatibilityContract;
import com.teamscale.index.metadata.abap.EReleaseState;
import com.teamscale.index.metadata.abap.ReleaseContract;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.EObjectMetaDataFields;
import org.conqat.engine.abap.UniqueAbapElementName;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;

public class ObjectMetaData
extends AbapExportXmlTableReaderBase<EObjectMetaDataFields> {
    protected static final Logger LOGGER = LogManager.getLogger();
    private final Map<CommitInfo, List<Modification>> modificationsByCommitInfoMap = new HashMap<CommitInfo, List<Modification>>();
    private final Map<String, AbapFileMetadata> objectPathsToMetadata;
    private final Instant defaultModificationTime;
    private final Instant earliestCommitTime;
    private final String defaultUserName;
    private final ZoneOffset sapTimeZone;
    private final int maxCommitGapSeconds;
    private final Map<UniqueAbapElementName, Boolean> rfcEnablementMap = new HashMap<UniqueAbapElementName, Boolean>();
    private static final List<EObjectMetaDataFields> RELEASE_CONTRACT_XML_FIELDS = List.of(EObjectMetaDataFields.SUB_OBJECT_NAME, EObjectMetaDataFields.SUB_OBJECT_TYPE, EObjectMetaDataFields.COMPATIBILITY_CONTRACT, EObjectMetaDataFields.RELEASE_STATE, EObjectMetaDataFields.USE_IN_KEY_USER_APPS, EObjectMetaDataFields.USE_IN_SAP_CLOUD_PLATFORM);

    public ObjectMetaData(String defaultUserName, Instant defaultModificationTime, Instant earliestCommitTime, ZoneOffset sapTimeZone, int maxCommitGapSeconds) {
        super(EObjectMetaDataFields.class);
        CCSMAssert.isNotNull((Object)defaultModificationTime, (String)"Default modification time must not be null!");
        CCSMAssert.isNotNull((Object)earliestCommitTime, (String)"Time of earliest possible commit must not be null!");
        this.defaultUserName = defaultUserName;
        this.sapTimeZone = sapTimeZone;
        this.defaultModificationTime = defaultModificationTime;
        this.earliestCommitTime = earliestCommitTime;
        this.maxCommitGapSeconds = maxCommitGapSeconds;
        this.objectPathsToMetadata = new HashMap<String, AbapFileMetadata>();
    }

    @Override
    protected EObjectMetaDataFields getRecordElement() {
        return EObjectMetaDataFields.ITEM;
    }

    @Override
    protected void processRecord() {
        String abapObjectPath = this.getChildText(EObjectMetaDataFields.PATH);
        if (StringUtils.isEmpty((String)abapObjectPath)) {
            return;
        }
        Instant lastUpdateDate = this.readLastUpdateDate();
        CommitInfo commitInfo = this.readCommitInfo();
        UniqueAbapElementName element = this.readElementName(EObjectMetaDataFields.OBJNAME, EObjectMetaDataFields.OBJTYPE, EObjectMetaDataFields.DDIC_OBJTYPE);
        this.addModification(commitInfo, lastUpdateDate, element);
        boolean isRfcEnabled = this.readBoolean(EObjectMetaDataFields.IS_RFC_FUNCTION, false);
        boolean isGeneratedCode = this.readBoolean(EObjectMetaDataFields.GENERATION, false);
        String originSystem = this.getChildText(EObjectMetaDataFields.ORIGIN_SYSTEM);
        String authorizationGroup = this.getChildText(EObjectMetaDataFields.AUTH_GROUP);
        ReleaseContract releaseContract = this.getReleaseContract();
        EAbapProgramType programType = this.getProgramType();
        EAbapLanguageVersion abapLanguageVersion = this.getLanguageVersion();
        this.rfcEnablementMap.put(element, isRfcEnabled);
        this.objectPathsToMetadata.put(abapObjectPath, new AbapFileMetadata(abapObjectPath, this.readCreationDate(), this.readLastUpdateDateTime(), originSystem, programType, authorizationGroup, abapLanguageVersion, releaseContract, isRfcEnabled, isGeneratedCode));
    }

    private long readCreationDate() {
        return ObjectMetaData.getDateTimeAsMilliSeconds(this.getChildText(EObjectMetaDataFields.CDAT), "00:00:00");
    }

    private long readLastUpdateDateTime() {
        return ObjectMetaData.getDateTimeAsMilliSeconds(this.getChildText(EObjectMetaDataFields.UDAT), this.getChildText(EObjectMetaDataFields.UTIME));
    }

    private static long getDateTimeAsMilliSeconds(String date, String time) {
        Object dateTime = date;
        if (dateTime == null || "0000-00-00".equals(dateTime)) {
            return 0L;
        }
        dateTime = time != null ? (String)dateTime + "T" + time : (String)dateTime + "T00:00:00";
        try {
            LocalDateTime localDateTime = LocalDateTime.parse((CharSequence)dateTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        catch (DateTimeException e) {
            LOGGER.error("Could not parse date and time. " + e.getMessage());
            return 0L;
        }
    }

    private EAbapProgramType getProgramType() {
        String programTypeValue = this.getChildText(EObjectMetaDataFields.PROGRAM_TYPE);
        if (StringUtils.isEmpty((String)programTypeValue)) {
            if (this.hasChild(EObjectMetaDataFields.PROGRAM_TYPE)) {
                return EAbapProgramType.NOT_ASSIGNED;
            }
            return null;
        }
        char typeValue = programTypeValue.charAt(0);
        EAbapProgramType programType = EAbapProgramType.getProgramTypeFromValue((char)typeValue);
        if (programType == EAbapProgramType.UNKNOWN_TYPE) {
            LOGGER.warn("Unknown program type value: " + typeValue + "\nThis is new. Login on SAP GUI -> Run transaction SE11 -> Open the domain 'SUBC' -> Click <Value Range> to get infos about this new type and update EProgramType.java");
        }
        return programType;
    }

    private EAbapLanguageVersion getLanguageVersion() {
        String versionId = this.getChildText(EObjectMetaDataFields.LANGUAGE_VERSION);
        if (versionId != null) {
            if (StringUtils.isEmpty((String)versionId)) {
                return EAbapLanguageVersion.OBSOLETE_ABAP;
            }
            char versionIdChar = versionId.charAt(0);
            EAbapLanguageVersion abapLanguageVersion = EAbapLanguageVersion.getLanguageVersionFromId((char)versionIdChar);
            if (abapLanguageVersion == EAbapLanguageVersion.UNKNOWN) {
                LOGGER.warn("Unknown ABAP Language Version ID: " + versionId + "\nThis is new. Login on SAP GUI -> Run transaction SE11 -> Display data type 'ABAPVRS' ->Double-click domain name value -> click <Value Range> to get infos about this new ID and update EAbapLanguageVersion.java");
            }
            return abapLanguageVersion;
        }
        return null;
    }

    private ReleaseContract getReleaseContract() {
        if (RELEASE_CONTRACT_XML_FIELDS.stream().noneMatch(this::hasChild)) {
            return null;
        }
        String subObjectName = this.getChildText(EObjectMetaDataFields.SUB_OBJECT_NAME);
        String subObjectType = this.getChildText(EObjectMetaDataFields.SUB_OBJECT_TYPE);
        String compatibilityContractId = this.getChildText(EObjectMetaDataFields.COMPATIBILITY_CONTRACT);
        ECompatibilityContract compatibilityContract = null;
        if (!StringUtils.isEmpty((String)compatibilityContractId) && (compatibilityContract = ECompatibilityContract.getCompatibilityContract((String)compatibilityContractId)) == ECompatibilityContract.UNKNOWN) {
            LOGGER.warn("Unknown Compatibility Contract ID: " + compatibilityContractId + "\nThis is new. Login on SAP GUI -> Run transaction SE11 -> Display data type 'ARS_RELEASE_CONTRACT' ->Double-click domain name value -> click <Value Range> to get infos about this new ID and update ECompatibilityContract.java");
        }
        String releaseStateId = this.getChildText(EObjectMetaDataFields.RELEASE_STATE);
        EReleaseState releaseState = null;
        if (!StringUtils.isEmpty((String)releaseStateId) && (releaseState = EReleaseState.getReleaseStateFromName((String)releaseStateId)) == EReleaseState.UNKNOWN_STATE) {
            LOGGER.warn("Unknown Release State: " + releaseStateId + "\nThis is new. Use the documentation in EReleaseState.java to retrieve infos for this\nnew release state and update the enumeration.");
        }
        boolean useInKeyUserApps = this.readBoolean(EObjectMetaDataFields.USE_IN_KEY_USER_APPS, false);
        boolean useInSapCloudPlatform = this.readBoolean(EObjectMetaDataFields.USE_IN_SAP_CLOUD_PLATFORM, false);
        return new ReleaseContract(subObjectName, subObjectType, compatibilityContract, releaseState, useInKeyUserApps, useInSapCloudPlatform);
    }

    private Instant readLastUpdateDate() {
        Instant lastUpdateDate = null;
        try {
            lastUpdateDate = AbapUtils.buildUpdateDate((String)this.getChildText(EObjectMetaDataFields.UDAT), (String)this.getChildText(EObjectMetaDataFields.UTIME), (TimeZone)TimeZone.getTimeZone(this.sapTimeZone)).toInstant();
        }
        catch (ParseException e) {
            LOGGER.warn("Unable to parse update date from meta data", (Throwable)e);
        }
        if (lastUpdateDate == null || lastUpdateDate.toEpochMilli() < 0L) {
            lastUpdateDate = this.defaultModificationTime;
        }
        if (lastUpdateDate.isBefore(this.earliestCommitTime)) {
            lastUpdateDate = this.earliestCommitTime;
        }
        return lastUpdateDate;
    }

    private CommitInfo readCommitInfo() {
        String userName = this.getChildText(EObjectMetaDataFields.UNAM);
        if (userName == null) {
            userName = this.defaultUserName;
        }
        String transportTaskId = this.getChildText(EObjectMetaDataFields.TASK_ID);
        String transportRequestId = this.getChildText(EObjectMetaDataFields.TR_ID);
        if (StringUtils.isEmpty((String)transportTaskId) && StringUtils.isEmpty((String)transportRequestId)) {
            return new CommitInfo(userName);
        }
        if (StringUtils.isEmpty((String)transportTaskId)) {
            return new CommitInfo(userName, transportRequestId, this.getChildText(EObjectMetaDataFields.TR_TEXT));
        }
        return new CommitInfo(userName, transportRequestId, transportTaskId, this.getChildText(EObjectMetaDataFields.TR_TEXT));
    }

    private void addModification(CommitInfo commitInfo, Instant updateTime, UniqueAbapElementName element) {
        List modificationsForCommitInfo = this.modificationsByCommitInfoMap.computeIfAbsent(commitInfo, k -> new ArrayList());
        modificationsForCommitInfo.add(new Modification(updateTime, element));
    }

    public SortedSet<CommitCluster> buildCommitClusters() {
        TreeSet<CommitCluster> result = new TreeSet<CommitCluster>();
        for (CommitInfo commitInfo : this.modificationsByCommitInfoMap.keySet()) {
            result.addAll(this.buildCommitCluster(commitInfo));
        }
        return result;
    }

    private List<CommitCluster> buildCommitCluster(CommitInfo commitInfo) {
        ArrayList<CommitCluster> result = new ArrayList<CommitCluster>();
        List<Modification> commitInfoModifications = this.modificationsByCommitInfoMap.get(commitInfo);
        commitInfoModifications.sort(Comparator.comparing(Modification::updateDate));
        CommitCluster cluster = null;
        Instant previousUpdateTime = null;
        for (Modification modification : commitInfoModifications) {
            Instant modificationUpdateTime = modification.updateDate();
            if (previousUpdateTime == null) {
                previousUpdateTime = modificationUpdateTime;
            }
            if (cluster == null || this.isSeperateCommit(commitInfo, previousUpdateTime, modificationUpdateTime)) {
                cluster = new CommitCluster(commitInfo);
                result.add(cluster);
            }
            cluster.addElement(modification.element(), modificationUpdateTime);
            previousUpdateTime = modificationUpdateTime;
        }
        return result;
    }

    private boolean isSeperateCommit(CommitInfo commitInfo, Instant previousModification, Instant currentModification) {
        long gap = Duration.between(previousModification, currentModification).getSeconds();
        return !commitInfo.hasTransport() && gap > (long)this.maxCommitGapSeconds;
    }

    public boolean isRfcEnabled(UniqueAbapElementName element) throws GitBridgeException {
        if (element.getObjectType() != EAbapObjectType.FUGR) {
            return false;
        }
        Boolean rfcEnabled = this.rfcEnablementMap.get(element);
        if (rfcEnabled == null) {
            throw new GitBridgeException("No RFC enabelment for " + String.valueOf(element) + " in object meta data found.");
        }
        return rfcEnabled;
    }

    public AbapFileMetadata getMetadataForObject(String objectPath) {
        return this.objectPathsToMetadata.get(objectPath);
    }

    private record Modification(Instant updateDate, UniqueAbapElementName element) {
    }
}

