/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issue_reference;

import eu.cqse.check.framework.core.xpath.DocumentRootShallowEntity;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpecItemEntityExtractor {
    private static final Logger LOGGER = LogManager.getLogger();

    public static ShallowEntity getSpecItemEntity(IToken token, List<ShallowEntity> entities, String uniformPath) {
        if (entities.isEmpty()) {
            LOGGER.warn("No shallow entities found in the uniform path: " + uniformPath);
            return null;
        }
        DocumentRootShallowEntity.wrapWithRootIfNecessary(entities, (String)token.getOriginId());
        ShallowEntity entity = ShallowEntityTraversalUtils.findEntityForLine((int)token.getLineNumber(), entities, (boolean)true).orElse(null);
        if (entity == null) {
            LOGGER.warn("Could neither find shallow entity in line " + token.getLineNumber() + ", nor in the following lines for uniform path: " + uniformPath);
            return null;
        }
        ShallowEntity shallowEntity = SpecItemEntityExtractor.skipAnnotations(entity);
        if (shallowEntity == null) {
            LOGGER.warn("Could not find subsequent entity for " + entity.getName() + " in uniform path " + uniformPath + " after skipping annotations.");
            return null;
        }
        Set<EShallowEntityType> typesSet = Set.of(EShallowEntityType.METHOD, EShallowEntityType.META, EShallowEntityType.TYPE, EShallowEntityType.ATTRIBUTE);
        ShallowEntity shallowEntityOfType = ShallowEntityTraversalUtils.findEntityOrParentEntity((ShallowEntity)shallowEntity, e -> typesSet.contains(e.getType())).orElse(null);
        if (shallowEntityOfType == null) {
            LOGGER.warn("Could not find a shallow entity in the parent hierarchy of " + shallowEntity.getName() + " in " + uniformPath + " that would belong to one of following types: " + String.valueOf(typesSet));
        }
        return shallowEntityOfType;
    }

    private static ShallowEntity skipAnnotations(ShallowEntity shallowEntity) {
        while (shallowEntity != null && shallowEntity.getType() == EShallowEntityType.META && (shallowEntity.getSubtype().equals("annotation") || shallowEntity.getSubtype().equals("attribute annotation"))) {
            shallowEntity = ShallowEntityTraversalUtils.getSubsequentEntity((ShallowEntity)shallowEntity);
        }
        return shallowEntity;
    }
}

