/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.synchronization;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IssueHistoryIndex;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.cleanup.OnceEveryDayCleanupStrategy;
import com.teamscale.index.issues.cleanup.WorkItemCleaner;
import com.teamscale.index.issues.jira.cache.JiraGlobalCacheUpdater;
import com.teamscale.index.issues.jira.model.JiraJsonIssue;
import com.teamscale.index.issues.jira.synchronization.JiraSynchronizerBase;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class JiraIssueSynchronizer
extends JiraSynchronizerBase<TeamscaleIssue> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CLEANUP_ENABLED_PARAMETER = "cleanup-enabled";
    @StepParameter(value="cleanup-enabled", optional=true)
    private boolean cleanupEnabled;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private IssueHistoryIndex issueHistoryIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private IssueIndex issueIndex;
    @StepParameterObject
    private final OnceEveryDayCleanupStrategy cleanupStrategy = new OnceEveryDayCleanupStrategy();

    public IssueHistoryIndex getIssueHistoryIndex() {
        return this.issueHistoryIndex;
    }

    @Override
    protected IssueIndexBase<TeamscaleIssue> getWorkItemIndex() {
        return this.issueIndex;
    }

    @Override
    protected TeamscaleIssue createIssue(JiraJsonIssue jiraIssue, String url, List<String> customFieldNames, List<String> customFieldValues, Map<String, String> typeAbbreviation) {
        return JiraIssueSynchronizer.createTeamscaleIssue(jiraIssue, this.getConnectorId(), url, customFieldNames, customFieldValues);
    }

    public static TeamscaleIssue createTeamscaleIssue(JiraJsonIssue jiraIssue, String connectorId, String url, List<String> customFieldNames, List<String> customFieldValues) {
        ArrayList<String> additionalFieldNames = new ArrayList<String>();
        ArrayList<String> additionalFieldValues = new ArrayList<String>();
        JiraJsonIssue.addAdditionalFields(jiraIssue.fields(), jiraIssue.key(), customFieldNames, customFieldValues, additionalFieldNames, additionalFieldValues);
        return JiraJsonIssue.createTeamscaleIssue(jiraIssue.key(), connectorId, url, jiraIssue.fields(), JiraIssueSynchronizer.getRenderedDescription(jiraIssue), additionalFieldNames, additionalFieldValues);
    }

    private static String getRenderedDescription(JiraJsonIssue jiraJsonIssue) {
        if (jiraJsonIssue.renderedFields() != null && jiraJsonIssue.renderedFields().description() != null) {
            return jiraJsonIssue.renderedFields().description();
        }
        LOGGER.warn("No rendered description for Jira issue found, using plain text description instead.");
        return jiraJsonIssue.fields().description();
    }

    @Override
    protected Map<TeamscaleIssueId, Long> performCleanupIfNecessary() throws BugTrackerException, StorageException {
        if (!this.cleanupEnabled) {
            return Collections.emptyMap();
        }
        JiraGlobalCacheUpdater updater = new JiraGlobalCacheUpdater(this.configuration, -1L, this.jiraGlobalCacheIndex);
        try {
            updater.performCacheCleanupIfNeeded(this.getCurrentImportStart());
        }
        catch (ServiceCallException e) {
            throw new BugTrackerException("Failed to perform cache cleanup.", e);
        }
        return new WorkItemCleaner<TeamscaleIssue>(this.getWorkItemIndex(), this.getIssueHistoryIndex(), this.connectorId, this.cleanupStrategy).performCleanupIfNecessary(this.getCurrentImportStart(), () -> new HashSet<String>(this.jiraGlobalCacheIndex.getAllStoredIssueIds(this.configuration.getConfigurationId())));
    }
}

