/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.radar;

import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IIssueHistoryIndex;
import com.teamscale.index.issues.IssueHistoryIndex;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.cleanup.OnceEveryDayCleanupStrategy;
import com.teamscale.index.issues.cleanup.WorkItemCleaner;
import com.teamscale.index.issues.radar.RadarProblemHistorySimulator;
import com.teamscale.index.issues.radar.client.RadarClient;
import com.teamscale.index.issues.radar.model.RadarProblem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class RadarIssueSynchronizer
extends IssueTrackerSynchronizerBase<TeamscaleIssue> {
    public static final String COMPONENTS_PARAMETER_NAME = "components";
    public static final String COMPONENT_BUNDLES_PARAMETER_NAME = "component bundles";
    public static final String COMPONENT_BUNDLE_GROUPS_PARAMETER_NAME = "component bundle groups";
    public static final String KEYWORDS_PARAMETER_NAME = "keywords";
    public static final String A3_OPTION_SELECTOR_PARAMETER = "a3-option-identifier";
    private static final Logger LOGGER = LogManager.getLogger();
    @StepParameter(value="keywords", optional=true)
    private final Set<String> keywords = new HashSet<String>();
    @StepParameterObject
    private final OnceEveryDayCleanupStrategy cleanupStrategy = new OnceEveryDayCleanupStrategy();
    @StepParameter(value="components", optional=true)
    private List<String> components = new ArrayList<String>();
    @StepParameter(value="component bundles", optional=true)
    private List<String> componentBundles = new ArrayList<String>();
    @StepParameter(value="component bundle groups", optional=true)
    private List<String> componentBundleGroups = new ArrayList<String>();
    @StepParameter(value="a3-option-identifier")
    private String appleA3MultiOptionIdentifier;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private IssueHistoryIndex issueHistoryIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private IssueIndex issueIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ServerOptionIndex serverOptionIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private AccessTokenIndex accessTokenIndex;
    private RadarClient client;

    private static long chooseHistoryStartTimestampForProblem(boolean isNewProblem, long startTimestamp, long syncStartTimestamp) {
        if (isNewProblem) {
            return startTimestamp;
        }
        return syncStartTimestamp + 1L;
    }

    @Override
    protected IIssueHistoryIndex<TeamscaleIssue> getIssueHistoryIndex() {
        return this.issueHistoryIndex;
    }

    @Override
    protected IssueIndexBase<TeamscaleIssue> getWorkItemIndex() {
        return this.issueIndex;
    }

    @Override
    protected void init() throws BugTrackerException {
        try {
            this.client = RadarClient.create(this.accessTokenIndex, this.serverOptionIndex, this.appleA3MultiOptionIdentifier, LOGGER);
        }
        catch (StorageException e) {
            throw new BugTrackerException("Could not initialize Radar A3.", e);
        }
    }

    @Override
    protected void initializeFieldsFromExternalAccount() {
    }

    @Override
    protected IssueTrackerSynchronizerBase.WorkItemUpdateResult retrieveUpdatedItems(long lastScanTimestamp, long historyStartTimestamp, long onlyItemsChangedAfterTimestamp) throws BugTrackerException, StorageException {
        Preconditions.checkState((!this.components.isEmpty() || !this.componentBundles.isEmpty() || !this.componentBundleGroups.isEmpty() ? 1 : 0) != 0);
        long syncStartTimestamp = Math.max(lastScanTimestamp, onlyItemsChangedAfterTimestamp);
        List<RadarProblem> synchronizedProblems = this.getUpdatedProblems(historyStartTimestamp, syncStartTimestamp, lastScanTimestamp);
        Set<String> unknownProblemIds = this.filterToUnknownIssuesByExternalId(CollectionUtils.map(synchronizedProblems, RadarProblem::getIdString));
        ArrayList<TeamscaleIssue> updatedIssueItems = new ArrayList<TeamscaleIssue>();
        for (RadarProblem problem : synchronizedProblems) {
            boolean isNewProblem = unknownProblemIds.contains(problem.getIdString());
            long problemSyncTimestamp = RadarIssueSynchronizer.chooseHistoryStartTimestampForProblem(isNewProblem, historyStartTimestamp, syncStartTimestamp);
            RadarProblemHistorySimulator simulator = new RadarProblemHistorySimulator(problemSyncTimestamp, this.getConnectorId(), problem, isNewProblem, this.customFields.extractFirstList());
            List<TeamscaleIssue> issueHistoryForProblem = simulator.simulateIssueHistory();
            updatedIssueItems.addAll(issueHistoryForProblem);
        }
        return this.resultBuilder().addItems(updatedIssueItems).addDeletions(this.performCleanupAndReturnDeletedItems(historyStartTimestamp, onlyItemsChangedAfterTimestamp)).build();
    }

    private List<RadarProblem> getUpdatedProblems(long startTimestamp, long modifiedAfterTimestamp, long lastScanTimestamp) throws BugTrackerException {
        try {
            boolean isInitialSync = lastScanTimestamp == 0L;
            List<String> problemIds = this.client.findProblemIds(this.components, this.componentBundles, this.componentBundleGroups, startTimestamp, modifiedAfterTimestamp, this.keywords, isInitialSync);
            LOGGER.debug("There are {} problems to synchronize", (Object)problemIds.size());
            return this.client.getProblemData(problemIds, this.customFields.extractFirstList());
        }
        catch (IOException | JsonSerializationException e) {
            throw new BugTrackerException("API error during synchronization", e);
        }
    }

    private Map<TeamscaleIssueId, Long> performCleanupAndReturnDeletedItems(long startTimestamp, long onlyItemsChangedAfterTimestamp) throws BugTrackerException, StorageException {
        return new WorkItemCleaner<TeamscaleIssue>(this.getWorkItemIndex(), this.getIssueHistoryIndex(), this.getConnectorId(), this.cleanupStrategy).performCleanupIfNecessary(this.getCurrentImportStart(), () -> new HashSet<String>(this.client.findProblemIds(this.components, this.componentBundles, this.componentBundleGroups, startTimestamp, onlyItemsChangedAfterTimestamp, this.keywords, true)));
    }
}

