/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.radar.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.index.issues.radar.client.RadarComponentNameQuery;
import com.teamscale.index.issues.radar.client.RadarFindProblemIDsQuery;
import com.teamscale.index.issues.radar.client.RadarKeywordQuery;
import com.teamscale.index.issues.radar.model.RadarAuthenticationToken;
import com.teamscale.index.issues.radar.model.RadarComponent;
import com.teamscale.index.issues.radar.model.RadarComponentBundle;
import com.teamscale.index.issues.radar.model.RadarComponentBundleGroup;
import com.teamscale.index.issues.radar.model.RadarKeyword;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import org.jspecify.annotations.NonNull;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.HeaderMap;
import retrofit2.http.POST;
import retrofit2.http.Path;

interface IRadarApi
extends IRetrofitApi {
    @GET(value="signon")
    public RadarAuthenticationToken requestAuthenticationToken(@Header(value="X-Apple-Client-App-ID") long var1, @Header(value="X-Apple-IDMS-A3-Token") String var3, @Header(value="X-Apple-User-ID") String var4) throws ServiceCallException;

    @POST(value="problems/find")
    public List<Long> findProblems(@Body RadarFindProblemIDsQuery var1) throws ServiceCallException;

    @GET(value="problems/{ids}")
    public Call<ResponseBody> getProblems(@Path(value="ids", encoded=true) String var1, @HeaderMap Map<String, String> var2);

    @POST(value="keywords/find")
    public List<RadarKeyword> findKeyword(@Body RadarKeywordQuery var1) throws ServiceCallException;

    @GET(value="components/{name}/{version}")
    public RadarComponent getComponent(@Path(value="name") String var1, @Path(value="version") @NonNull String var2) throws ServiceCallException;

    @POST(value="component-bundles/find")
    public List<RadarComponentBundle> findComponentBundles(@Body RadarComponentNameQuery var1) throws ServiceCallException;

    @POST(value="component-bundle-groups/find")
    public List<RadarComponentBundleGroup> findComponentBundleGroups(@Body RadarComponentNameQuery var1) throws ServiceCallException;
}

