/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import java.util.Set;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

public class ProjectVersion45RepositoryConnectorsAddTestingIntegrationOption {
    private static final String ENABLE_TESTING_INTEGRATION_OPTION_NAME = "Enable Testing integration for merge requests";
    private static final String ENABLE_TEST_GAP_INTEGRATION_OPTION_NAME = "Enable Test Gap integration for merge requests";
    private static final Set<String> CONNECTOR_TYPES_TO_MIGRATE = Set.of("Gerrit", "Artificial Merge Request Connector", "SCM-Manager", "Gitea", "Azure DevOps Git", "GitLab", "GitHub", "Bitbucket Cloud", "Bitbucket Server (On-Premise)");

    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        holder.connectors.replaceAll(ProjectVersion45RepositoryConnectorsAddTestingIntegrationOption::migrateConnectorConfiguration);
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static ConnectorConfiguration migrateConnectorConfiguration(ConnectorConfiguration connectorConfiguration) {
        if (CONNECTOR_TYPES_TO_MIGRATE.contains(connectorConfiguration.getType())) {
            boolean isTestGapIntegrationEnabled = Boolean.parseBoolean(connectorConfiguration.getOptionValue(ENABLE_TEST_GAP_INTEGRATION_OPTION_NAME));
            connectorConfiguration.setOptionValue(ENABLE_TESTING_INTEGRATION_OPTION_NAME, Boolean.toString(isTestGapIntegrationEnabled));
        }
        return connectorConfiguration;
    }
}

