/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications.findings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.notifications.INotificationRule;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.notifications.findings.EFindingsNotificationTrigger;
import com.teamscale.index.tracking.FindingChurnList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class FindingsNotificationRule
implements INotificationRule,
Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private static final String RULE_NAME_PROPERTY = "ruleName";
    private static final String COMMITTERS_PROPERTY = "committers";
    private static final String PROJECTS_PROPERTY = "projects";
    private static final String TRIGGERS_PROPERTY = "triggers";
    private static final String EXCLUDED_CATEGORIES_PROPERTY = "excludedCategories";
    private static final String EXCLUDED_GROUPS_PROPERTY = "excludedGroups";
    private static final String EXCLUDED_ASSESSMENTS_PROPERTY = "excludedAssessments";
    @JsonProperty(value="ruleName")
    private final String ruleName;
    @JsonProperty(value="committers")
    private final List<String> committers;
    @JsonProperty(value="projects")
    private final List<String> projects;
    @JsonProperty(value="triggers")
    private final List<EFindingsNotificationTrigger> triggers;
    @JsonProperty(value="excludedCategories")
    private final List<String> excludedCategories;
    @JsonProperty(value="excludedGroups")
    private final List<String> excludedGroups;
    @JsonProperty(value="excludedAssessments")
    private final List<String> excludedAssessments;
    @JsonIgnore
    private transient InclusionFilter inclusionFilter;

    @JsonCreator
    public FindingsNotificationRule(@JsonProperty(value="ruleName") String ruleName, @JsonProperty(value="committers") List<String> committers, @JsonProperty(value="projects") List<String> projects, @JsonProperty(value="triggers") List<EFindingsNotificationTrigger> triggers, @JsonProperty(value="excludedCategories") List<String> excludedCategories, @JsonProperty(value="excludedGroups") List<String> excludedGroups, @JsonProperty(value="excludedAssessments") List<String> excludedAssessments) {
        this.ruleName = ruleName;
        this.committers = committers;
        this.projects = projects;
        this.triggers = triggers;
        this.excludedCategories = excludedCategories;
        this.excludedGroups = excludedGroups;
        this.excludedAssessments = excludedAssessments;
    }

    public FindingsNotificationRule(String ruleName, List<EFindingsNotificationTrigger> triggers, List<String> excludedCategories, List<String> excludedGroups, List<String> excludedAssessments) {
        this.ruleName = ruleName;
        this.committers = new ArrayList<String>();
        this.projects = new ArrayList<String>();
        this.triggers = triggers;
        this.excludedCategories = excludedCategories;
        this.excludedGroups = excludedGroups;
        this.excludedAssessments = excludedAssessments;
    }

    public boolean matches(NotificationContext notificationContext, String committer, EnumSet<EFindingsNotificationTrigger> activatedTriggers, FindingChurnList findingChurnList) {
        if (!this.isValidRule()) {
            LOGGER.warn("Skipped invalid findings notification rule: " + this.getDescription() + ".");
            return false;
        }
        if (!this.committers.isEmpty() && !this.committers.contains(committer)) {
            LOGGER.debug("Rule {}: Committer {} is not in the list of committers", (Object)this.ruleName, (Object)committer);
            return false;
        }
        if (!this.projects.isEmpty() && CollectionUtils.intersectionSet((Collection)CollectionUtils.map(notificationContext.getPublicIds(), ProjectIdBase::toString), (Collection[])new Collection[]{this.projects}).isEmpty()) {
            LOGGER.debug("Rule {}: Project {} is not in the list of included projects", (Object)this.ruleName, (Object)notificationContext.getPrimaryPublicId());
            return false;
        }
        if (this.triggers.isEmpty()) {
            LOGGER.debug("Rule {}: User wants to get notified for all commits", (Object)this.ruleName);
            return true;
        }
        for (EFindingsNotificationTrigger trigger : this.triggers) {
            if (!activatedTriggers.contains((Object)trigger) || !this.hasIncludedFindings(trigger, findingChurnList)) continue;
            LOGGER.debug("Rule {}: Matching trigger {}", (Object)this.ruleName, (Object)trigger);
            return true;
        }
        LOGGER.debug("Rule {}: No matching triggers", (Object)this.ruleName);
        return false;
    }

    private boolean isValidRule() {
        return this.committers != null && this.projects != null && this.triggers != null;
    }

    private String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("[ ");
        builder.append("Rule name: " + this.ruleName + "; ");
        builder.append("Included projects: " + String.valueOf(this.projects) + "; ");
        builder.append("Included committers: " + String.valueOf(this.committers) + "; ");
        builder.append("Included triggers: " + String.valueOf(this.triggers) + "; ");
        builder.append("Excluded categories: " + String.valueOf(this.excludedCategories) + "; ");
        builder.append("Excluded assessments: " + String.valueOf(this.excludedAssessments) + "; ");
        builder.append("Excluded groups: " + String.valueOf(this.excludedGroups) + "; ");
        builder.append("]");
        return builder.toString();
    }

    private boolean hasIncludedFindings(EFindingsNotificationTrigger trigger, FindingChurnList findingChurnList) {
        return switch (trigger) {
            case EFindingsNotificationTrigger.ADDED_FINDINGS -> {
                if (findingChurnList != null && this.hasIncludedFinding((Collection<TrackedFinding>)findingChurnList.getAddedFindings())) {
                    yield true;
                }
                yield false;
            }
            case EFindingsNotificationTrigger.FINDINGS_IN_CHANGED_CODE -> {
                if (findingChurnList != null && this.hasIncludedFinding((Collection<TrackedFinding>)findingChurnList.getFindingsInChangedCode())) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private boolean hasIncludedFinding(Collection<TrackedFinding> findings) {
        return findings.stream().anyMatch(this::isIncluded);
    }

    private boolean isIncluded(TrackedFinding trackedFinding) {
        if (this.inclusionFilter == null) {
            this.inclusionFilter = InclusionFilter.of(this.excludedCategories, this.excludedGroups, this.excludedAssessments, this.getRuleName());
        }
        return this.inclusionFilter.isNotExcluded(trackedFinding);
    }

    @Override
    public String getRuleName() {
        return this.ruleName;
    }

    private static final class InclusionFilter {
        private final CaseInsensitiveStringSet excludedCategoriesCaseInsensitive;
        private final CaseInsensitiveStringSet excludedGroupsCaseInsensitive;
        private final Set<ETrafficLightColor> excludedAssessmentColors;

        private InclusionFilter(CaseInsensitiveStringSet excludedCategoriesCaseInsensitive, CaseInsensitiveStringSet excludedGroupsCaseInsensitive, Set<ETrafficLightColor> excludedAssessmentColors) {
            this.excludedCategoriesCaseInsensitive = excludedCategoriesCaseInsensitive;
            this.excludedGroupsCaseInsensitive = excludedGroupsCaseInsensitive;
            this.excludedAssessmentColors = excludedAssessmentColors;
        }

        public static InclusionFilter of(List<String> excludedCategories, List<String> excludedGroups, List<String> excludedAssessments, String ruleName) {
            CaseInsensitiveStringSet excludedCategoriesCaseInsensitive = new CaseInsensitiveStringSet((Collection)CollectionUtils.emptyIfNull(excludedCategories));
            CaseInsensitiveStringSet excludedGroupsCaseInsensitive = new CaseInsensitiveStringSet((Collection)CollectionUtils.emptyIfNull(excludedGroups));
            EnumSet<ETrafficLightColor> excludedAssessmentColors = EnumSet.noneOf(ETrafficLightColor.class);
            for (String assessmentString : CollectionUtils.emptyIfNull(excludedAssessments)) {
                ETrafficLightColor assessment = (ETrafficLightColor)EnumUtils.valueOfIgnoreCase(ETrafficLightColor.class, (String)assessmentString);
                if (assessment != null) {
                    excludedAssessmentColors.add(assessment);
                    continue;
                }
                LOGGER.warn("Encountered invalid excluded assessment color: {} - in notification rule {}", (Object)assessmentString, (Object)ruleName);
            }
            return new InclusionFilter(excludedCategoriesCaseInsensitive, excludedGroupsCaseInsensitive, excludedAssessmentColors);
        }

        public boolean isNotExcluded(TrackedFinding trackedFinding) {
            boolean isExcludedByCategory = this.excludedCategoriesCaseInsensitive.contains((Object)trackedFinding.getCategoryName());
            boolean isExcludedByGroup = this.excludedGroupsCaseInsensitive.contains((Object)trackedFinding.getGroupName());
            boolean isExcludedByAssessment = this.excludedAssessmentColors.contains(trackedFinding.getAssessment());
            return !isExcludedByCategory && !isExcludedByGroup && !isExcludedByAssessment;
        }
    }
}

