/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.precommit;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@Option(id="precommit.limit.options", name="Pre-Commit Limits", type=EOptionType.SERVER, category=EOptionCategory.LIMITS, orderingHint=100)
@IndexValueClass(containedInBackup=true)
public class PreCommitLimitsOption
implements IOption {
    private static final String MAX_COMMIT_AGE_PROPERTY = "maxCommitAge";
    private static final int MAX_COMMIT_AGE_DEFAULT = 7;
    private static final String MAX_USER_BRANCHES_PROPERTY = "maxUserBranches";
    private static final int MAX_USER_BRANCHES_DEFAULT = 10;
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "precommit.limit.options";
    public static final String OPTION_NAME = "Pre-Commit Limits";
    public static final String FILE_SIZE_UNIT_EXPLANATION = "The size can be given with a unit [B, KB, KiB, MB, MiB, GB, GiB]. A size without unit is interpreted as bytes.";
    @JsonProperty(value="fileCount")
    @OptionFieldDescription(name="Maximum number of added or modified files per pre-commit analysis")
    public int fileCount = 20;
    @JsonProperty(value="fileSize")
    @OptionFieldDescription(name="Maximum size per file per pre-commit analysis", description="The size can be given with a unit [B, KB, KiB, MB, MiB, GB, GiB]. A size without unit is interpreted as bytes.")
    public String fileSize = "1 MB";
    @JsonProperty(value="timeLimit")
    @OptionFieldDescription(name="Minimum waiting time between two pre-commit analyses per user (in seconds)")
    public int timeLimit = 5;
    @JsonProperty(value="maxCommitAge")
    @OptionFieldDescription(name="Maximum age of the last commit to a pre-commit branch (in days)", description="Branches whose last commit exceeds the maximum age are discarded wholesale on a daily basis; they are not rejected immediately.")
    private @Nullable Integer maxCommitAge = 7;
    @JsonProperty(value="maxUserBranches")
    @OptionFieldDescription(name="Maximum number of pre-commit branches per user", description="Branches exceeding this limit are discarded on a daily basis; they are not rejected immediately.")
    private @Nullable Integer maxUserBranches = 10;

    @JsonGetter(value="maxCommitAge")
    public int getMaxCommitAge() {
        return this.maxCommitAge != null ? this.maxCommitAge : 7;
    }

    public void setMaxCommitAge(int maxCommitAge) {
        this.maxCommitAge = maxCommitAge;
    }

    @JsonGetter(value="maxUserBranches")
    public int getMaxUserBranches() {
        return this.maxUserBranches != null ? this.maxUserBranches : 10;
    }

    public void setMaxUserBranches(int maxUserBranches) {
        this.maxUserBranches = maxUserBranches;
    }

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        if (this.fileCount < 0) {
            return "Maximum number of files per pre-commit analysis  must be positive.";
        }
        try {
            if (FileSystemUtils.parseDataSize((String)this.fileSize) < 0L) {
                return "Maximum size of files per pre-commit analysis  must be positive.";
            }
        }
        catch (NumberFormatException e) {
            return "Maximum size of files per pre-commit analysis is not a valid size.";
        }
        if (this.timeLimit < 0) {
            return "Minimum waiting time between pre-commit analyses per user must be positive.";
        }
        if (this.getMaxCommitAge() < 0) {
            return "Maximum age of the last commit to a pre-commit branch must be positive.";
        }
        if (this.getMaxUserBranches() < 0) {
            return "Maximum number of pre-commit branches per user must be positive.";
        }
        return null;
    }
}

