/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.dotnet.LookupBasedCoverageCreator;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class OpenCoverCoverageHandler
extends DefaultHandler {
    private final LookupBasedCoverageCreator coverageCreator;
    private SetMap<Integer, BranchPointInfo> branchPointInfosByFileId;

    OpenCoverCoverageHandler(LookupBasedCoverageCreator coverageCreator) {
        this.coverageCreator = coverageCreator;
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.coverageCreator.storeCoverageInfo();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        Optional<EElement> element = EElement.forXmlName(localName);
        if (!element.isPresent()) {
            return;
        }
        switch (element.get().ordinal()) {
            case 0: {
                this.registerFileId(attributes);
                break;
            }
            case 1: {
                this.collectCoveredLine(attributes);
                break;
            }
            case 2: {
                this.branchPointInfosByFileId = new SetMap();
                break;
            }
            case 3: {
                this.collectBranchPointCoverage(attributes);
                break;
            }
        }
    }

    private void collectCoveredLine(Attributes attributes) {
        int startLine = OpenCoverCoverageHandler.getIntValue(attributes, EAttribute.STATEMENT_START_LINE);
        int endLine = OpenCoverCoverageHandler.getIntValue(attributes, EAttribute.STATEMENT_END_LINE);
        int fileId = OpenCoverCoverageHandler.getIntValue(attributes, EAttribute.OTHER_ALTERNATE_FILE_ID);
        int visitCount = OpenCoverCoverageHandler.getIntValue(attributes, EAttribute.VISIT_COUNT);
        ELineCoverage coverage = ELineCoverage.NOT_COVERED;
        if (visitCount > 0) {
            coverage = ELineCoverage.FULLY_COVERED;
        }
        this.coverageCreator.addLineCoverage(fileId, startLine, endLine, coverage);
    }

    private void collectBranchPointCoverage(Attributes attributes) {
        int fileId = OpenCoverCoverageHandler.getIntValue(attributes, EAttribute.OTHER_ALTERNATE_FILE_ID);
        int startLine = OpenCoverCoverageHandler.getIntValue(attributes, EAttribute.STATEMENT_START_LINE);
        int visitCount = OpenCoverCoverageHandler.getIntValue(attributes, EAttribute.VISIT_COUNT);
        BranchPointInfo branchPointInfo = new BranchPointInfo(startLine, visitCount);
        this.branchPointInfosByFileId.add((Object)fileId, (Object)branchPointInfo);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        Optional<EElement> element = EElement.forXmlName(localName);
        if (!element.isPresent()) {
            return;
        }
        if (element.get() == EElement.CONDITIONAL_BRANCH_POINT_GROUP) {
            this.collectCoverageFromBranchPoints();
            this.branchPointInfosByFileId.clear();
        }
    }

    private void collectCoverageFromBranchPoints() {
        for (Integer fileId : this.branchPointInfosByFileId.getKeys()) {
            Set branchPointsForFile = (Set)this.branchPointInfosByFileId.getCollection((Object)fileId);
            ListMap startLinesWithVisitCounts = new ListMap();
            branchPointsForFile.forEach(branchPointInfo -> startLinesWithVisitCounts.add((Object)branchPointInfo.startLine, (Object)branchPointInfo.visitCount));
            for (Integer line : startLinesWithVisitCounts.getKeys()) {
                List visitCountsForLine = (List)startLinesWithVisitCounts.getCollection((Object)line);
                ELineCoverage coverage = OpenCoverCoverageHandler.determineCoverageForMultipleVisitCounts(visitCountsForLine);
                this.coverageCreator.setLineCoverage(fileId.intValue(), line.intValue(), line.intValue(), coverage);
            }
        }
    }

    private static ELineCoverage determineCoverageForMultipleVisitCounts(List<Integer> visitCountsForLine) {
        boolean anyVisits = false;
        boolean missedVisits = false;
        for (Integer visitCount : visitCountsForLine) {
            if (visitCount > 0) {
                anyVisits = true;
            }
            if (visitCount != 0) continue;
            missedVisits = true;
        }
        ELineCoverage coverage = ELineCoverage.NOT_COVERED;
        if (anyVisits) {
            coverage = ELineCoverage.PARTIALLY_COVERED;
            if (!missedVisits) {
                return ELineCoverage.FULLY_COVERED;
            }
        }
        return coverage;
    }

    private void registerFileId(Attributes attributes) {
        int sourceFileID = OpenCoverCoverageHandler.getIntValue(attributes, EAttribute.UNIQUE_FILE_ID);
        String fullPath = attributes.getValue(EAttribute.SOURCE_FILE_PATH.xmlAttributeName);
        this.coverageCreator.storeFileMapping(sourceFileID, fullPath);
    }

    private static int getIntValue(Attributes attributes, EAttribute name) {
        return Integer.parseInt(attributes.getValue(name.xmlAttributeName));
    }

    private static enum EElement {
        FILE("File"),
        SEQUENCE_POINT("SequencePoint"),
        CONDITIONAL_BRANCH_POINT_GROUP("BranchPoints"),
        CONDITION_STATEMENT_POINT("BranchPoint");

        private String xmlAttributeName;

        private EElement(String xmlAttributeName) {
            this.xmlAttributeName = xmlAttributeName;
        }

        private static Optional<EElement> forXmlName(String xmlAttributeName) {
            return EnumSet.allOf(EElement.class).stream().filter(enumValue -> enumValue.xmlAttributeName.equals(xmlAttributeName)).findFirst();
        }
    }

    private static enum EAttribute {
        FILE_ID("id"),
        UNIQUE_FILE_ID("uid"),
        SOURCE_FILE_PATH("fullPath"),
        STATEMENT_START_LINE("sl"),
        STATEMENT_END_LINE("el"),
        OTHER_ALTERNATE_FILE_ID("fileid"),
        VISIT_COUNT("vc");

        private String xmlAttributeName;

        private EAttribute(String xmlAttributeName) {
            this.xmlAttributeName = xmlAttributeName;
        }
    }

    private static class BranchPointInfo {
        private final int startLine;
        private final int visitCount;

        private BranchPointInfo(int startLine, int visitCount) {
            this.startLine = startLine;
            this.visitCount = visitCount;
        }
    }
}

