/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.filesystem;

import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.FileSystemAccessOption;
import com.teamscale.index.repository.base.RepositoryConnectorDescriptorBase;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public abstract class FileSystemRepositoryConnectorDescriptorBase
extends RepositoryConnectorDescriptorBase {
    public static final String DEFAULT_BRANCH_NAME = "default";
    @ConfigExposed(name="Input directory", description="The directory containing the code.", required=true)
    protected String inputDir;
    public static final String INPUT_DIRECTORY_OPTION = "Input directory";

    protected FileSystemRepositoryConnectorDescriptorBase(ERepositoryConnector connectorType) {
        super(connectorType, DEFAULT_BRANCH_NAME);
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        this.checkNotEmpty(this.inputDir, INPUT_DIRECTORY_OPTION);
        triggerBuilder.setTriggerParameter("input-directory", this.inputDir);
        super.setCommonParameters(triggerBuilder, triggerCreator);
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        if (StringUtils.isEmpty((String)this.inputDir)) {
            throw new ConnectorValidationException("Please enter an input directory path!");
        }
        try {
            ServerOptionIndex serverOptionIndex = (ServerOptionIndex)this.getContext().getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class);
            FileSystemAccessOption.getOption((ServerOptionIndex)serverOptionIndex).validateConnectorAccess(Paths.get(this.inputDir, new String[0]));
        }
        catch (StorageException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
        File file = new File(this.inputDir);
        if (!file.isDirectory()) {
            throw new ConnectorValidationException("Directory does not exist: " + this.inputDir);
        }
        if (!file.canRead()) {
            throw new ConnectorValidationException("Cannot read from directory: " + this.inputDir);
        }
    }

    @Override
    protected boolean validateRevision(String revision) {
        return false;
    }

    @Override
    protected URI getRepositoryUri() {
        return new File(this.inputDir).toURI();
    }

    @Override
    protected boolean hasPreselectedUIBranchBeforeBranchTransformationUnlikeDefaultBranch(String preselectedUIBranchBeforeTransform) {
        return false;
    }
}

