/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.git.gerrit.data.ChangeInfo;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class RevisionInfo
implements Comparable<RevisionInfo> {
    private static final String NUMBER_PROPERTY = "_number";
    private static final String CREATED_PROPERTY = "created";
    private static final String UPDATED_PROPERTY = "updated";
    @JsonProperty(value="_number")
    private final long number;
    @JsonProperty(value="created")
    private final String created;
    @JsonProperty(value="updated")
    private final String updated;

    @JsonCreator
    public RevisionInfo(@JsonProperty(value="_number") long number, @JsonProperty(value="created") String created, @JsonProperty(value="updated") String updated) {
        this.number = number;
        this.created = created;
        this.updated = updated;
    }

    @Override
    public int compareTo(RevisionInfo other) {
        return Long.compare(this.getNumber(), other.getNumber());
    }

    public Instant getCreationInstant() {
        return LocalDateTime.parse(this.created, ChangeInfo.GERRIT_TIMESTAMP_FORMATTER).toInstant(ZoneOffset.UTC);
    }

    public Instant getUpdateInstant() {
        return LocalDateTime.parse(this.updated, ChangeInfo.GERRIT_TIMESTAMP_FORMATTER).toInstant(ZoneOffset.UTC);
    }

    public String toString() {
        return "RevisionInfo{number=" + this.number + ", created='" + this.created + "'}";
    }

    public long getNumber() {
        return this.number;
    }

    public String getCreated() {
        return this.created;
    }

    public String getUpdated() {
        return this.updated;
    }
}

